/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.source.authmodel;

import com.kingdee.bos.qing.data.domain.source.db.util.AESUtil;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIAuthException;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.AbstractAuthModel;
import com.kingdee.bos.qing.data.util.DigestUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jdom2.Element;

public class DigestAuthModel
extends AbstractAuthModel {
    private String userName;
    private String psw;

    @Override
    protected AbstractAuthModel.OpenAPIAuthType getType() {
        return AbstractAuthModel.OpenAPIAuthType.DIGEST;
    }

    @Override
    public Map<String, String> createRequestHeads(String url) throws OpenAPIAuthException {
        HashMap<String, String> headsMap = new HashMap<String, String>(1);
        try {
            String deCodePsw = new String(Base64.decodeBase64((String)this.psw), "UTF-8");
            String authorization = DigestUtil.getRequestHeads(this.userName, deCodePsw, url);
            headsMap.put("Authorization", authorization);
        }
        catch (Exception e) {
            throw new OpenAPIAuthException(e.getMessage());
        }
        return headsMap;
    }

    @Override
    protected Element innerToXml() {
        Element node = new Element("AuthModel");
        node.setAttribute("userName", this.userName);
        node.setAttribute("password", AESUtil.aesByString(this.psw, 1));
        return node;
    }

    @Override
    public void fromXml(Element node) throws ModelParseException {
        this.userName = node.getAttributeValue("userName");
        this.psw = AESUtil.aesByString(node.getAttributeValue("password"), 2);
        this.setAuthType(AbstractAuthModel.OpenAPIAuthType.DIGEST);
    }

    @Override
    public AbstractAuthModel instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, AbstractAuthModel.AuthModelJsonDecoder jsonDecoder) {
        if (AbstractAuthModel.OpenAPIAuthType.DIGEST.toPersistance().equals(json.getAttrValue("authType"))) {
            return jsonDecoder.fromJson2(json, DigestAuthModel.class);
        }
        return null;
    }

    @Override
    public boolean isErrorParam() {
        return StringUtils.isBlank((CharSequence)this.userName) || StringUtils.isBlank((CharSequence)this.psw);
    }

    @Override
    public String getAuthModelHashCode() {
        return DigestUtils.md5Hex((String)(this.userName + this.psw));
    }
}

