/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.source.AbstractBizMetaSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.ExcelSource;
import com.kingdee.bos.qing.data.model.designtime.source.FileSavableDBSource;
import com.kingdee.bos.qing.data.model.designtime.source.OpenAPISource;
import com.kingdee.bos.qing.data.model.designtime.source.TextSource;
import com.kingdee.bos.qing.data.model.designtime.source.XMLSource;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.AbstractAuthModel;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

public class SourceFactory {
    private static Map<String, Class<? extends AbstractBizMetaSource>> bizMetaSourceImpMap = new HashMap<String, Class<? extends AbstractBizMetaSource>>();
    private static EnumMap<SourceType, ISourceCreator> map = new EnumMap(SourceType.class);
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();

    private SourceFactory() {
    }

    public static void regist(SourceType sourceType, ISourceCreator sourceCreator) {
        map.put(sourceType, sourceCreator);
    }

    public static void registBizMetaSource(String bizMetaType, Class<? extends AbstractBizMetaSource> bizMetaSourceClass) {
        bizMetaSourceImpMap.put(bizMetaType, bizMetaSourceClass);
    }

    public static <T> T decodeFromJson(String jsonString, Class<T> clz) {
        return (T)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)jsonString, clz);
    }

    public static AbstractSource instanceFromXml(Element sourceElement) throws ModelParseException {
        String type = sourceElement.getAttributeValue("type");
        SourceType sourceType = SourceType.fromPersistance(type);
        AbstractSource source = null;
        ISourceCreator sourceCreator = map.get((Object)sourceType);
        if (sourceCreator != null && (source = sourceCreator.createSource(sourceElement)) != null) {
            source.fromXml(sourceElement);
        }
        return source;
    }

    public static AbstractSource instancefromJson(String jsonString) {
        return (AbstractSource)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)jsonString, AbstractSource.class);
    }

    static {
        map.put(SourceType.DB, new DBSourceCreator());
        map.put(SourceType.File, new FileSourceCreator());
        map.put(SourceType.OPENAPI, new OpenAPISourceCreator());
        map.put(SourceType.BizMeta, new BizMetaSourceCreator());
        customJsonParser.addCustomDecoder(AbstractSource.class, (JsonUtil.AbstractJsonDecoder)new SourceJsonDecoder());
        customJsonParser.addCustomDecoder(AbstractAuthModel.class, (JsonUtil.AbstractJsonDecoder)new AbstractAuthModel.AuthModelJsonDecoder());
    }

    private static class FileSourceCreator
    implements ISourceCreator {
        private FileSourceCreator() {
        }

        @Override
        public AbstractSource createSource(Element node) throws ModelParseException {
            String fileType = node.getAttributeValue("fileType");
            if ("EXCEL".equals(fileType)) {
                return new ExcelSource();
            }
            if ("XML".equals(fileType)) {
                return new XMLSource();
            }
            return new TextSource();
        }

        @Override
        public AbstractSource instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, SourceJsonDecoder jsonDecoder) {
            if (json.hasAttr("fileType")) {
                if (json.getAttrValue("fileType").equals("EXCEL")) {
                    return jsonDecoder.fromJson2(json, ExcelSource.class);
                }
                if (json.getAttrValue("fileType").equals("XML")) {
                    return jsonDecoder.fromJson2(json, XMLSource.class);
                }
                return jsonDecoder.fromJson2(json, TextSource.class);
            }
            return null;
        }
    }

    private static class OpenAPISourceCreator
    implements ISourceCreator {
        private OpenAPISourceCreator() {
        }

        @Override
        public AbstractSource createSource(Element node) throws ModelParseException {
            return new OpenAPISource();
        }

        @Override
        public AbstractSource instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, SourceJsonDecoder jsonDecoder) {
            if (json.hasAttr("openAPIType")) {
                return jsonDecoder.fromJson2(json, OpenAPISource.class);
            }
            return null;
        }
    }

    private static class BizMetaSourceCreator
    implements ISourceCreator {
        private BizMetaSourceCreator() {
        }

        @Override
        public AbstractSource createSource(Element node) throws ModelParseException {
            String bizMetaType = node.getAttributeValue("bizMetaType");
            Class bizMetaSourceClass = (Class)bizMetaSourceImpMap.get(bizMetaType);
            try {
                if (bizMetaSourceClass != null) {
                    return (AbstractSource)bizMetaSourceClass.newInstance();
                }
            }
            catch (Exception e) {
                throw new ModelParseException("Unknown BizMetaType:" + bizMetaType, e);
            }
            return null;
        }

        @Override
        public AbstractSource instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, SourceJsonDecoder jsonDecoder) {
            if (json.hasAttr("bizMetaType")) {
                String bizMetaType = json.getAttrValue("bizMetaType");
                Class bizMetaSourceClass = (Class)bizMetaSourceImpMap.get(bizMetaType);
                if (bizMetaSourceClass != null) {
                    return jsonDecoder.fromJson2(json, bizMetaSourceClass);
                }
            }
            return null;
        }
    }

    private static class DBSourceCreator
    implements ISourceCreator {
        private DBSourceCreator() {
        }

        @Override
        public AbstractSource createSource(Element node) throws ModelParseException {
            String dbType = node.getAttributeValue("dbType");
            if ("SQLITE".equals(dbType) || "ACCESS".equals(dbType)) {
                return new FileSavableDBSource();
            }
            return new DBSource();
        }

        @Override
        public AbstractSource instanceFromJson(JsonUtil.AbstractJsonDecoder.Json json, SourceJsonDecoder jsonDecoder) {
            if (json.hasAttr("dbType")) {
                String dbType = json.getAttrValue("dbType");
                if ("SQLITE".equals(dbType) || "ACCESS".equals(dbType)) {
                    return jsonDecoder.fromJson2(json, FileSavableDBSource.class);
                }
                return jsonDecoder.fromJson2(json, DBSource.class);
            }
            return null;
        }
    }

    public static interface ISourceCreator {
        public AbstractSource createSource(Element var1) throws ModelParseException;

        public AbstractSource instanceFromJson(JsonUtil.AbstractJsonDecoder.Json var1, SourceJsonDecoder var2);
    }

    public static class SourceJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractSource> {
        protected final AbstractSource decode(JsonUtil.AbstractJsonDecoder.Json json) {
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                ISourceCreator sourceCreator = (ISourceCreator)entry.getValue();
                AbstractSource source = sourceCreator.instanceFromJson(json, this);
                if (source == null) continue;
                return source;
            }
            return null;
        }

        public <U extends AbstractSource> AbstractSource fromJson2(JsonUtil.AbstractJsonDecoder.Json json, Class<U> clz) {
            return (AbstractSource)this.fromJson(json, clz);
        }
    }
}

