/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.google.gson.JsonObject;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.environment.IEnvironmentStrategy;
import com.kingdee.bos.qing.data.exception.api.OpenAPIAuthException;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.CosmicAuthModel;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

public class TokenUtil {
    private static final String GET_APP_TOKEN = "/api/getAppToken.do";
    private static final String GET_ACCESS_TOKEN = "/api/login.do";
    private static final String LANGUAGE = "zh_CN";

    public static String getAccessToken(CosmicAuthModel cosmicAuthModel, Map headsMap) throws IntegratedRuntimeException, OpenAPIAuthException {
        QingContext qingContext = QingContext.getCurrent();
        String cosmicServerAddress = cosmicAuthModel.getCosmicServerAddress();
        String accountId = cosmicAuthModel.getAccountId();
        String tenantId = cosmicAuthModel.getTenantId();
        if (CosmicAuthModel.CosmicType.Local == cosmicAuthModel.getCosmicType()) {
            IEnvironmentStrategy strategy = (IEnvironmentStrategy)CustomStrategyRegistrar.getStrategy(IEnvironmentStrategy.class);
            if (strategy != null && strategy.isCosmicEnv()) {
                cosmicServerAddress = strategy.getDomainContextUrl();
                accountId = qingContext.getAccountId();
                tenantId = qingContext.getTenantId();
            } else {
                throw new OpenAPIAuthException(2061304);
            }
        }
        headsMap.put("serverAddress", cosmicServerAddress);
        String userType = cosmicAuthModel.getUserType().toPersistance();
        String userTypeValue = cosmicAuthModel.getUserTypeValue();
        StringBuilder sb = new StringBuilder("COSMIC_");
        sb.append(cosmicAuthModel.getAppId()).append(cosmicAuthModel.getAppSecret()).append("_").append(userType).append("_").append(userTypeValue).append("_").append(accountId).append("_").append(tenantId).append("_").append(cosmicServerAddress);
        String cacheKey = sb.toString();
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        String accessToken = globalQingSession.get(cacheKey);
        if (accessToken == null) {
            accessToken = TokenUtil.createAccessToken(cosmicServerAddress, userType, userTypeValue, accountId, tenantId, cosmicAuthModel.getAppId(), cosmicAuthModel.getAppSecret());
            globalQingSession.set(cacheKey, accessToken, 1, TimeUnit.HOURS);
        }
        return accessToken;
    }

    public static String createAccessToken(String cosmicServerAddress, String userType, String userTypeValue, String accountId, String tenantId, String appId, String appSecret) {
        String appToken = TokenUtil.createAppToken(cosmicServerAddress, accountId, tenantId, appId, appSecret);
        HashMap<String, String> requestBody = new HashMap<String, String>(5);
        requestBody.put("accountId", accountId);
        requestBody.put("tenantid", tenantId);
        requestBody.put("apptoken", appToken);
        requestBody.put("usertype", userType);
        requestBody.put("user", userTypeValue);
        String accessTokenResult = HttpUtil.post((String)(cosmicServerAddress + GET_ACCESS_TOKEN), null, (String)JsonUtil.encodeToString(requestBody));
        JsonObject jsonObject = (JsonObject)JsonUtil.decodeFromString((String)accessTokenResult, JsonObject.class);
        JsonObject resultObject = jsonObject.getAsJsonObject("data");
        String accessToken = resultObject.get("access_token").getAsString();
        return accessToken;
    }

    public static String createAppToken(String cosmicServerAddress, String accountId, String tenantId, String appId, String appSecret) {
        HashMap<String, String> requestBody = new HashMap<String, String>(5);
        requestBody.put("appId", appId);
        requestBody.put("appSecret", new String(Base64.decodeBase64((String)appSecret)));
        requestBody.put("tenantid", tenantId);
        requestBody.put("accountId", accountId);
        requestBody.put("language", LANGUAGE);
        String appTokenResult = HttpUtil.post((String)(cosmicServerAddress + GET_APP_TOKEN), null, (String)JsonUtil.encodeToString(requestBody));
        JsonObject jsonObject = (JsonObject)JsonUtil.decodeFromString((String)appTokenResult, JsonObject.class);
        JsonObject resultObject = jsonObject.getAsJsonObject("data");
        String appToken = resultObject.get("app_token").getAsString();
        return appToken;
    }
}

