/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util.valueconvert;

import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import com.kingdee.bos.qing.data.util.valueconvert.ValueHandlerAdapter;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.util.ArrayList;
import java.util.Calendar;

public class RelativeDateValueHandler
extends ValueHandlerAdapter {
    private DataType dataType;

    public RelativeDateValueHandler(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public Object toRuntimeValue(Object originalValue) {
        RelativeDateRange relativeDateRange = (RelativeDateRange)originalValue;
        switch (this.dataType) {
            case DATETIME: {
                RuntimeRelativeDateRange r = new RuntimeRelativeDateRange(relativeDateRange, true);
                r.parseRange();
                return r;
            }
            case DATE: {
                RuntimeRelativeDateRange r = new RuntimeRelativeDateRange(relativeDateRange);
                r.parseRange();
                return r;
            }
        }
        return originalValue;
    }

    @Override
    public Object toDbFilterValue(Object runtimeValue) {
        ArrayList<Calendar> paramValues = new ArrayList<Calendar>();
        RuntimeRelativeDateRange r = (RuntimeRelativeDateRange)runtimeValue;
        paramValues.add(r.getCalendarStart());
        paramValues.add(r.getCalendarEnd());
        return paramValues;
    }
}

