/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.cache;

import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import java.util.concurrent.TimeUnit;

public class DataSourceCache {
    private String _key;
    private String _fileName;
    private static final int EXPIRE_TIME = 3600;

    public DataSourceCache(String key) {
        this._key = key;
        this._fileName = QingSessionUtil.getGlobalQingSessionImpl().get(key);
    }

    public String getKey() {
        return this._key;
    }

    public boolean exists() {
        return FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)this._fileName).exists();
    }

    public boolean remove() {
        QingSessionUtil.getGlobalQingSessionImpl().remove(this._key);
        return FileFactory.newFileUpdater(null, (AbstractQingFileType)QingTempFileType.TEMP_QS, (String)this._fileName).delete();
    }

    public IDataSourceWriter createWriter() {
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
        this._fileName = qingFile.getName();
        QingSessionUtil.getGlobalQingSessionImpl().set(this._key, qingFile.getName(), 3600, TimeUnit.SECONDS);
        return new QSDataSourceWriter(qingFile);
    }

    public IDataSourceVisitor createVisitor() throws AbstractDataSourceException {
        IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)this._fileName);
        return new QSDataSourceVisitor(qingFileVisitor);
    }
}

