/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.datasource.util.ConvertUtil;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergeSortData {
    private MetaInfo _orderMetaInfo;
    private Set<DSFieldKey> _allFields = new HashSet<DSFieldKey>(16);
    private int _orderFieldIndex = 0;
    private DSFieldKey _orderBy;
    private boolean _sortByString;
    private Map<String, Integer> _fieldIndexMap;
    private List<IQingFile> _smallSortedDataFiles = new ArrayList<IQingFile>();
    private List<Object[]> _rowsForWrite = new ArrayList<Object[]>();
    private static final String DATAITERATOR_KEY = ".DATAITERATOR_KEY.";
    private Comparator<Object[]> objectArrayComparator = new Comparator<Object[]>(){

        @Override
        public int compare(Object[] o1, Object[] o2) {
            Comparable leftValue = (Comparable)o1[MergeSortData.this._orderFieldIndex];
            Comparable rightValue = (Comparable)o2[MergeSortData.this._orderFieldIndex];
            return MergeSortData.this.interCompare(leftValue, rightValue);
        }
    };
    private Comparator<Map<String, Object>> mapComparator = new Comparator<Map<String, Object>>(){

        @Override
        public int compare(Map<String, Object> leftMap, Map<String, Object> rightMap) {
            Comparable leftValue = (Comparable)leftMap.get(MergeSortData.this._orderBy.toFullName());
            Comparable rightValue = (Comparable)rightMap.get(MergeSortData.this._orderBy.toFullName());
            return MergeSortData.this.interCompare(leftValue, rightValue);
        }
    };

    public MergeSortData(MetaInfo orderMetaInfo, DSFieldKey orderBy, boolean sortByString) {
        this._orderMetaInfo = orderMetaInfo;
        this._orderBy = orderBy;
        this._sortByString = sortByString;
        List unmodifiableFieldNames = orderMetaInfo.getFieldNames();
        this._fieldIndexMap = new HashMap<String, Integer>(unmodifiableFieldNames.size());
        for (int columnIndex = 0; columnIndex < unmodifiableFieldNames.size(); ++columnIndex) {
            String fieldName = (String)unmodifiableFieldNames.get(columnIndex);
            DSFieldKey dsField = new DSFieldKey(fieldName);
            this._fieldIndexMap.put(fieldName, columnIndex);
            this._allFields.add(dsField);
            if (!orderBy.equals((Object)dsField)) continue;
            this._orderFieldIndex = columnIndex;
        }
    }

    public void addRow(Map<String, ?> row) throws AbstractDataSourceException, InterruptedException {
        Object[] rowData = this.mapToObject(this._fieldIndexMap, row);
        this._rowsForWrite.add(rowData);
        if (this._rowsForWrite.size() == 10000) {
            this.flushToDisk();
        }
    }

    private void flushToDisk() throws AbstractDataSourceException, InterruptedException {
        if (this._rowsForWrite.isEmpty()) {
            return;
        }
        Collections.sort(this._rowsForWrite, this.objectArrayComparator);
        IQingFile smallSortedFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
        this._smallSortedDataFiles.add(smallSortedFile);
        QSDataSourceWriter smallSortedDataSourceWriter = null;
        Throwable exception = null;
        try {
            smallSortedDataSourceWriter = new QSDataSourceWriter(smallSortedFile);
            smallSortedDataSourceWriter.start(this._orderMetaInfo);
            for (Object[] row : this._rowsForWrite) {
                smallSortedDataSourceWriter.writeData(row);
            }
            smallSortedDataSourceWriter.finishWriteData();
        }
        catch (AbstractDataSourceException e) {
            exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            exception = e;
            throw e;
        }
        finally {
            if (smallSortedDataSourceWriter != null) {
                smallSortedDataSourceWriter.close((Exception)exception);
                smallSortedDataSourceWriter = null;
            }
            if (exception != null) {
                this.deleteSmallSortedFiles();
            }
            this._rowsForWrite.clear();
        }
    }

    public IQingFile mergeFile() throws AbstractDataSourceException, InterruptedException {
        IDataSourceWriter mergeDataFileSourceWriter = null;
        IQingFile mergeDataFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
        List<IDataIterator> smallSortedFileDataIerators = null;
        Throwable exception = null;
        try {
            int insertIndex;
            Map oneRow;
            if (this._rowsForWrite.size() > 0) {
                this.flushToDisk();
            }
            if (this._smallSortedDataFiles.isEmpty()) {
                IQingFile iQingFile = null;
                return iQingFile;
            }
            if (this._smallSortedDataFiles.size() == 1) {
                IQingFile dataFile;
                IQingFile iQingFile = dataFile = this._smallSortedDataFiles.remove(0);
                return iQingFile;
            }
            smallSortedFileDataIerators = this.initSmallSortedFileDataIerator();
            mergeDataFileSourceWriter = new QSDataSourceWriter(mergeDataFile);
            mergeDataFileSourceWriter.start(this._orderMetaInfo);
            ArrayList<Map> rows = new ArrayList<Map>();
            for (IDataIterator dataIterator : smallSortedFileDataIerators) {
                dataIterator.hasNextRow();
                oneRow = dataIterator.nextRow();
                oneRow.put(DATAITERATOR_KEY, dataIterator);
                if (rows.isEmpty()) {
                    rows.add(oneRow);
                    continue;
                }
                insertIndex = Collections.binarySearch(rows, oneRow, this.mapComparator);
                if ((insertIndex = Math.abs(insertIndex + 1)) > rows.size()) {
                    insertIndex = rows.size();
                }
                rows.add(insertIndex, oneRow);
            }
            Map minRow = (Map)rows.remove(0);
            while (minRow != null) {
                IDataIterator dataIterator;
                dataIterator = (IDataIterator)minRow.remove(DATAITERATOR_KEY);
                if (dataIterator.hasNextRow()) {
                    oneRow = dataIterator.nextRow();
                    oneRow.put(DATAITERATOR_KEY, dataIterator);
                    insertIndex = Collections.binarySearch(rows, oneRow, this.mapComparator);
                    insertIndex = Math.abs(insertIndex + 1);
                    if (insertIndex > rows.size()) {
                        insertIndex = rows.size();
                    }
                    rows.add(insertIndex, oneRow);
                } else {
                    CloseUtil.close((Closeable[])new Closeable[]{dataIterator});
                    dataIterator = null;
                }
                Object[] rowData = this.mapToObject(this._fieldIndexMap, minRow);
                mergeDataFileSourceWriter.writeData(rowData);
                if (rows.isEmpty()) break;
                minRow = (Map)rows.remove(0);
            }
            mergeDataFileSourceWriter.finishWriteData();
        }
        catch (AbstractDataSourceException e) {
            mergeDataFile.delete();
            exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            mergeDataFile.delete();
            exception = e;
            throw e;
        }
        finally {
            if (mergeDataFileSourceWriter != null) {
                mergeDataFileSourceWriter.close((Exception)exception);
                mergeDataFileSourceWriter = null;
            }
            this.clearSmallSortedFileDataIerator(smallSortedFileDataIerators);
        }
        return mergeDataFile;
    }

    private void clearSmallSortedFileDataIerator(List<IDataIterator> smallSortedFileDataIerators) {
        if (smallSortedFileDataIerators == null) {
            return;
        }
        for (int fileIndex = smallSortedFileDataIerators.size() - 1; fileIndex >= 0; --fileIndex) {
            IDataIterator dataIterator = smallSortedFileDataIerators.get(fileIndex);
            CloseUtil.close((Closeable[])new Closeable[]{dataIterator});
        }
        this.deleteSmallSortedFiles();
    }

    private List<IDataIterator> initSmallSortedFileDataIerator() throws AbstractDataSourceException, InterruptedException {
        ArrayList<IDataIterator> smallSortedFileDataIerators = new ArrayList<IDataIterator>();
        try {
            for (int fileIndex = 0; fileIndex < this._smallSortedDataFiles.size(); ++fileIndex) {
                QSDataSourceVisitor dataSourceVisitor = new QSDataSourceVisitor((IQingFileVisitor)this._smallSortedDataFiles.get(fileIndex));
                IDataIterator dataIterator = dataSourceVisitor.iterator();
                dataIterator.init(this._allFields, null, null);
                smallSortedFileDataIerators.add(dataIterator);
            }
        }
        catch (AbstractDataSourceException e) {
            this.clearSmallSortedFileDataIerator(smallSortedFileDataIerators);
            throw e;
        }
        catch (InterruptedException e) {
            this.clearSmallSortedFileDataIerator(smallSortedFileDataIerators);
            throw e;
        }
        return smallSortedFileDataIerators;
    }

    private Object[] mapToObject(Map<String, Integer> fieldIndexMap, Map<String, ?> row) {
        Object[] rowData = new Object[this._allFields.size()];
        for (Map.Entry<String, ?> entry : row.entrySet()) {
            if (!fieldIndexMap.containsKey(entry.getKey())) continue;
            Integer index = fieldIndexMap.get(entry.getKey());
            rowData[index.intValue()] = row.get(entry.getKey());
        }
        return rowData;
    }

    private void deleteSmallSortedFiles() {
        for (IQingFile dataFile : this._smallSortedDataFiles) {
            dataFile.delete();
        }
        this._smallSortedDataFiles.clear();
    }

    private int interCompare(Comparable leftValue, Comparable rightValue) {
        if (leftValue == null && rightValue == null) {
            return 0;
        }
        if (leftValue == null) {
            return 1;
        }
        if (rightValue == null) {
            return -1;
        }
        if (this._sortByString) {
            String leftValueString = ConvertUtil.convertToString((Object)leftValue);
            String rightValueString = ConvertUtil.convertToString((Object)rightValue);
            return leftValueString.compareTo(rightValueString);
        }
        return leftValue.compareTo(rightValue);
    }
}

