/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.base;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractDataSet;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;

public abstract class AbstractJoinDataSet
extends AbstractDataSet {
    private AbstractAtomicDataSet leftDataSet;
    private AbstractAtomicDataSet rightDataSet;
    private DSFieldKey leftField;
    private DSFieldKey rightField;
    private boolean changeLeftToString;
    private boolean changeRightToString;
    private DataType leftFiledDataType;
    private DataType rightFiledDataType;
    protected JoinOption joinOption;
    private long checkInterruptedCount = 0L;

    public AbstractJoinDataSet(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption) {
        super(joinDataSetModel);
        this.leftField = joinDataSetModel.getLeftField();
        this.rightField = joinDataSetModel.getRightField();
        this.changeLeftToString = joinDataSetModel.isChangeLeftToString();
        this.changeRightToString = joinDataSetModel.isChangeRightToString();
        this.leftFiledDataType = joinDataSetModel.getLeftFieldDataType();
        this.rightFiledDataType = joinDataSetModel.getRightFieldDataType();
        this.leftDataSet = leftDataSet;
        this.rightDataSet = rightDataSet;
        this.joinOption = joinOption;
    }

    protected final AbstractAtomicDataSet getLeftDataSet() {
        return this.leftDataSet;
    }

    protected final AbstractAtomicDataSet getRightDataSet() {
        return this.rightDataSet;
    }

    @Override
    public JoinDataSetModel getDataSetModel() {
        return (JoinDataSetModel)super.getDataSetModel();
    }

    protected abstract void initTwoSizeCompareValue() throws AbstractDataSourceException, InterruptedException;

    protected abstract boolean hasNextCompare() throws AbstractDataSourceException, InterruptedException;

    protected abstract boolean matchJoinCondition() throws AbstractDataSourceException, InterruptedException;

    private void checkInterrupted() throws InterruptedException {
        if (this.checkInterruptedCount++ % 100L == 0L) {
            JoinUtil.checkInterrupted();
        }
    }

    @Override
    public final boolean nextRow() throws InterruptedException, AbstractDataSourceException {
        this.setCurrentRow(null);
        this.initTwoSizeCompareValue();
        while (this.hasNextCompare()) {
            this.checkInterrupted();
            if (!this.matchJoinCondition()) continue;
            return true;
        }
        return true;
    }

    public DSFieldKey getLeftField() {
        return this.leftField;
    }

    public boolean isChangeLeftToString() {
        return this.changeLeftToString;
    }

    public DSFieldKey getRightField() {
        return this.rightField;
    }

    public boolean isChangeRightToString() {
        return this.changeRightToString;
    }

    public DataType getLeftFieldDataType() {
        return this.leftFiledDataType;
    }

    public DataType getRightFiledDataType() {
        return this.rightFiledDataType;
    }

    protected void exchangeBothSide() {
        AbstractAtomicDataSet tempDataSet = this.rightDataSet;
        this.rightDataSet = this.leftDataSet;
        this.leftDataSet = tempDataSet;
        DSFieldKey tempField = this.rightField;
        this.rightField = this.leftField;
        this.leftField = tempField;
        boolean tempChangeToString = this.changeRightToString;
        this.changeRightToString = this.changeLeftToString;
        this.changeLeftToString = tempChangeToString;
        DataType tempFiledDataType = this.rightFiledDataType;
        this.rightFiledDataType = this.leftFiledDataType;
        this.leftFiledDataType = tempFiledDataType;
    }

    @Override
    public void close() {
        CloseUtil.close((Closeable[])new Closeable[]{this.leftDataSet, this.rightDataSet});
        this.leftDataSet = null;
        this.rightDataSet = null;
        this.leftField = null;
        this.rightField = null;
        this.leftFiledDataType = null;
        this.rightFiledDataType = null;
        this.joinOption = null;
        super.close();
    }
}

