/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.shj;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractJoinDataSet;
import com.kingdee.bos.qing.datasource.join.base.AbstractRecursiveTask;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SimpleHashJoinDataSet
extends AbstractJoinDataSet {
    private List<AbstractRecursiveTask<AbstractAtomicDataSet>> joinDataSets;
    private Iterator<AbstractRecursiveTask<AbstractAtomicDataSet>> joinDataSetIterator;
    private AbstractDataSet currentDataSet;

    public SimpleHashJoinDataSet(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption, List<AbstractRecursiveTask<AbstractAtomicDataSet>> joinDataSets) {
        super(leftDataSet, rightDataSet, joinDataSetModel, joinOption);
        this.joinDataSets = joinDataSets;
    }

    @Override
    public void beforeFirst() throws AbstractDataSourceException, InterruptedException {
        for (AbstractRecursiveTask<AbstractAtomicDataSet> dataSet : this.joinDataSets) {
            AbstractAtomicDataSet atomicDataSet = (AbstractAtomicDataSet)dataSet.join();
            atomicDataSet.firstRow();
        }
        this.joinDataSetIterator = this.joinDataSets.iterator();
        this.currentDataSet = null;
        this.setCurrentRow(null);
    }

    private AbstractDataSet initDataset(AbstractRecursiveTask<AbstractAtomicDataSet> dataSet) throws AbstractDataSourceException, InterruptedException {
        AbstractAtomicDataSet atomicDataSet = (AbstractAtomicDataSet)dataSet.join();
        atomicDataSet.firstRow();
        return atomicDataSet;
    }

    @Override
    protected void initTwoSizeCompareValue() throws AbstractDataSourceException, InterruptedException {
        if (this.currentDataSet == null && this.joinDataSetIterator.hasNext()) {
            this.currentDataSet = this.initDataset(this.joinDataSetIterator.next());
        }
    }

    @Override
    protected boolean hasNextCompare() {
        return this.currentDataSet != null;
    }

    @Override
    protected boolean matchJoinCondition() throws AbstractDataSourceException, InterruptedException {
        if (!this.currentDataSet.hasNextRow()) {
            this.currentDataSet = null;
            this.initTwoSizeCompareValue();
            return false;
        }
        Map<String, Object> joinResult = this.currentDataSet.getCurrentRow();
        this.currentDataSet.nextRow();
        this.setCurrentRow(joinResult);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (AbstractRecursiveTask<AbstractAtomicDataSet> dataSet : this.joinDataSets) {
            AbstractAtomicDataSet atomicDataSet = null;
            try {
                atomicDataSet = (AbstractAtomicDataSet)dataSet.get(1L, TimeUnit.NANOSECONDS);
                CloseUtil.close((Closeable[])new Closeable[]{atomicDataSet});
            }
            catch (Exception e) {
                try {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{atomicDataSet});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{atomicDataSet});
                continue;
            }
            CloseUtil.close((Closeable[])new Closeable[]{atomicDataSet});
        }
        this.joinDataSets.clear();
        this.currentDataSet = null;
        super.close();
    }
}

