/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.snl;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.snl.AbstractSimpleNestedLoopJoinDataSet;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import java.util.HashMap;

public class SimpleNestedLoopFullJoinDataSet
extends AbstractSimpleNestedLoopJoinDataSet {
    private boolean isFirstLoop = true;

    public SimpleNestedLoopFullJoinDataSet(AbstractAtomicDataSet leftDataSet, AbstractAtomicDataSet rightDataSet, JoinDataSetModel joinDataSetModel, JoinOption joinOption) {
        super(leftDataSet, rightDataSet, joinDataSetModel, joinOption);
    }

    @Override
    protected boolean hasNextCompare() throws AbstractDataSourceException, InterruptedException {
        if (this.isFirstLoop && this.leftCompareRowValue == null) {
            this.isFirstLoop = false;
            this.exchangeBothSide();
            this.hasBeenRetruenLeft = false;
            this.leftCompareRowValue = null;
            this.rightCompareRowValue = null;
            this.getLeftDataSet().firstRow();
            this.getRightDataSet().firstRow();
            this.initTwoSizeCompareValue();
            return true;
        }
        return this.leftCompareRowValue != null;
    }

    @Override
    protected boolean matchJoinCondition() throws AbstractDataSourceException, InterruptedException {
        if (this.rightCompareRowValue == null) {
            this.hasBeenRetruenLeft = false;
            this.getLeftDataSet().nextRow();
            this.getRightDataSet().firstRow();
            if (this.hasBeenRetruenLeft) {
                this.initTwoSizeCompareValue();
                return false;
            }
            HashMap<String, Object> joinResult = new HashMap<String, Object>();
            joinResult.putAll(this.leftCompareRowValue);
            this.setCurrentRow(joinResult);
            return true;
        }
        if (this.isFirstLoop) {
            this.getRightDataSet().nextRow();
            Comparable leftCompareValue = (Comparable)this.leftCompareRowValue.get(this.getLeftField().toFullName());
            Comparable rightCompareValue = (Comparable)this.rightCompareRowValue.get(this.getRightField().toFullName());
            int compareResult = JoinUtil.compareTwoFieldValue(leftCompareValue, rightCompareValue, this.isChangeLeftToString(), this.isChangeRightToString());
            if (compareResult == 0) {
                HashMap<String, Object> joinResult = new HashMap<String, Object>(this.leftCompareRowValue);
                joinResult.putAll(this.rightCompareRowValue);
                this.hasBeenRetruenLeft = true;
                this.setCurrentRow(joinResult);
                return true;
            }
        } else {
            this.getRightDataSet().nextRow();
            Comparable leftCompareValue = (Comparable)this.leftCompareRowValue.get(this.getLeftField().toFullName());
            Comparable rightCompareValue = (Comparable)this.rightCompareRowValue.get(this.getRightField().toFullName());
            int compareResult = JoinUtil.compareTwoFieldValue(leftCompareValue, rightCompareValue, this.isChangeLeftToString(), this.isChangeRightToString());
            if (compareResult == 0) {
                this.hasBeenRetruenLeft = true;
            }
        }
        this.initTwoSizeCompareValue();
        return false;
    }
}

