/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class JoinResult {
    private Object result;
    private CountDownLatch latch = new CountDownLatch(1);
    private volatile boolean finished = false;
    private AtomicReference<Throwable> e = new AtomicReference<Object>(null);

    public Object get() throws InterruptedException, ExecutionException {
        this.latch.await();
        this.throwExceptionIfExist();
        return this.result;
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        if (this.latch.await(timeout, unit)) {
            this.throwExceptionIfExist();
            return this.result;
        }
        throw new TimeoutException("");
    }

    private void throwExceptionIfExist() throws InterruptedException, ExecutionException {
        Throwable error = this.e.get();
        if (null != error) {
            if (error instanceof InterruptedException) {
                throw (InterruptedException)error;
            }
            throw new ExecutionException(error);
        }
    }

    public void setResult(Object result) {
        this.result = result;
        this.finished = true;
        this.latch.countDown();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setException(Throwable e) {
        if (e == null || this.e.get() != null) {
            return;
        }
        this.finished = true;
        Throwable cause = e.getCause();
        if (cause != null) {
            this.e.compareAndSet(null, cause);
            return;
        }
        this.e.compareAndSet(null, e);
    }

    public void clearExceptionForRetry() {
        this.e.set(null);
    }

    public Throwable getCause() {
        return this.e.get();
    }
}

