/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.server.task.AsynServerRequestInvokeTask;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TraceSpansCacheUtil;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.datasource.exception.DataSourceAccessException;
import com.kingdee.bos.qing.datasource.exception.JoinLowMemoryException;
import com.kingdee.bos.qing.datasource.exception.JoinRejectedExecutionException;
import com.kingdee.bos.qing.datasource.exception.JoinTimeoutException;
import com.kingdee.bos.qing.datasource.join.DataJoinCancelException;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskCancelType;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class JoinTaskCallback {
    private String tag;
    private IQingSession qingSession;
    private TraceSpan traceSpan;
    private LinkedList<TraceSpan> currentTraceSpans;
    private AsynServerRequestInvokeTask serverRequestInvokeTask;
    private boolean async;
    private JoinTaskRuntime runtime;

    public void finished(Object result, JoinTaskRuntime runtime) {
        if (result == null) {
            return;
        }
        this.runtime = runtime;
        TracerUtil.setTraceSpans(this.currentTraceSpans);
        if (result instanceof Throwable) {
            this.setException((Throwable)result);
            this.doClear();
        } else {
            this.doClear();
            if (!runtime.isCanceled() && this.async) {
                this.serverRequestInvokeTask.setInvokeTaskListener(null);
                ThreadPoolManage.excuteThreadWithContext((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_LONG_TIME_TASK_HANDLER, (Callable)this.serverRequestInvokeTask, (QingContext)this.serverRequestInvokeTask.getContext());
            }
        }
    }

    private void setException(Throwable e) {
        ResponseErrorWrap data = null;
        Throwable cause = e.getCause();
        if (cause instanceof InterruptedException) {
            data = new ResponseErrorWrap((Throwable)new JoinRejectedExecutionException(cause.getMessage(), cause));
        } else if (cause instanceof DataJoinCancelException) {
            DataJoinCancelException joinCancelException = (DataJoinCancelException)((Object)cause);
            if (joinCancelException.getCancelType() == TaskCancelType.MANUAL) {
                return;
            }
            if (joinCancelException.getCancelType() == TaskCancelType.TIMEOUT) {
                String msg = Messages.getMLS((String)"joinTimeout", (String)"\u591a\u8868\u6570\u636e\u5173\u8054\u5206\u6790\u8d85\u65f6", (Messages.ProjectName)Messages.ProjectName.QING_COMMON);
                data = new ResponseErrorWrap((Throwable)new JoinTimeoutException(msg));
            } else {
                data = new ResponseErrorWrap((Throwable)new JoinLowMemoryException(cause.getMessage(), e));
            }
        } else {
            data = new ResponseErrorWrap((Throwable)new DataSourceAccessException(cause));
        }
        this.serverRequestInvokeTask.setResult((AbstractResponseWrap)data);
    }

    private void doClear() {
        this.finishOpTraceSpan();
        TracerUtil.close((TraceSpan)this.traceSpan);
        TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)this.traceSpan, (boolean)true);
        TracerUtil.removeTraceSpanTLs();
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public IQingSession getQingSession() {
        return this.qingSession;
    }

    public void setQingSession(IQingSession qingSession) {
        this.qingSession = qingSession;
    }

    public TraceSpan getTraceSpan() {
        return this.traceSpan;
    }

    public void setTraceSpan(TraceSpan traceSpan) {
        this.traceSpan = traceSpan;
    }

    public void setCurrentTraceSpans(LinkedList<TraceSpan> currentTraceSpans) {
        this.currentTraceSpans = currentTraceSpans;
    }

    public void setServerRequestInvokeTask(AsynServerRequestInvokeTask serverRequestInvokeTask) {
        this.serverRequestInvokeTask = serverRequestInvokeTask;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void finishOpTraceSpan() {
        try {
            TraceSpan traceSpan = null;
            if (this.runtime != null && (traceSpan = this.runtime.getTraceSpan()) != null) {
                QingSessionUtil.setQingSessionImpl((IQingSession)this.qingSession);
                TraceSpansCacheUtil.setTag((String)this.tag);
                this.supplementHisJoinAttribute(traceSpan);
                if (traceSpan.getCost() <= 0L) {
                    traceSpan.close();
                }
                TraceSpansCacheUtil.appendToCache((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.JOIN, (TraceSpan)traceSpan);
                TracerUtil.addToCurrentTraceSpanChildren((TraceSpan)traceSpan);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"finishOpTraceSpan error", (Throwable)e);
        }
    }

    private void supplementHisJoinAttribute(TraceSpan traceSpan) {
        List children = traceSpan.getChildren();
        if (children != null && !children.isEmpty()) {
            for (TraceSpan child : children) {
                TraceSpan historyTraceSpan;
                if (!"\u547d\u4e2d\u5386\u53f2JOIN\u4efb\u52a1".equals(child.getDescription()) || (historyTraceSpan = this.getHistoryTraceSpan((String)child.getAttributeMap().get("\u547d\u4e2d\u8868\u540d"))) == null) continue;
                child.addAttribute("\u5386\u53f2JOIN\u4efb\u52a1\u8017\u65f6", String.valueOf(historyTraceSpan.getCost()));
                child.addAttribute("\u5386\u53f2JOIN\u4efb\u52a1\u91cd\u8bd5\u6b21\u6570", (String)historyTraceSpan.getAttributeMap().get("\u91cd\u8bd5\u6b21\u6570"));
                child.addAttribute("\u5386\u53f2JOIN\u4efb\u52a1\u72b6\u6001", (String)historyTraceSpan.getAttributeMap().get("\u72b6\u6001"));
                String cancelReason = (String)historyTraceSpan.getAttributeMap().get("\u53d6\u6d88\u539f\u56e0");
                if (!StringUtils.isNotBlank((CharSequence)cancelReason)) continue;
                child.addAttribute("\u5386\u53f2JOIN\u4efb\u52a1\u53d6\u6d88\u539f\u56e0", cancelReason);
            }
        }
    }

    private TraceSpan getHistoryTraceSpan(String resultTableName) {
        List traceSpans = TraceSpansCacheUtil.getCacheTraceSpans((String)TraceSpansCacheUtil.getTag(), (TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.JOIN);
        if (traceSpans != null && !traceSpans.isEmpty()) {
            for (int i = traceSpans.size() - 1; i >= 0; --i) {
                TraceSpan traceSpan = (TraceSpan)traceSpans.get(i);
                List children = traceSpan.getChildren();
                if (children == null || children.isEmpty()) continue;
                for (int j = children.size() - 1; j >= 0; --j) {
                    TraceSpan child = (TraceSpan)children.get(j);
                    if (!resultTableName.equals(child.getAttributeMap().get("\u7ed3\u679c\u8868\u540d"))) continue;
                    return child;
                }
            }
        }
        return null;
    }
}

