/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.common.memory.MemRuntimeMonitor;
import com.kingdee.bos.qing.common.memory.MemScanListener;
import com.kingdee.bos.qing.common.memory.MemWarningLevel;
import com.kingdee.bos.qing.common.memory.MemoryObserver;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.task.JoinTracer;
import com.kingdee.bos.qing.datasource.join.task.TaskInterruptListener;
import com.kingdee.bos.qing.datasource.join.task.TaskTimeoutListener;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskCancelType;
import com.kingdee.bos.qing.datasource.join.worknodes.JoinTaskManager;
import com.kingdee.bos.qing.datasource.join.worknodes.TaskReleaseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class JoinTaskMonitorRecorder
implements TaskTimeoutListener,
TaskInterruptListener,
MemScanListener,
TaskReleaseListener {
    private static final long TIME_DURATION_THRESHOLD = 86400000L;
    private AtomicLong blockedTaskCount = new AtomicLong(0L);
    private AtomicLong delayedTaskCount = new AtomicLong(0L);
    private List<ErrorJoinInfo> errorJoinInfos = new LinkedList<ErrorJoinInfo>();
    private AtomicLong totalSubmitCount = new AtomicLong(0L);
    private AtomicLong totalSucceedCount = new AtomicLong(0L);
    private AtomicLong totalTimeoutCount = new AtomicLong(0L);
    private AtomicLong totalInterruptCount = new AtomicLong(0L);
    private MemoryObserver observer = new MyMemObserver();
    private List<Double> oldSpaceUsedRatios = new LinkedList<Double>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterrupted(JoinTaskRuntime joinTaskRuntime, TaskCancelType cancelType) {
        List<ErrorJoinInfo> list = this.errorJoinInfos;
        synchronized (list) {
            ErrorJoinInfo errorJoinInfo = new ErrorJoinInfo(joinTaskRuntime.getTaskId(), cancelType, joinTaskRuntime.getJoinTracerList());
            errorJoinInfo.setOldSpaceUsedRatios(this.oldSpaceUsedRatios);
            errorJoinInfo.setJoinEntityNames(joinTaskRuntime.getJoinEntityNames());
            errorJoinInfo.setTotalWriteCount(joinTaskRuntime.getTaskProgress().getHandledRowCount());
            errorJoinInfo.setTaskBeginTime(joinTaskRuntime.getBeginTime());
            this.errorJoinInfos.add(errorJoinInfo);
            if (this.errorJoinInfos.size() > 100) {
                this.removeExpireErrorInfo();
            }
            this.totalInterruptCount.incrementAndGet();
        }
    }

    private void removeExpireErrorInfo() {
        Iterator<ErrorJoinInfo> iterator = this.errorJoinInfos.iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            ErrorJoinInfo error = iterator.next();
            long duration = currentTime - error.getErrHappenTime();
            if (duration < 86400000L) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeout(String joinTaskId, JoinTaskRuntime taskRuntime) {
        List<ErrorJoinInfo> list = this.errorJoinInfos;
        synchronized (list) {
            if (null != taskRuntime) {
                ErrorJoinInfo errorJoinInfo = new ErrorJoinInfo(joinTaskId, TaskCancelType.TIMEOUT, taskRuntime.getJoinTracerList());
                errorJoinInfo.setJoinEntityNames(taskRuntime.getJoinEntityNames());
                errorJoinInfo.setTotalWriteCount(taskRuntime.getTaskProgress().getHandledRowCount());
                errorJoinInfo.setTaskBeginTime(taskRuntime.getBeginTime());
                errorJoinInfo.setOldSpaceUsedRatios(this.oldSpaceUsedRatios);
                this.errorJoinInfos.add(errorJoinInfo);
            } else {
                ErrorJoinInfo errorJoinInfo = new ErrorJoinInfo(joinTaskId, TaskCancelType.TIMEOUT, null);
                this.errorJoinInfos.add(errorJoinInfo);
            }
            if (this.errorJoinInfos.size() > 100) {
                this.removeExpireErrorInfo();
            }
            this.totalTimeoutCount.incrementAndGet();
        }
    }

    public void incrementTotalSubmitCount() {
        this.totalSubmitCount.incrementAndGet();
    }

    public void incrementBlockedTask() {
        this.blockedTaskCount.incrementAndGet();
    }

    public void decrementBlockedTask() {
        this.blockedTaskCount.decrementAndGet();
    }

    public void incrementDelayedTask() {
        this.delayedTaskCount.incrementAndGet();
    }

    public void decrementDelayedTask() {
        this.delayedTaskCount.decrementAndGet();
    }

    public long getBlockTaskSize() {
        return this.blockedTaskCount.get();
    }

    public long getDelayedTaskSize() {
        return this.delayedTaskCount.get();
    }

    public long getTotalSubmitCount() {
        return this.totalSubmitCount.get();
    }

    public long getTotalSucceedCount() {
        return this.totalSucceedCount.get();
    }

    public long getTotalTimeoutCount() {
        return this.totalTimeoutCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ErrorJoinInfo> getErrorJoinInfos() {
        ArrayList<ErrorJoinInfo> results = new ArrayList<ErrorJoinInfo>();
        List<ErrorJoinInfo> list = this.errorJoinInfos;
        synchronized (list) {
            for (ErrorJoinInfo errorJoinInfo : this.errorJoinInfos) {
                if (errorJoinInfo.isVisited()) continue;
                results.add(errorJoinInfo);
            }
        }
        return new ArrayList<ErrorJoinInfo>(results);
    }

    public long getTotalInterruptCount() {
        return this.totalInterruptCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() {
        List<Double> list = this.oldSpaceUsedRatios;
        synchronized (list) {
            this.oldSpaceUsedRatios.clear();
        }
        MemRuntimeMonitor.getInstance().registerIfAbsent(this.observer);
    }

    public void onFinished() {
    }

    @Override
    public void taskReleased(int state) {
        if (state == 0) {
            this.totalSucceedCount.incrementAndGet();
        }
        if (JoinTaskManager.getInstance().getTotalRunningTask() == 0) {
            MemRuntimeMonitor.getInstance().unRegister(JoinTaskMonitorRecorder.class.getName());
        }
    }

    public static class ErrorJoinInfo {
        private long errHappenTime = System.currentTimeMillis();
        private long taskBeginTime;
        private String joinTaskId;
        private List<JoinTracer> tracers;
        private TaskCancelType cancelType;
        private List<Double> oldSpaceUsedRatios;
        private Set<String> joinEntityNames;
        private long totalWriteCount;
        private boolean isVisited = false;

        public ErrorJoinInfo(String joinTaskId, TaskCancelType cancelType, List<JoinTracer> tracers) {
            this.joinTaskId = joinTaskId;
            this.tracers = tracers;
            this.cancelType = cancelType;
        }

        public long getTotalWriteCount() {
            return this.totalWriteCount;
        }

        public void setTotalWriteCount(long totalWriteCount) {
            this.totalWriteCount = totalWriteCount;
        }

        public long getTaskBeginTime() {
            return this.taskBeginTime;
        }

        public void setTaskBeginTime(long taskBeginTime) {
            this.taskBeginTime = taskBeginTime;
        }

        public void setJoinEntityNames(Set<String> joinEntityNames) {
            this.joinEntityNames = joinEntityNames;
        }

        public Set<String> getJoinEntityNames() {
            return this.joinEntityNames;
        }

        public long getErrHappenTime() {
            return this.errHappenTime;
        }

        public String getJoinTaskId() {
            return this.joinTaskId;
        }

        public List<JoinTracer> getTracers() {
            return this.tracers;
        }

        public TaskCancelType getCancelType() {
            return this.cancelType;
        }

        public void setOldSpaceUsedRatios(List<Double> oldSpaceUsedRatios) {
            this.oldSpaceUsedRatios = oldSpaceUsedRatios;
        }

        public List<Double> getOldSpaceUsedRatios() {
            return new ArrayList<Double>(this.oldSpaceUsedRatios);
        }

        public boolean isVisited() {
            return this.isVisited;
        }

        public void setVisited(boolean visited) {
            this.isVisited = visited;
        }
    }

    private class MyMemObserver
    implements MemoryObserver {
        private MyMemObserver() {
        }

        public void notifyMemoryWarning(MemWarningLevel warningLevel, double currentOldSpaceRatio) {
            if (JoinTaskMonitorRecorder.this.oldSpaceUsedRatios.size() == 5) {
                JoinTaskMonitorRecorder.this.oldSpaceUsedRatios.remove(0);
            }
            JoinTaskMonitorRecorder.this.oldSpaceUsedRatios.add(currentOldSpaceRatio);
        }

        public MemWarningLevel lowestLevel() {
            return MemWarningLevel.NORMAL;
        }

        public int getPriority() {
            return 0;
        }

        public String getObserverId() {
            return JoinTaskMonitorRecorder.class.getName();
        }
    }
}

