/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.datasource.join.task.JoinResult;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRequest;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskCancelType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class JoinTaskPromise {
    private JoinTaskRuntime runtime;
    private ReentrantLock runtimeLock = new ReentrantLock();
    private Condition cond = this.runtimeLock.newCondition();
    private JoinTaskRequest taskRequest;
    private volatile JoinResult joinResult;
    private volatile boolean isTimeoutBeforeSubmit = false;

    public JoinTaskPromise(JoinTaskRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    public JoinTaskRequest getTaskRequest() {
        return this.taskRequest;
    }

    public void setRuntime(JoinTaskRuntime runtime) {
        this.runtimeLock.lock();
        try {
            this.runtime = runtime;
            this.joinResult = runtime.getJoinResult();
            this.cond.signal();
        }
        finally {
            this.runtimeLock.unlock();
        }
    }

    public Object get() throws InterruptedException, ExecutionException {
        this.runtimeLock.lock();
        try {
            while (null == this.joinResult) {
                this.cond.await();
            }
        }
        finally {
            this.runtimeLock.unlock();
        }
        return this.joinResult.get();
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        long submitDurationTime = this.awaitSubmit(timeout, unit);
        long reservedTimeout = unit.toMillis(timeout) - submitDurationTime;
        return this.joinResult.get(reservedTimeout, TimeUnit.MILLISECONDS);
    }

    public boolean isFinished() {
        if (null == this.joinResult) {
            return false;
        }
        return this.joinResult.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long awaitSubmit(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long submitDurationTime = 0L;
        this.runtimeLock.lock();
        try {
            long begin = System.currentTimeMillis();
            while (null == this.joinResult) {
                boolean submitted = this.cond.await(timeout, unit);
                if (!submitted) {
                    this.isTimeoutBeforeSubmit = true;
                    throw new TimeoutException("");
                }
                submitDurationTime = System.currentTimeMillis() - begin;
            }
        }
        finally {
            this.runtimeLock.unlock();
        }
        return submitDurationTime;
    }

    public boolean isTimeoutBeforeSubmit() {
        return this.isTimeoutBeforeSubmit;
    }

    public void stop() {
        this.runtimeLock.lock();
        try {
            if (null != this.runtime) {
                this.runtime.cancel(TaskCancelType.TIMEOUT);
            }
        }
        finally {
            this.runtimeLock.unlock();
        }
    }

    public JoinTaskRuntime getJoinTaskRuntime() {
        return this.runtime;
    }
}

