/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.task;

import com.kingdee.bos.qing.common.cache.TempQingFileCache;
import com.kingdee.bos.qing.common.thread.DelayedRunnable;
import com.kingdee.bos.qing.common.thread.GlobalScheduledExecutor;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceJoinException;
import com.kingdee.bos.qing.datasource.join.DataJoinCancelException;
import com.kingdee.bos.qing.datasource.join.cache.SharedJoinFileCacheCleaner;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.datasource.join.task.JoinResult;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRequest;
import com.kingdee.bos.qing.datasource.join.task.JoinTracer;
import com.kingdee.bos.qing.datasource.join.task.TaskEvent;
import com.kingdee.bos.qing.datasource.join.task.TaskEventListener;
import com.kingdee.bos.qing.datasource.join.task.TaskInterruptListener;
import com.kingdee.bos.qing.datasource.join.task.TaskProgress;
import com.kingdee.bos.qing.datasource.join.task.TaskScale;
import com.kingdee.bos.qing.datasource.join.task.TaskTimeoutListener;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskCancelType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JoinTaskRuntime {
    public static final int WAITING = 0;
    public static final int RUNNING = 1;
    public static final int FINISHED = 2;
    private volatile long beginTime = -1L;
    private JoinResult joinResult = new JoinResult();
    private String taskId;
    private Map<String, TaskEventListener> taskEventListenerMap = new ConcurrentHashMap<String, TaskEventListener>();
    private AtomicInteger status = new AtomicInteger(0);
    private Set<TaskTimeoutListener> timeoutListeners = new HashSet<TaskTimeoutListener>();
    private Set<TaskInterruptListener> interruptListeners = new HashSet<TaskInterruptListener>();
    private CancelSynchronizer cancelSync = new CancelSynchronizer();
    private Set<String> joinEntityNames;
    private JoinTaskRequest taskRequest;
    private volatile String workNodeId;
    private TaskProgress taskProgress;
    private AtomicLong totalAdviseRow = new AtomicLong(-1L);
    private volatile TaskScale scale = TaskScale.SMALL;
    private int retryTimes = 0;
    private volatile long preStolenTime = -1L;
    private AtomicInteger stolenCount = new AtomicInteger(0);
    private TempQingFileCache tempQingFileCache = new TempQingFileCache();
    private Set<String> sharedJoinFileKeys = Collections.synchronizedSet(new HashSet());
    private int maxRetrySurvival = QingJoinConfig.getInstance().getMaxSurvival();
    private TraceSpan traceSpan;
    private Map<Long, JoinTracer> joinTracerMap = new HashMap<Long, JoinTracer>();
    private int joinOrder = 0;

    public JoinTaskRuntime(JoinTaskRequest taskRequest) {
        this.traceSpan = TraceSpan.createEmpty((String)"JOIN\u4efb\u52a1");
        this.traceSpan.addClassMethodAttribute(this.getClass().getName() + ".JoinTaskRuntime");
        this.taskRequest = taskRequest;
        this.taskId = taskRequest.getTaskId();
        this.joinEntityNames = taskRequest.getDataSetModel().getEntityNames();
        this.taskProgress = new TaskProgress();
    }

    public long getPreStolenTime() {
        return this.preStolenTime;
    }

    public void setPreStolenTime(long preStolenTime) {
        this.preStolenTime = preStolenTime;
    }

    public boolean isWaiting() {
        return this.status.get() == 0;
    }

    public JoinTaskRequest getTaskRequest() {
        return this.taskRequest;
    }

    public void increaseStolenCount() {
        this.stolenCount.incrementAndGet();
    }

    public int getStolenCount() {
        return this.stolenCount.get();
    }

    public String getWorkNodeId() {
        return this.workNodeId;
    }

    public long getTotalAdviseRow() {
        return this.totalAdviseRow.get();
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void addJoinAdviseRow(long totalAdviseRow) {
        this.totalAdviseRow.addAndGet(totalAdviseRow);
        this.scale = TaskScale.scaleOf(this.totalAdviseRow.get());
        this.fireTaskEvent(TaskEvent.EventType.SCALECHANGED);
    }

    public void registerTimeoutListener(TaskTimeoutListener timeoutListener) {
        this.timeoutListeners.add(timeoutListener);
    }

    public void registerInterruptedListener(TaskInterruptListener interruptListener) {
        this.interruptListeners.add(interruptListener);
    }

    public TaskScale getScale() {
        return this.scale;
    }

    public void setWorkNodeId(String workNodeId) {
        this.workNodeId = workNodeId;
    }

    public boolean survivalNotCancel() {
        if (this.retryTimes == 0) {
            return false;
        }
        --this.maxRetrySurvival;
        return this.maxRetrySurvival >= 0;
    }

    public boolean isFinished() {
        return this.status.get() == 2;
    }

    TempQingFileCache getTempQingFileCache() {
        return this.tempQingFileCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndStart(String currentWorkNodeId) {
        JoinTaskRuntime joinTaskRuntime = this;
        synchronized (joinTaskRuntime) {
            if (!this.workNodeId.equals(currentWorkNodeId)) {
                return false;
            }
            this.status.set(1);
        }
        this.beginTime = System.currentTimeMillis();
        this.fireTaskEvent(TaskEvent.EventType.RUNNING);
        return true;
    }

    public int getStatus() {
        return this.status.get();
    }

    public JoinResult getJoinResult() {
        return this.joinResult;
    }

    public void end(Object result) {
        if (this.cancelSync.isEqual(TaskCancelType.RETRY)) {
            this.endForRetry(result);
            return;
        }
        this.endForFinish(result);
    }

    private void endForFinish(Object result) {
        try {
            this.status.set(2);
            this.joinResult.setResult(result);
            this.fireTaskEvent(TaskEvent.EventType.FINISHED);
            this.tempQingFileCache.clearTempFile();
            GlobalScheduledExecutor.schedule((DelayedRunnable)new SharedJoinFileCacheCleaner(this.sharedJoinFileKeys));
        }
        finally {
            if (this.traceSpan != null) {
                this.traceSpan.close();
            }
            this.taskRequest.getJoinTaskCallback().finished(result, this);
        }
    }

    protected synchronized JoinTracer newJoinTracer(Set<String> leftEntityNames, Set<String> rightEntityNames) {
        ArrayList<String> allEntityNames = new ArrayList<String>();
        allEntityNames.addAll(leftEntityNames);
        allEntityNames.addAll(rightEntityNames);
        Collections.sort(allEntityNames);
        long hashCode = ((Object)allEntityNames).toString().hashCode();
        JoinTracer tracer = this.joinTracerMap.get(hashCode);
        if (null == tracer) {
            tracer = new JoinTracer();
            tracer.setJoinStepIndex(++this.joinOrder);
            this.joinTracerMap.put(hashCode, tracer);
            tracer.setLeftEntities(leftEntityNames);
            tracer.setRightEntities(rightEntityNames);
            return tracer;
        }
        JoinTracer subTracer = new JoinTracer();
        tracer.getSubTraces().add(subTracer);
        return subTracer;
    }

    public boolean resetBeforeRetry() {
        if (!this.cancelSync.clear()) {
            return false;
        }
        this.status.set(0);
        this.taskProgress.clearForRetry();
        this.joinResult.clearExceptionForRetry();
        this.joinTracerMap.clear();
        this.joinOrder = 0;
        return true;
    }

    private void endForRetry(Object result) {
        if (this.retryTimes < QingJoinConfig.getInstance().getMaxRetryTimes()) {
            ++this.retryTimes;
            this.fireTaskEvent(TaskEvent.EventType.RETRY);
            return;
        }
        this.status.set(2);
        this.joinResult.clearExceptionForRetry();
        DataJoinCancelException cancelException = new DataJoinCancelException(TaskCancelType.EXCEED_MAX_RETRY_TIMES);
        this.joinResult.setException((Throwable)((Object)cancelException));
        this.joinResult.setResult(result);
        this.fireTaskEvent(TaskEvent.EventType.FINISHED);
        this.tempQingFileCache.clearTempFile();
        this.taskRequest.getJoinTaskCallback().finished((Object)cancelException, this);
    }

    private void fireTaskEvent(TaskEvent.EventType eventType) {
        TaskEventListener taskEventListener = this.taskEventListenerMap.get(this.workNodeId);
        if (null != taskEventListener) {
            taskEventListener.fireTaskEvent(this, eventType);
        }
    }

    public void setException(Throwable e) {
        this.joinResult.setException(e);
        this.taskRequest.getJoinTaskCallback().finished(e, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trySetNotRunInThisWorkNode() {
        JoinTaskRuntime joinTaskRuntime = this;
        synchronized (joinTaskRuntime) {
            if (this.status.get() == 0 && this.retryTimes == 0) {
                this.workNodeId = "";
                return true;
            }
            return false;
        }
    }

    public boolean isFinish() {
        return this.status.get() == 2;
    }

    public Set<String> getJoinEntityNames() {
        return this.joinEntityNames;
    }

    public void setTaskListener(TaskEventListener taskEventListener) {
        this.taskEventListenerMap.put(this.workNodeId, taskEventListener);
    }

    public long getRunningTime() {
        if (this.beginTime == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.beginTime;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void checkTaskNormal() throws AbstractDataSourceException {
        if (this.cancelSync.isCanceled()) {
            throw new DataJoinCancelException(this.cancelSync.get());
        }
        if (null != this.taskRequest.getRequestInvokeContext() && this.taskRequest.getRequestInvokeContext().isInterrupt()) {
            throw new DataJoinCancelException(TaskCancelType.MANUAL);
        }
        Throwable e = this.joinResult.getCause();
        if (null != e) {
            if (e instanceof AbstractDataSourceException) {
                throw (AbstractDataSourceException)e;
            }
            throw new DataSourceJoinException(e);
        }
    }

    public boolean isCanceled() {
        return this.getCancelSync().isCanceled();
    }

    public void cancel(TaskCancelType cancelType) {
        this.cancelSync.update(cancelType);
        switch (cancelType) {
            case TIMEOUT: {
                for (TaskTimeoutListener l : this.timeoutListeners) {
                    l.timeout(this.taskId, this);
                }
                break;
            }
            case EXCEED_MAX_LIMIT: 
            case EXCEED_MAX_RETRY_TIMES: {
                for (TaskInterruptListener listener : this.interruptListeners) {
                    listener.onInterrupted(this, cancelType);
                }
                break;
            }
        }
    }

    public List<JoinTracer> getJoinTracerList() {
        ArrayList<JoinTracer> tracers = new ArrayList<JoinTracer>();
        tracers.addAll(this.joinTracerMap.values());
        Collections.sort(tracers, new Comparator<JoinTracer>(){

            @Override
            public int compare(JoinTracer o1, JoinTracer o2) {
                int o2Index;
                int o1Index = o1.getJoinStepIndex();
                int diff = o1Index - (o2Index = o2.getJoinStepIndex());
                if (diff < 0) {
                    return -1;
                }
                if (diff > 0) {
                    return 1;
                }
                return 0;
            }
        });
        return tracers;
    }

    public void increaseRowCount() {
        this.taskProgress.dealOneRow();
    }

    public TaskProgress getTaskProgress() {
        return this.taskProgress;
    }

    public TraceSpan getTraceSpan() {
        return this.traceSpan;
    }

    public void appendToParentTraceSpan(TraceSpan childTraceSpan) {
        this.traceSpan.getChildren().add(childTraceSpan);
    }

    public CancelSynchronizer getCancelSync() {
        return this.cancelSync;
    }

    public void addSharedJoinedFileKey(String sharedFileKey) {
        this.sharedJoinFileKeys.add(sharedFileKey);
    }

    static class CancelSynchronizer {
        private TaskCancelType cancelType = null;
        private volatile boolean canceled = false;

        CancelSynchronizer() {
        }

        public synchronized TaskCancelType get() {
            return this.cancelType;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public synchronized boolean clear() {
            if (this.cancelType != null && this.cancelType.getPriority() > TaskCancelType.RETRY.getPriority()) {
                return false;
            }
            this.cancelType = null;
            this.canceled = false;
            return true;
        }

        public synchronized void update(TaskCancelType newCancelType) {
            if (null == this.cancelType || this.cancelType.getPriority() < newCancelType.getPriority()) {
                this.cancelType = newCancelType;
                this.canceled = true;
            }
        }

        public synchronized boolean isEqual(TaskCancelType target) {
            return this.cancelType == target;
        }
    }
}

