/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.taskadvise;

import com.kingdee.bos.qing.common.memory.MemRuntimeMonitor;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRequest;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskAdvisable;
import com.kingdee.bos.qing.datasource.join.taskadvise.TaskAdvise;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.join.worknodes.JoinTaskManager;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class MemoryAdvisor
implements TaskAdvisable {
    private static final int MAX_CACHE_SIZE = 5;
    private static final long EXPIRE_TIME = 15000L;
    private List<Double> memUsedCache = new ArrayList<Double>(5);
    private long recentCacheTime = -1L;

    @Override
    public TaskAdvise getAdvise(JoinTaskRequest joinTaskRequest) {
        if (!QingJoinConfig.getInstance().isMemMonitorOpened()) {
            return TaskAdvise.SUBMIT;
        }
        double memUsedPercent = MemRuntimeMonitor.getInstance().getOldSpaceUsedPercent();
        if (memUsedPercent < QingJoinConfig.getInstance().getDelayMemRatio()) {
            this.memUsedCache.clear();
            this.recentCacheTime = -1L;
            return TaskAdvise.SUBMIT;
        }
        int totalRunningTaskCount = JoinTaskManager.getInstance().getTotalRunningTask();
        if (totalRunningTaskCount > 0) {
            return TaskAdvise.DELAY;
        }
        this.cacheMemUsedData(memUsedPercent);
        if (this.memUsedCache.size() < 5) {
            return TaskAdvise.DELAY;
        }
        double coefficient = this.caculateCoefficient();
        LogUtil.info((String)(JoinUtil.joinLogPrefix() + "recent memUsed data:" + this.memUsedCache + ", coefficient of variant:" + coefficient));
        if (coefficient < 15.0) {
            return TaskAdvise.SUBMIT;
        }
        return TaskAdvise.DELAY;
    }

    private double caculateCoefficient() {
        double average = this.caculateAverage();
        double totalSquare = 0.0;
        for (Double used : this.memUsedCache) {
            totalSquare += Math.pow(used - average, 2.0);
        }
        double stdDeviation = Math.sqrt(totalSquare / (double)this.memUsedCache.size());
        return stdDeviation / average * 100.0;
    }

    private double caculateAverage() {
        double total = 0.0;
        for (Double used : this.memUsedCache) {
            total += used.doubleValue();
        }
        return total / (double)this.memUsedCache.size();
    }

    private void cacheMemUsedData(double memUsed) {
        long currentTime = System.currentTimeMillis();
        if (this.recentCacheTime != -1L && currentTime - this.recentCacheTime > 15000L) {
            this.memUsedCache.clear();
        }
        if (this.memUsedCache.size() == 5) {
            this.memUsedCache.remove(0);
        }
        this.memUsedCache.add(memUsed);
        this.recentCacheTime = currentTime;
    }
}

