/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.util;

import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.util.ConvertUtil;
import java.math.BigDecimal;
import q.storage.columnar.util.QingStorageUtils;
import shaded.com.google.common.base.Charsets;
import shaded.com.google.common.hash.BloomFilter;
import shaded.com.google.common.hash.Funnel;
import shaded.com.google.common.hash.PrimitiveSink;

public class BloomFilterFunnel
implements Funnel<Object> {
    private static final long serialVersionUID = 7339491955729405968L;
    private static final long defaultSize = 0x2000000L;
    private Funnel<Object> innerFunnel;
    private IConverter converter;
    private long suggestSize;
    private BloomFilter<Object> bloomFilter;
    private boolean hasNull = false;

    public BloomFilterFunnel(DataType dataType, boolean isChangeToString) {
        if (isChangeToString || DataType.STRING == dataType) {
            this.innerFunnel = new StringBloomFilterFunnel();
            this.converter = new StringConverter();
        } else if (dataType != null) {
            switch (dataType) {
                case BOOLEAN: {
                    this.innerFunnel = new BooleanBloomFilterFunnel();
                    this.converter = new BooleanConverter();
                    break;
                }
                case INT: {
                    this.innerFunnel = new LongBloomFilterFunnel();
                    this.converter = new LongConverter();
                    break;
                }
                case NUMBER: {
                    this.innerFunnel = new BytesBloomFilterFunnel();
                    this.converter = new NumberConverter();
                    break;
                }
                case DATE: 
                case DATETIME: {
                    this.innerFunnel = new LongBloomFilterFunnel();
                    this.converter = new DateConverter();
                    break;
                }
                default: {
                    this.innerFunnel = new StringBloomFilterFunnel();
                    this.converter = new StringConverter();
                    break;
                }
            }
        } else {
            this.innerFunnel = new StringBloomFilterFunnel();
            this.converter = new StringConverter();
        }
        this.suggestSize = !isChangeToString && DataType.BOOLEAN == dataType ? 3L : 0x2000000L;
    }

    public IConverter getConverter() {
        return this.converter;
    }

    public void funnel(Object value, PrimitiveSink primitiveSink) {
        this.innerFunnel.funnel(value, primitiveSink);
    }

    public long getSuggestSize(long rowSize) {
        return rowSize > 0L ? rowSize : this.suggestSize;
    }

    public void setBloomFilter(BloomFilter<Object> bloomFilter) {
        this.bloomFilter = bloomFilter;
    }

    public void put(Object value) {
        if ((value = this.converter.convert(value)) == null) {
            this.hasNull = true;
        } else {
            this.bloomFilter.put(value);
        }
    }

    public boolean mightContain(Object value) {
        if ((value = this.converter.convert(value)) == null) {
            return this.hasNull;
        }
        return this.bloomFilter.mightContain(value);
    }

    static class DateConverter
    implements IConverter {
        DateConverter() {
        }

        @Override
        public Object convert(Object value) {
            return ConvertUtil.convertToDate((Object)value).getTimeInMillis();
        }
    }

    static class BooleanConverter
    implements IConverter {
        BooleanConverter() {
        }

        @Override
        public Object convert(Object value) {
            return ConvertUtil.convertToBoolean((Object)value);
        }
    }

    static class StringConverter
    implements IConverter {
        StringConverter() {
        }

        @Override
        public Object convert(Object value) {
            return ConvertUtil.convertToString((Object)value);
        }
    }

    static class LongConverter
    implements IConverter {
        LongConverter() {
        }

        @Override
        public Object convert(Object value) {
            BigDecimal numberValue = ConvertUtil.convertToNumber((Object)value);
            if (numberValue != null) {
                return numberValue.longValue();
            }
            return null;
        }
    }

    static class NumberConverter
    implements IConverter {
        NumberConverter() {
        }

        @Override
        public Object convert(Object value) {
            BigDecimal numberValue = ConvertUtil.convertToNumber((Object)value);
            if (numberValue != null) {
                return QingStorageUtils.encodeBigDecimal((BigDecimal)numberValue, (int)16);
            }
            return null;
        }
    }

    public static interface IConverter {
        public Object convert(Object var1);
    }

    static class BytesBloomFilterFunnel
    implements Funnel<Object> {
        private static final long serialVersionUID = 2003483321392180386L;

        BytesBloomFilterFunnel() {
        }

        public void funnel(Object value, PrimitiveSink primitiveSink) {
            byte[] bytes = (byte[])value;
            primitiveSink.putBytes(bytes);
        }
    }

    static class LongBloomFilterFunnel
    implements Funnel<Object> {
        private static final long serialVersionUID = -6458158751988481947L;

        LongBloomFilterFunnel() {
        }

        public void funnel(Object value, PrimitiveSink primitiveSink) {
            long longValue = (Long)value;
            primitiveSink.putLong(longValue);
        }
    }

    static class BooleanBloomFilterFunnel
    implements Funnel<Object> {
        private static final long serialVersionUID = -6912522972215807492L;

        BooleanBloomFilterFunnel() {
        }

        public void funnel(Object value, PrimitiveSink primitiveSink) {
            primitiveSink.putBoolean(((Boolean)value).booleanValue());
        }
    }

    static class StringBloomFilterFunnel
    implements Funnel<Object> {
        private static final long serialVersionUID = 8692168895868035362L;

        StringBloomFilterFunnel() {
        }

        public void funnel(Object value, PrimitiveSink primitiveSink) {
            primitiveSink.putString((CharSequence)((String)value), Charsets.UTF_8);
        }
    }
}

