/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.util;

import com.kingdee.bos.qing.common.cache.TempQingFileCache;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.join.base.AbstractAtomicDataSet;
import com.kingdee.bos.qing.datasource.join.base.MemoryDataSet;
import com.kingdee.bos.qing.datasource.join.base.PersistentDataSet;
import com.kingdee.bos.qing.datasource.join.util.DeleteTempFileCloseListener;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import com.kingdee.bos.qing.datasource.model.DataSetModel;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataSetWriter {
    private QSDataSourceWriter tempDataSourceWriter;
    private AbstractDataSetModel dataSetModel;
    private boolean flushToDiskAtOnce = false;
    private List<Map<String, Object>> memoryDatas = new ArrayList<Map<String, Object>>();
    private TempQingFileCache tempQingFileCache;
    private List<IQingFile> tempQingFiles = new ArrayList<IQingFile>();

    public DataSetWriter(AbstractDataSetModel dataSetModel, boolean flushToDiskAtOnce, TempQingFileCache tempQingFileCache) {
        this.dataSetModel = dataSetModel;
        this.flushToDiskAtOnce = flushToDiskAtOnce;
        this.tempQingFileCache = tempQingFileCache;
    }

    public DataSetWriter(AbstractDataSetModel dataSetModel, TempQingFileCache tempQingFileCache) {
        this(dataSetModel, false, tempQingFileCache);
    }

    public void addRow(Map<String, Object> rowData, int maxRow) throws AbstractDataSourceException, InterruptedException {
        this.memoryDatas.add(rowData);
        if (this.flushToDiskAtOnce || this.memoryDatas.size() == maxRow) {
            try {
                this.flushToDisk();
            }
            finally {
                this.memoryDatas.clear();
            }
        }
    }

    private void flushToDisk() throws InterruptedException, AbstractDataSourceException {
        IQingFile tempFiledataAccesser;
        if (this.memoryDatas.isEmpty()) {
            return;
        }
        if (this.dataSetModel.getRowValueComparator() != null) {
            Collections.sort(this.memoryDatas, this.dataSetModel.getRowValueComparator());
            tempFiledataAccesser = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
            this.tempQingFiles.add(tempFiledataAccesser);
            this.tempDataSourceWriter = new QSDataSourceWriter(tempFiledataAccesser);
            this.tempDataSourceWriter.start(this.dataSetModel.getMetaInfo());
        } else if (this.tempDataSourceWriter == null) {
            tempFiledataAccesser = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
            this.tempDataSourceWriter = new QSDataSourceWriter(tempFiledataAccesser);
            this.tempDataSourceWriter.start(this.dataSetModel.getMetaInfo());
            this.tempQingFiles.add(tempFiledataAccesser);
        }
        for (Map<String, Object> memoryData : this.memoryDatas) {
            Object[] row = JoinUtil.mapToObject(this.dataSetModel.getMetaInfo(), memoryData);
            this.tempDataSourceWriter.writeData(row);
        }
        if (this.dataSetModel.getRowValueComparator() != null) {
            this.tempDataSourceWriter.finishWriteData();
            this.tempDataSourceWriter.close(null);
            this.tempDataSourceWriter = null;
        }
    }

    private void flushAllToDisk() throws InterruptedException, AbstractDataSourceException {
        Throwable exception = null;
        try {
            this.flushToDisk();
            if (this.tempDataSourceWriter != null) {
                this.tempDataSourceWriter.finishWriteData();
            }
        }
        catch (InterruptedException e) {
            exception = e;
            throw e;
        }
        catch (AbstractDataSourceException e) {
            exception = e;
            throw e;
        }
        finally {
            this.clearWriter((Exception)exception);
        }
    }

    private void clearTempFile() {
        this.tempQingFileCache.clearTempFile();
    }

    private void clearWriter(Exception exception) {
        this.memoryDatas.clear();
        if (this.tempDataSourceWriter != null) {
            this.tempDataSourceWriter.close(exception);
            this.tempDataSourceWriter = null;
        }
    }

    public void clear(Exception exception) {
        this.clearTempFile();
        this.clearWriter(exception);
    }

    private AbstractAtomicDataSet createDiskAtomicDataSet(boolean deleteOnClose) throws AbstractDataSourceException {
        PersistentDataSet dataSet = null;
        try {
            LinkedList<IDataSourceVisitor> dataSourceVisitors = new LinkedList<IDataSourceVisitor>();
            for (IQingFile dataFile : this.tempQingFiles) {
                dataSourceVisitors.add(new QSDataSourceVisitor((IQingFileVisitor)dataFile));
                this.tempQingFileCache.cacheTempFile(dataFile);
            }
            dataSet = new PersistentDataSet(new DataSetModel(this.dataSetModel.getEntityNames(), this.dataSetModel.getMetaInfo(), null, dataSourceVisitors, this.dataSetModel.getRowValueComparator()));
            if (deleteOnClose) {
                dataSet.addCloseListener(new DeleteTempFileCloseListener(this.tempQingFiles));
            }
            this.tempQingFiles.clear();
        }
        catch (AbstractDataSourceException e) {
            this.clearTempFile();
            throw e;
        }
        return dataSet;
    }

    private AbstractAtomicDataSet createMemoryDataSet() {
        if (this.dataSetModel.getRowValueComparator() != null) {
            Collections.sort(this.memoryDatas, this.dataSetModel.getRowValueComparator());
        }
        return new MemoryDataSet(this.dataSetModel, this.memoryDatas);
    }

    public AbstractAtomicDataSet createDataSet(boolean deleteOnClose) throws InterruptedException, AbstractDataSourceException {
        AbstractAtomicDataSet dataSet = null;
        if (this.tempQingFiles.size() > 0) {
            this.flushAllToDisk();
            dataSet = this.createDiskAtomicDataSet(deleteOnClose);
        } else {
            dataSet = this.createMemoryDataSet();
        }
        return dataSet;
    }
}

