/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.util;

import com.kingdee.bos.qing.common.Messages;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.UnAnalysableException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import com.kingdee.bos.qing.datasource.model.AnalysisPathModel;
import com.kingdee.bos.qing.datasource.model.DataSetModel;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.model.graph.DirectedGraph;
import com.kingdee.bos.qing.datasource.model.graph.ERGraph;
import com.kingdee.bos.qing.datasource.model.graph.ERGraphUtil;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MainJoinDataSetModelInitializer {
    private List<DSMetaEntity> entities;
    private MultiDataSourceWrap multiDataSourceWrap;
    private ERGraph erGraph;
    private List<DSMetaRelation> relations;
    private boolean isNeedJoinAllFields = true;

    public MainJoinDataSetModelInitializer(List<DSMetaEntity> entities, List<DSMetaRelation> relations, MultiDataSourceWrap multiDataSourceWrap) {
        this.entities = entities;
        this.multiDataSourceWrap = multiDataSourceWrap;
        this.erGraph = new ERGraph(entities, relations);
        this.relations = relations;
    }

    public void setNeedJoinAllFields(boolean needJoinAllFields) {
        this.isNeedJoinAllFields = needJoinAllFields;
    }

    private String[] parseDsFieldKey(DSFieldKey field) {
        String entityName = field.getEntityName();
        String propertyName = field.getPropertyName();
        if (null == entityName) {
            String[] splits = propertyName.split("\\.");
            entityName = splits[0];
            propertyName = splits.length > 1 ? splits[1] : "";
        }
        return new String[]{entityName, propertyName};
    }

    private void collectSelectEntity(DSFieldKey field, Map<String, DSMetaEntity> allDSMetaEntityMpas, Map<String, DSMetaEntity> selectedEntitiesMap) {
        String parentEntityName;
        String[] filePartName = this.parseDsFieldKey(field);
        String entityName = filePartName[0];
        DSMetaEntity entity = allDSMetaEntityMpas.get(entityName);
        if (null == entity) {
            return;
        }
        if (!selectedEntitiesMap.containsKey(entityName)) {
            selectedEntitiesMap.put(entityName, entity);
        }
        if ((parentEntityName = entity.getParentName()) != null) {
            this.collectParentDSMetaEntity(parentEntityName, allDSMetaEntityMpas, selectedEntitiesMap);
        }
    }

    private void collectParentDSMetaEntity(String parentEntityName, Map<String, DSMetaEntity> allDSMetaEntityMpas, Map<String, DSMetaEntity> selectedEntitiesMap) {
        if (parentEntityName != null) {
            DSMetaEntity parentEntity = allDSMetaEntityMpas.get(parentEntityName);
            if (!selectedEntitiesMap.containsKey(parentEntityName)) {
                selectedEntitiesMap.put(parentEntityName, parentEntity);
            }
            if (parentEntity != null && parentEntity.getParentName() != null) {
                this.collectParentDSMetaEntity(parentEntity.getParentName(), allDSMetaEntityMpas, selectedEntitiesMap);
            }
        }
    }

    private void collectSelectedField(DSFieldKey field, Set<DSFieldKey> newDSFieldKeys, Map<String, Set<String>> allPropertyNameMaps, Map<String, DSMetaEntity> allDSMetaEntityMaps) {
        String[] filePartName = this.parseDsFieldKey(field);
        String entityName = filePartName[0];
        String propertyName = filePartName[1];
        DSMetaEntity entity = allDSMetaEntityMaps.get(entityName);
        Set<String> properyNameSet = allPropertyNameMaps.get(entityName);
        if (entity == null || properyNameSet == null || !"_ROWID_".equals(propertyName) && !properyNameSet.contains(propertyName)) {
            return;
        }
        newDSFieldKeys.add(new DSFieldKey(field.toFullName()));
    }

    public AbstractDataSetModel initialize(Set<DSFieldKey> fields, Set<IPushdownFilter> filters) throws AbstractDataSourceException {
        HashMap<String, Set<String>> allPropertyNameMaps = new HashMap<String, Set<String>>(this.entities.size());
        HashMap<String, DSMetaEntity> allDSMetaEntityMaps = new HashMap<String, DSMetaEntity>(this.entities.size());
        for (DSMetaEntity dSMetaEntity : this.entities) {
            allDSMetaEntityMaps.put(dSMetaEntity.getName(), dSMetaEntity);
            allPropertyNameMaps.put(dSMetaEntity.getName(), dSMetaEntity.createProperyNameSet());
        }
        HashMap<String, DSMetaEntity> selectedEntitiesMap = new HashMap<String, DSMetaEntity>();
        for (DSFieldKey field : fields) {
            this.collectSelectEntity(field, allDSMetaEntityMaps, selectedEntitiesMap);
        }
        if (filters != null && !filters.isEmpty()) {
            for (IPushdownFilter filter : filters) {
                Set associatedFields = filter.getAssociatedFields();
                for (DSFieldKey field : associatedFields) {
                    this.collectSelectEntity(field, allDSMetaEntityMaps, selectedEntitiesMap);
                }
            }
        }
        AbstractDataSetModel abstractDataSetModel = null;
        if (selectedEntitiesMap.isEmpty()) {
            return abstractDataSetModel;
        }
        if (selectedEntitiesMap.size() == 1) {
            Set entrySet = selectedEntitiesMap.entrySet();
            DSMetaEntity selectedEntity = (DSMetaEntity)entrySet.iterator().next().getValue();
            DataSetModel dataSetModel = DataSetModel.createDataSetModel(this.multiDataSourceWrap, selectedEntity.getName(), selectedEntity.createProperyNameSet());
            return dataSetModel;
        }
        HashSet<DSFieldKey> newDSFieldKeys = new HashSet<DSFieldKey>();
        for (DSFieldKey field : fields) {
            this.collectSelectedField(field, newDSFieldKeys, allPropertyNameMaps, allDSMetaEntityMaps);
        }
        if (filters != null && !filters.isEmpty()) {
            for (IPushdownFilter filter : filters) {
                DSFieldKey field;
                if (!(filter instanceof AbstractUnderDSFilter)) continue;
                ((AbstractUnderDSFilter)filter).resetFieldAfterJoin();
                field = ((AbstractUnderDSFilter)filter).getField();
                this.collectSelectedField(field, newDSFieldKeys, allPropertyNameMaps, allDSMetaEntityMaps);
            }
        }
        fields.clear();
        fields.addAll(newDSFieldKeys);
        AnalysisPathModel analysisPathModel = ERGraphUtil.getAnalysisPathModel((ERGraph)this.erGraph, selectedEntitiesMap);
        if (analysisPathModel == null) {
            String msg = Messages.getMLS("theCurrentFieldCannotBeParsed", "\u5f53\u524d\u6240\u9009\u5b57\u6bb5\u4e0d\u80fd\u8fdb\u884c\u5206\u6790\u3002");
            throw new UnAnalysableException(msg);
        }
        return MainJoinDataSetModelInitializer.createMainDataSetModel(analysisPathModel, this.relations, this.multiDataSourceWrap, this.isNeedJoinAllFields, newDSFieldKeys, selectedEntitiesMap);
    }

    public static AbstractDataSetModel createMainDataSetModel(AnalysisPathModel analysisPathModel, List<DSMetaRelation> relations, MultiDataSourceWrap multiDataSourceWrap, boolean isNeedJoinAllFields, Set<DSFieldKey> newDSFieldKeys, Map<String, DSMetaEntity> selectedEntitiesMap) throws AbstractDataSourceException {
        Object entityName;
        HashMap<String, AbstractDataSetModel> dataSetMap = new HashMap<String, AbstractDataSetModel>();
        List oneToOneGraphs = analysisPathModel.getOneToOneGraphs();
        if (oneToOneGraphs != null && !oneToOneGraphs.isEmpty()) {
            for (DirectedGraph oneToOneGraph : oneToOneGraphs) {
                Set vertexs = oneToOneGraph.getVertexs();
                TreeSet oneToOneRelationSet = new TreeSet();
                for (String vertex : vertexs) {
                    Map from = oneToOneGraph.edgesTo((Object)vertex);
                    oneToOneRelationSet.addAll(from.values());
                }
                for (DSMetaRelation oneToOneRelation : oneToOneRelationSet) {
                    MainJoinDataSetModelInitializer.relationDataSetInit(relations, multiDataSourceWrap, isNeedJoinAllFields, oneToOneRelation, dataSetMap, selectedEntitiesMap, newDSFieldKeys);
                }
            }
        }
        List startEntities = analysisPathModel.getStartEntities();
        DirectedGraph mainGraph = analysisPathModel.getMainGraphAfterMerge();
        Map mergeNameMap = analysisPathModel.getMergeNameMap();
        HashMap<String, String> entityMergeName = new HashMap<String, String>(16);
        for (Map.Entry entry : mergeNameMap.entrySet()) {
            entityName = (String)entry.getKey();
            String mergeName = (String)entry.getValue();
            entityMergeName.put(mergeName, (String)entityName);
        }
        AbstractDataSetModel mainDataSetModel = null;
        if (mainGraph.getVertexs().size() > 1) {
            HashSet<DSMetaRelation> visitedRelationSet = new HashSet<DSMetaRelation>();
            for (String startEntity : startEntities) {
                MainJoinDataSetModelInitializer.dfs(relations, multiDataSourceWrap, isNeedJoinAllFields, (DirectedGraph<String, DSMetaRelation>)mainGraph, startEntity, entityMergeName, dataSetMap, selectedEntitiesMap, visitedRelationSet, newDSFieldKeys);
                String entityName2 = (String)entityMergeName.get(startEntity);
                if (entityName2 != null) {
                    mainDataSetModel = (AbstractDataSetModel)dataSetMap.get(entityName2);
                    dataSetMap.put(startEntity, mainDataSetModel);
                }
                mainDataSetModel = (AbstractDataSetModel)dataSetMap.get(startEntity);
            }
        } else {
            String startEntity = (String)startEntities.get(0);
            entityName = (String)entityMergeName.get(startEntity);
            if (entityName != null) {
                mainDataSetModel = (AbstractDataSetModel)dataSetMap.get(entityName);
                dataSetMap.put(startEntity, mainDataSetModel);
            }
        }
        return mainDataSetModel;
    }

    private static void dfs(List<DSMetaRelation> relations, MultiDataSourceWrap multiDataSourceWrap, boolean isNeedJoinAllFields, DirectedGraph<String, DSMetaRelation> mainGraph, String startEntity, Map<String, String> entityMergeName, Map<String, AbstractDataSetModel> dataSetMap, Map<String, DSMetaEntity> selectedEntitiesMap, Set<DSMetaRelation> visitedRelationSet, Set<DSFieldKey> newSelectedDSFieldKeys) throws AbstractDataSourceException {
        String entityName = entityMergeName.get(startEntity);
        if (entityName != null) {
            AbstractDataSetModel mergeEntityDataModel = dataSetMap.get(entityName);
            dataSetMap.put(startEntity, mergeEntityDataModel);
        }
        Map to = mainGraph.edgesFrom((Object)startEntity);
        HashMap toTemp = new HashMap(to.size());
        for (Map.Entry entityEntry : to.entrySet()) {
            DSMetaRelation relation = (DSMetaRelation)to.get(entityEntry.getKey());
            toTemp.put(relation, entityEntry.getKey());
        }
        TreeSet relationSet = new TreeSet(to.values());
        for (DSMetaRelation relation : relationSet) {
            String otherEntity = (String)toTemp.get(relation);
            if (visitedRelationSet.contains(relation)) continue;
            visitedRelationSet.add(relation);
            MainJoinDataSetModelInitializer.dfs(relations, multiDataSourceWrap, isNeedJoinAllFields, mainGraph, otherEntity, entityMergeName, dataSetMap, selectedEntitiesMap, visitedRelationSet, newSelectedDSFieldKeys);
            MainJoinDataSetModelInitializer.relationDataSetInit(relations, multiDataSourceWrap, isNeedJoinAllFields, relation, dataSetMap, selectedEntitiesMap, newSelectedDSFieldKeys);
        }
    }

    private static void relationDataSetInit(List<DSMetaRelation> relations, MultiDataSourceWrap multiDataSourceWrap, boolean isNeedJoinAllFields, DSMetaRelation relation, Map<String, AbstractDataSetModel> dataSetMap, Map<String, DSMetaEntity> selectedEntitiesMap, Set<DSFieldKey> newSelectedDSFieldKeys) throws AbstractDataSourceException {
        newSelectedDSFieldKeys.add(new DSFieldKey(NameUtil.encodeFullName((String)relation.getFromEntity().getName(), (String)relation.getFromProperty().getName())));
        newSelectedDSFieldKeys.add(new DSFieldKey(NameUtil.encodeFullName((String)relation.getToEntity().getName(), (String)relation.getToProperty().getName())));
        String leftFieldFullName = relation.getFromFieldFullName();
        String rightFieldFullName = relation.getToFieldFullName();
        String leftEntity = relation.getFromEntity().getName();
        String rightEntity = relation.getToEntity().getName();
        AbstractDataSetModel leftDataSet = dataSetMap.get(leftEntity);
        AbstractDataSetModel rightDataSet = dataSetMap.get(rightEntity);
        if (leftDataSet == null) {
            leftDataSet = MainJoinDataSetModelInitializer.createDataSetModel(relations, multiDataSourceWrap, isNeedJoinAllFields, selectedEntitiesMap, newSelectedDSFieldKeys, leftEntity);
        }
        if (rightDataSet == null) {
            rightDataSet = MainJoinDataSetModelInitializer.createDataSetModel(relations, multiDataSourceWrap, isNeedJoinAllFields, selectedEntitiesMap, newSelectedDSFieldKeys, rightEntity);
        }
        JoinDataSetModel mergeDataSet = null;
        switch (relation.getJoinType()) {
            case LeftJoin: {
                mergeDataSet = JoinDataSetModel.createJoinDataSetModel(leftDataSet, rightDataSet, leftFieldFullName, rightFieldFullName, JoinDataSetModel.JoinType.LeftJoin);
                break;
            }
            case RightJoin: {
                mergeDataSet = JoinDataSetModel.createJoinDataSetModel(rightDataSet, leftDataSet, rightFieldFullName, leftFieldFullName, JoinDataSetModel.JoinType.LeftJoin);
                break;
            }
            case InnerJoin: {
                mergeDataSet = JoinDataSetModel.createJoinDataSetModel(leftDataSet, rightDataSet, leftFieldFullName, rightFieldFullName, JoinDataSetModel.JoinType.InnerJoin);
                break;
            }
            default: {
                mergeDataSet = JoinDataSetModel.createJoinDataSetModel(leftDataSet, rightDataSet, leftFieldFullName, rightFieldFullName, JoinDataSetModel.JoinType.FullJoin);
            }
        }
        for (String entityName : mergeDataSet.getEntityNames()) {
            dataSetMap.put(entityName, mergeDataSet);
        }
    }

    private static AbstractDataSetModel createDataSetModel(List<DSMetaRelation> relations, MultiDataSourceWrap multiDataSourceWrap, boolean isNeedJoinAllFields, Map<String, DSMetaEntity> selectedEntitiesMap, Set<DSFieldKey> newSelectedDSFieldKeys, String leftEntity) throws AbstractDataSourceException {
        DSMetaEntity selectedEntity = selectedEntitiesMap.get(leftEntity);
        Set<String> selectFields = MainJoinDataSetModelInitializer.createDataModelSelectFields(relations, isNeedJoinAllFields, newSelectedDSFieldKeys, selectedEntity);
        return DataSetModel.createDataSetModel(multiDataSourceWrap, selectedEntity.getName(), selectFields);
    }

    private static Set<String> createDataModelSelectFields(List<DSMetaRelation> relations, boolean isNeedJoinAllFields, Set<DSFieldKey> newSelectedDSFieldKeys, DSMetaEntity selectedEntity) {
        if (isNeedJoinAllFields) {
            return selectedEntity.createProperyNameSet();
        }
        HashSet<String> result = new HashSet<String>();
        MainJoinDataSetModelInitializer.addUsedField(newSelectedDSFieldKeys, selectedEntity, result);
        MainJoinDataSetModelInitializer.addRelationField(relations, selectedEntity, result);
        return result;
    }

    private static void addUsedField(Set<DSFieldKey> newSelectedDSFieldKeys, DSMetaEntity selectedEntity, Set<String> result) {
        for (DSFieldKey dsFieldKey : newSelectedDSFieldKeys) {
            String[] splits = dsFieldKey.getPropertyName().split("\\.");
            if (!selectedEntity.getName().equals(splits[0])) continue;
            result.add(splits[1]);
        }
    }

    private static void addRelationField(List<DSMetaRelation> relations, DSMetaEntity selectedEntity, Set<String> result) {
        for (DSMetaRelation relation : relations) {
            if (relation.getFromEntity().getName().equals(selectedEntity.getName())) {
                result.add(relation.getFromProperty().getName());
                continue;
            }
            if (!relation.getToEntity().getName().equals(selectedEntity.getName())) continue;
            result.add(relation.getToProperty().getName());
        }
    }
}

