/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.join.worknodes;

import com.kingdee.bos.qing.common.memory.MemRuntimeMonitor;
import com.kingdee.bos.qing.common.memory.MemWarningLevel;
import com.kingdee.bos.qing.common.memory.MemoryObserver;
import com.kingdee.bos.qing.datasource.join.config.QingJoinConfig;
import com.kingdee.bos.qing.datasource.join.task.JoinTaskRuntime;
import com.kingdee.bos.qing.datasource.join.task.TaskTimeoutListener;
import com.kingdee.bos.qing.datasource.join.util.JoinUtil;
import com.kingdee.bos.qing.datasource.join.worknodes.JoinWorkNode;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class TaskRetryExecutor {
    private static final TaskRetryExecutor instance = new TaskRetryExecutor();
    private List<RetryTask> submitList = new ArrayList<RetryTask>();
    private LinkedBlockingQueue<RetryTask> pendingList = new LinkedBlockingQueue();
    private volatile int globalRetryTimes = 1;
    private Set<String> retryingTaskIds = new HashSet<String>();
    private Object lock = new Object();
    private volatile boolean isObserverRegisterd = false;
    private ExecutorService retryExecutor = Executors.newSingleThreadExecutor();
    private int maxRetryParalise = QingJoinConfig.getInstance().getMaxRetryParallise();
    private MemWarningLevel retryTriggerLevel = QingJoinConfig.getInstance().getRetryTriggerLevel();

    private TaskRetryExecutor() {
        this.retryExecutor.submit(new RetryWorker());
    }

    public static TaskRetryExecutor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRetryTask(JoinWorkNode workNode, JoinTaskRuntime runtime) {
        Object object = this.lock;
        synchronized (object) {
            this.globalRetryTimes = this.globalRetryTimes < runtime.getRetryTimes() ? runtime.getRetryTimes() : this.globalRetryTimes;
            this.retryingTaskIds.remove(runtime.getTaskId());
            this.submitList.add(new RetryTask(workNode, runtime));
            if (!this.isObserverRegisterd) {
                this.isObserverRegisterd = true;
                MemRuntimeMonitor.getInstance().registerIfAbsent((MemoryObserver)new MemObserverImpl());
            }
        }
    }

    public TaskTimeoutListener timeoutListener() {
        return new TimeoutListenerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryFinish(String taskId) {
        Object object = this.lock;
        synchronized (object) {
            this.retryingTaskIds.remove(taskId);
            if (this.submitList.size() == 0 && this.retryingTaskIds.size() == 0) {
                MemRuntimeMonitor.getInstance().unRegister(TaskRetryExecutor.class.getName());
                this.globalRetryTimes = 1;
                this.isObserverRegisterd = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRetryTask() {
        Object object = this.lock;
        synchronized (object) {
            return this.submitList.size() > 0 || this.retryingTaskIds.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRetryTaskSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.submitList.size() + this.retryingTaskIds.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareToRetry(int retryTaskSize) {
        Object object = this.lock;
        synchronized (object) {
            if (this.retryingTaskIds.size() == retryTaskSize) {
                return;
            }
            Collections.sort(this.submitList);
            for (int i = 0; i < retryTaskSize; ++i) {
                RetryTask task;
                if (this.submitList.size() <= i || !(task = this.submitList.remove(i)).runtime.resetBeforeRetry()) continue;
                this.retryingTaskIds.add(task.runtime.getTaskId());
                this.pendingList.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentSubmitRetryTaskSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.submitList.size();
        }
    }

    private class MemObserverImpl
    implements MemoryObserver {
        private long waitTimes = 0L;
        private static final int MAX_WAIT_TIME = 2;
        private int initialParalise = -1;

        private MemObserverImpl() {
        }

        public void notifyMemoryWarning(MemWarningLevel warningLevel, double currentOldSpaceRatio) {
            if (this.waitTimes < 2L) {
                ++this.waitTimes;
                return;
            }
            if (null != TaskRetryExecutor.this.retryTriggerLevel && warningLevel.getPriority() > TaskRetryExecutor.this.retryTriggerLevel.getPriority()) {
                return;
            }
            int paraliseSize = this.getMaxParalise();
            TaskRetryExecutor.this.prepareToRetry(paraliseSize);
        }

        private int getMaxParalise() {
            if (TaskRetryExecutor.this.maxRetryParalise > 0) {
                return TaskRetryExecutor.this.maxRetryParalise;
            }
            if (TaskRetryExecutor.this.globalRetryTimes == 1) {
                if (this.initialParalise == -1) {
                    int totalRetrySize = TaskRetryExecutor.this.getCurrentSubmitRetryTaskSize();
                    this.initialParalise = this.getHalfSize(totalRetrySize);
                }
                return this.initialParalise;
            }
            if (TaskRetryExecutor.this.globalRetryTimes == 2) {
                return this.getHalfSize(this.initialParalise);
            }
            return 1;
        }

        private int getHalfSize(int totalRetrySize) {
            int half = totalRetrySize / 2;
            return half == 0 ? 1 : half;
        }

        public MemWarningLevel lowestLevel() {
            return MemWarningLevel.NORMAL;
        }

        public int getPriority() {
            return 0;
        }

        public String getObserverId() {
            return TaskRetryExecutor.class.getName();
        }
    }

    private class RetryWorker
    implements Runnable {
        private boolean running = true;

        private RetryWorker() {
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    RetryTask retryTask = (RetryTask)TaskRetryExecutor.this.pendingList.take();
                    this.doRetry(retryTask);
                }
            }
            catch (InterruptedException e) {
                LogUtil.error((String)(JoinUtil.joinLogPrefix() + " retry thread interrupt"), (Throwable)e);
            }
        }

        public void stop() {
            this.running = false;
        }

        private void doRetry(RetryTask retryTask) {
            JoinWorkNode workNode = retryTask.workNode;
            JoinTaskRuntime taskRuntime = retryTask.runtime;
            LogUtil.info((String)(JoinUtil.joinLogPrefix() + "retry join task:" + taskRuntime.getTaskId()));
            try {
                workNode.submitJoin(taskRuntime);
            }
            catch (Exception e) {
                LogUtil.error((String)(JoinUtil.joinLogPrefix() + " retry task error:" + taskRuntime.getTaskId()), (Throwable)e);
                taskRuntime.end(null);
            }
        }
    }

    private class TimeoutListenerImpl
    implements TaskTimeoutListener {
        private TimeoutListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeout(String joinTaskId, JoinTaskRuntime taskRuntime) {
            Object object = TaskRetryExecutor.this.lock;
            synchronized (object) {
                if (TaskRetryExecutor.this.retryingTaskIds.contains(taskRuntime.getTaskId())) {
                    return;
                }
                Iterator it = TaskRetryExecutor.this.submitList.iterator();
                while (it.hasNext()) {
                    RetryTask rt = (RetryTask)it.next();
                    if (!rt.runtime.getTaskId().equals(taskRuntime.getTaskId())) continue;
                    it.remove();
                    rt.workNode.forceFinishRetryTaskOnTimeout(taskRuntime);
                    break;
                }
            }
        }
    }

    private static class RetryTask
    implements Comparable<RetryTask> {
        private JoinWorkNode workNode;
        private JoinTaskRuntime runtime;

        public RetryTask(JoinWorkNode workNode, JoinTaskRuntime runtime) {
            this.workNode = workNode;
            this.runtime = runtime;
        }

        @Override
        public int compareTo(RetryTask o) {
            AbstractDataSetModel thisModel = this.runtime.getTaskRequest().getDataSetModel();
            AbstractDataSetModel targetModel = o.runtime.getTaskRequest().getDataSetModel();
            int thisModelFieldSize = thisModel.getMetaInfo().getSize();
            int targetModelFieldSize = targetModel.getMetaInfo().getSize();
            if (this.runtime.getTotalAdviseRow() > 0L && o.runtime.getTotalAdviseRow() > 0L) {
                return (long)thisModelFieldSize * this.runtime.getTotalAdviseRow() > (long)targetModelFieldSize * o.runtime.getTotalAdviseRow() ? 1 : -1;
            }
            return thisModelFieldSize > targetModelFieldSize ? 1 : -1;
        }
    }
}

