/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.memorymanage;

import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataRowSize {
    private MetaInfo metaInfo;
    private List<DataType> types;
    private int minRetainSize = 0;
    private List<Integer> stringTypeIndexs = new ArrayList<Integer>();

    public DataRowSize(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        this.types = metaInfo.getFieldDataTypes();
        this.estimateRetainSize();
        this.initStringTypeIndex();
    }

    private void estimateRetainSize() {
        block7: for (int i = 0; i < this.types.size(); ++i) {
            DataType type = this.types.get(i);
            switch (type) {
                case DATETIME: 
                case DATE: {
                    this.minRetainSize += 500;
                    continue block7;
                }
                case INT: {
                    this.minRetainSize += 40;
                    continue block7;
                }
                case NUMBER: {
                    this.minRetainSize += 120;
                    continue block7;
                }
                case BOOLEAN: {
                    this.minRetainSize += 29;
                    continue block7;
                }
                case STRING: {
                    this.minRetainSize += 36;
                    continue block7;
                }
            }
        }
    }

    private void initStringTypeIndex() {
        for (int i = 0; i < this.types.size(); ++i) {
            if (this.types.get(i) != DataType.STRING) continue;
            this.stringTypeIndexs.add(i);
        }
    }

    public long sizeOf(Map<String, Object> rowDatas) {
        int strSize = this.calculateStringSize(rowDatas);
        return 48 + strSize + this.minRetainSize + rowDatas.size() * 32;
    }

    public long sizeOfObjectData(Map<String, Object> rowDatas) {
        int strSize = this.calculateStringSize(rowDatas);
        return strSize + this.minRetainSize;
    }

    public long getMinRetainSize() {
        return this.minRetainSize;
    }

    private int calculateStringSize(Map<String, Object> rowDatas) {
        int stringSize = 0;
        List columnNames = this.metaInfo.getFieldNames();
        for (Integer index : this.stringTypeIndexs) {
            String colName = (String)columnNames.get(index);
            Object value = rowDatas.get(colName);
            if (null == value) continue;
            String strValue = String.valueOf(value);
            stringSize += strValue.getBytes().length;
        }
        return stringSize;
    }
}

