/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.model;

import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;

public class JoinDataSetModel
extends AbstractDataSetModel {
    private static final boolean[][] TypeEqual = new boolean[][]{{true, false, false, false, false, false}, {false, true, true, false, false, false}, {false, true, true, false, false, false}, {false, false, false, true, true, false}, {false, false, false, true, true, false}, {false, false, false, false, false, true}};
    private final AbstractDataSetModel leftDataSetModel;
    private final AbstractDataSetModel rightDataSetModel;
    private final DSFieldKey leftField;
    private final DSFieldKey rightField;
    private final DataType leftFieldDataType;
    private final DataType rightFieldDataType;
    private final boolean changeLeftToString;
    private final boolean changeRightToString;
    private final JoinType joinType;

    private static boolean isDataTypeEqual(int left, int right) {
        return TypeEqual[left][right];
    }

    private JoinDataSetModel(MetaInfo metaInfo, AbstractDataSetModel leftDataSetModel, AbstractDataSetModel rightDataSetModel, String leftFieldFullName, String rightFieldFullName, JoinType joinType) {
        super(metaInfo);
        this.leftDataSetModel = leftDataSetModel;
        this.rightDataSetModel = rightDataSetModel;
        this.leftField = new DSFieldKey(leftFieldFullName);
        this.rightField = new DSFieldKey(rightFieldFullName);
        this.leftFieldDataType = metaInfo.getFieldDataType(metaInfo.getFieldNameIndex(leftFieldFullName));
        this.rightFieldDataType = metaInfo.getFieldDataType(metaInfo.getFieldNameIndex(rightFieldFullName));
        boolean joinDataTypeEqual = JoinDataSetModel.isDataTypeEqual(this.leftFieldDataType.getIndex(), this.rightFieldDataType.getIndex());
        boolean leftIsString = JoinDataSetModel.isDataTypeEqual(this.leftFieldDataType.getIndex(), DataType.STRING.getIndex());
        boolean rightIsString = JoinDataSetModel.isDataTypeEqual(this.rightFieldDataType.getIndex(), DataType.STRING.getIndex());
        this.changeLeftToString = !joinDataTypeEqual && !leftIsString;
        this.changeRightToString = !joinDataTypeEqual && !rightIsString;
        this.entityNames.addAll(leftDataSetModel.getEntityNames());
        this.entityNames.addAll(rightDataSetModel.getEntityNames());
        this.joinType = joinType;
    }

    public static JoinDataSetModel createJoinDataSetModel(AbstractDataSetModel leftDataSetModel, AbstractDataSetModel rightDataSetModel, String leftFieldFullName, String rightFieldFullName, JoinType joinType) {
        int index;
        MetaInfo metaInfo = new MetaInfo();
        MetaInfo leftMetaInfo = leftDataSetModel.getMetaInfo();
        MetaInfo righttMetaInfo = rightDataSetModel.getMetaInfo();
        if (leftMetaInfo != null && leftMetaInfo.getSize() > 0) {
            for (index = 0; index < leftMetaInfo.getSize(); ++index) {
                metaInfo.addField(leftMetaInfo.getFieldName(index), leftMetaInfo.getFieldDisplayName(index), leftMetaInfo.getFieldDataType(index));
            }
        }
        if (righttMetaInfo != null && righttMetaInfo.getSize() > 0) {
            for (index = 0; index < righttMetaInfo.getSize(); ++index) {
                metaInfo.addField(righttMetaInfo.getFieldName(index), righttMetaInfo.getFieldDisplayName(index), righttMetaInfo.getFieldDataType(index));
            }
        }
        return new JoinDataSetModel(metaInfo, leftDataSetModel, rightDataSetModel, leftFieldFullName, rightFieldFullName, joinType);
    }

    public static JoinDataSetModel createJoinDataSetModelExchangeBothSide(JoinDataSetModel oldJoinDataSetModel) {
        if (JoinType.LeftJoin == oldJoinDataSetModel.joinType) {
            throw new RuntimeException("unsupport exchange JoinDataModel, cause by left join");
        }
        return new JoinDataSetModel(oldJoinDataSetModel.metaInfo, oldJoinDataSetModel.rightDataSetModel, oldJoinDataSetModel.leftDataSetModel, oldJoinDataSetModel.rightField.toFullName(), oldJoinDataSetModel.leftField.toFullName(), oldJoinDataSetModel.joinType);
    }

    public static JoinDataSetModel copy(JoinDataSetModel oldJoinDataSetModel) {
        return new JoinDataSetModel(oldJoinDataSetModel.metaInfo, oldJoinDataSetModel.leftDataSetModel, oldJoinDataSetModel.rightDataSetModel, oldJoinDataSetModel.leftField.toFullName(), oldJoinDataSetModel.rightField.toFullName(), oldJoinDataSetModel.joinType);
    }

    public AbstractDataSetModel getLeftDataSetModel() {
        return this.leftDataSetModel;
    }

    public AbstractDataSetModel getRightDataSetModel() {
        return this.rightDataSetModel;
    }

    public DSFieldKey getLeftField() {
        return this.leftField;
    }

    public boolean isChangeLeftToString() {
        return this.changeLeftToString;
    }

    public DSFieldKey getRightField() {
        return this.rightField;
    }

    public boolean isChangeRightToString() {
        return this.changeRightToString;
    }

    public DataType getLeftFieldDataType() {
        return this.leftFieldDataType;
    }

    public DataType getRightFieldDataType() {
        return this.rightFieldDataType;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public String getModelDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("leftModel:").append(this.leftDataSetModel.getEntityNames().toString()).append(";");
        sb.append("rightModel:").append(this.rightDataSetModel.getEntityNames().toString()).append(";");
        sb.append("leftJoinField:").append(this.leftField.toFullName()).append(";");
        sb.append("rightJoinField:").append(this.rightField.toFullName()).append(";");
        sb.append("selectFields:").append(this.metaInfo.getFieldNames());
        sb.append("joinType:").append(this.joinType.name());
        return sb.toString();
    }

    public static enum JoinType {
        LeftJoin,
        InnerJoin,
        FullJoin;

    }
}

