/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.model;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiDataSourceWrap {
    private Map<Set<String>, AbstractSingleDataSourceVisitor> dataSourceMap = new ConcurrentHashMap<Set<String>, AbstractSingleDataSourceVisitor>();
    private List<CacheListener> cacheListeners = new LinkedList<CacheListener>();

    public MultiDataSourceWrap(Map<Set<String>, ? extends AbstractSingleDataSourceVisitor> dataSourceMap) {
        this.dataSourceMap.putAll(dataSourceMap);
    }

    public void addCacheListener(CacheListener cacheListener) {
        this.cacheListeners.add(cacheListener);
    }

    private void fireAddCacheListeners(Set<String> entityNameSet, AbstractSingleDataSourceVisitor dataSourceVisitor, IQingFile dataFile) {
        for (CacheListener cacheListener : this.cacheListeners) {
            cacheListener.addCache(entityNameSet, dataSourceVisitor, dataFile);
        }
    }

    public AbstractSingleDataSourceVisitor get(Set<String> entityNames) throws AbstractDataSourceException {
        return this.dataSourceMap.get(entityNames);
    }

    public boolean containsKey(Set<String> entityNames) {
        return this.dataSourceMap.containsKey(entityNames);
    }

    public void put(Set<String> entityNameSet, AbstractSingleDataSourceVisitor dataSourceVisitor, IQingFile dataFile) {
        this.dataSourceMap.put(entityNameSet, dataSourceVisitor);
        if (this.isCacheJoinFile(entityNameSet)) {
            this.fireAddCacheListeners(entityNameSet, dataSourceVisitor, dataFile);
        }
    }

    public String getOwnerId() {
        throw new UnsupportedOperationException("not supported get ownerId");
    }

    public String getThemeId() {
        throw new UnsupportedOperationException("not supported get themeId");
    }

    protected boolean isCacheJoinFile(Set<String> entityNameSet) {
        return true;
    }

    public Map<String, String> getUnionTableAdditionFilter(String unionTableName, String subTableBizName) {
        return null;
    }

    public static interface CacheListener {
        public void addCache(Set<String> var1, IDataSourceVisitor var2, IQingFile var3);
    }
}

