/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec;

import com.kingdee.bos.qing.datasource.cache.DataSourceCache;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceAccessException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.DetailCombinationFilter;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSContinuousFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDataIterator
implements IDataIterator {
    protected MetaInfo _metaInfo;
    protected List<Integer> _interestingFieldIndexs = new ArrayList<Integer>();
    protected Set<Integer> _interestingRowIDFieldIndexs = new HashSet<Integer>();
    protected List<String> _allFullFieldNames = new ArrayList<String>();
    protected Set<AbstractUnderDSFilter> _outerFilter;
    protected boolean _hasData;
    private DSFieldKey _rowidFieldKey = new DSFieldKey("_ROWID_");
    private IDataSourceWriter _dataSourceWriter;
    private Exception _exception;
    private DataSourceCache _dataSoruceCache;
    private boolean _isCache = false;
    private MetaInfo _iteratorMetaInfo;
    private long _currentRowIndex = 0L;

    public AbstractDataIterator(MetaInfo metaInfo) {
        this._metaInfo = metaInfo;
    }

    public void setOuterFilter(Set<AbstractUnderDSFilter> outerFilter) {
        this._outerFilter = outerFilter;
    }

    public Set<AbstractUnderDSFilter> getOuterFilter() {
        return this._outerFilter;
    }

    public final void init(Set<DSFieldKey> fields, Set<IPushdownFilter> filters, String cacheKey) throws AbstractDataSourceException, InterruptedException {
        try {
            if (this._outerFilter != null && !this._outerFilter.isEmpty()) {
                if (filters == null) {
                    filters = new HashSet<IPushdownFilter>();
                }
                filters.addAll(this._outerFilter);
            }
            if (filters != null && !filters.isEmpty()) {
                for (IPushdownFilter filter : filters) {
                    fields.addAll(filter.getAssociatedFields());
                }
            }
            this._iteratorMetaInfo = this._metaInfo.initSelectedField(this._interestingFieldIndexs, this._allFullFieldNames, fields, this._rowidFieldKey, cacheKey);
            HashMap<String, DataType> allSelectedFieldDataType = new HashMap<String, DataType>(this._iteratorMetaInfo.getSize());
            for (int index = 0; index < this._iteratorMetaInfo.getSize(); ++index) {
                String fieldName = this._iteratorMetaInfo.getFieldName(index);
                allSelectedFieldDataType.put(fieldName, this._iteratorMetaInfo.getFieldDataType(index));
            }
            for (Integer interestingFieldIndex : this._interestingFieldIndexs) {
                String fieldName = this._metaInfo.getFieldName(interestingFieldIndex.intValue());
                String[] names = NameUtil.decodeFullName((String)fieldName);
                if (!"_ROWID_".equals(names[1])) continue;
                this._interestingRowIDFieldIndexs.add(interestingFieldIndex);
            }
            this._currentRowIndex = 0L;
            this._hasData = this.clearIllegalFilters(filters, allSelectedFieldDataType);
            if (this._hasData) {
                this.initImpl(fields, filters);
            }
        }
        catch (AbstractDataSourceException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
        if (cacheKey != null && !cacheKey.isEmpty()) {
            this._isCache = true;
            this._dataSoruceCache = new DataSourceCache(cacheKey);
            this._dataSourceWriter = this._dataSoruceCache.createWriter();
            this._dataSourceWriter.start(this._iteratorMetaInfo);
        } else {
            this._isCache = false;
            this._dataSoruceCache = null;
        }
    }

    protected abstract void initImpl(Set<DSFieldKey> var1, Set<IPushdownFilter> var2) throws AbstractDataSourceException, InterruptedException;

    public final boolean hasNextRow() throws AbstractDataSourceException, InterruptedException {
        try {
            return this.hasNextRowImpl();
        }
        catch (AbstractDataSourceException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
    }

    protected abstract boolean hasNextRowImpl() throws AbstractDataSourceException, InterruptedException;

    public final Map<String, Object> nextRow() throws AbstractDataSourceException, InterruptedException {
        try {
            Map<String, Object> row = this.nextRowImpl();
            if (row != null) {
                row.put(this._rowidFieldKey.toFullName(), this._currentRowIndex++);
            }
            if (row == null || !this._isCache) {
                return row;
            }
            Object[] newRow = new Object[this._iteratorMetaInfo.getSize()];
            for (int index = 0; index < this._iteratorMetaInfo.getSize(); ++index) {
                newRow[index] = row.get(this._iteratorMetaInfo.getFieldName(index));
            }
            this._dataSourceWriter.writeData(newRow);
            return row;
        }
        catch (AbstractDataSourceException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
    }

    protected abstract Map<String, Object> nextRowImpl() throws AbstractDataSourceException, InterruptedException;

    public final void close() {
        this.closeImpl();
        if (this._dataSourceWriter != null) {
            try {
                this._dataSourceWriter.finishWriteData();
            }
            catch (DataSourcePersistenceException e) {
                if (this._exception == null) {
                    this._exception = e;
                }
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            this._dataSourceWriter.close(this._exception);
            this._dataSourceWriter = null;
            if (this._exception != null) {
                this._dataSoruceCache.remove();
                this._dataSoruceCache = null;
            }
        }
    }

    protected abstract void closeImpl();

    protected final boolean clearIllegalFilters(Set<IPushdownFilter> dsFilters, Map<String, DataType> allFieldDataType) throws DataSourceAccessException {
        if (dsFilters != null && !dsFilters.isEmpty()) {
            HashSet<IPushdownFilter> newDSFilters = new HashSet<IPushdownFilter>(dsFilters.size());
            for (IPushdownFilter dsFilter : dsFilters) {
                if (this.existIllegalField(allFieldDataType, dsFilter)) continue;
                if (dsFilter instanceof AbstractUnderDSFilter) {
                    if (((AbstractUnderDSFilter)dsFilter).isAllAccepted()) continue;
                    if (dsFilter instanceof UnderDSContinuousFilter) {
                        DataType dataType = allFieldDataType.get(((AbstractUnderDSFilter)dsFilter).getField().toFullName());
                        if (DataType.NUMBER != dataType && DataType.INT != dataType && DataType.DATE != dataType && DataType.DATETIME != dataType) {
                            continue;
                        }
                    } else if (dsFilter instanceof UnderDSDiscreteFilter) {
                        UnderDSDiscreteFilter underDSDiscreteFilter = (UnderDSDiscreteFilter)dsFilter;
                        List selectedValues = underDSDiscreteFilter.getSelected();
                        boolean isExclud = underDSDiscreteFilter.isExclude();
                        if (underDSDiscreteFilter.isFullValue() && isExclud) {
                            return false;
                        }
                        if (selectedValues.isEmpty() && !isExclud) {
                            return false;
                        }
                        if (selectedValues.isEmpty() && isExclud) {
                            continue;
                        }
                    }
                } else if (!(dsFilter instanceof DetailCombinationFilter)) {
                    throw new DataSourceAccessException("Something must be wrong.");
                }
                newDSFilters.add(dsFilter);
            }
            dsFilters.clear();
            dsFilters.addAll(newDSFilters);
        }
        return true;
    }

    private boolean existIllegalField(Map<String, DataType> allFieldDataType, IPushdownFilter dsFilter) {
        Set fields = dsFilter.getAssociatedFields();
        for (DSFieldKey field : fields) {
            DataType dataType = allFieldDataType.get(field.toFullName());
            if (dataType != null) continue;
            return true;
        }
        return false;
    }

    public MetaInfo getMetaInfo() {
        return this._metaInfo;
    }
}

