/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec;

import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.DistinctCompositeKey;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSingleDataSourceVisitor
extends AbstractDataSourceVisitor {
    public abstract MetaInfo getMetaInfo();

    @Override
    public boolean isFieldsExisted(Collection<String> searchFields) {
        MetaInfo metaInfo = this.getMetaInfo();
        for (String fieldKey : searchFields) {
            if (metaInfo.getFieldNameIndex(fieldKey) != -1) continue;
            return false;
        }
        return true;
    }

    public void collectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        if (valueCollecter == null) {
            return;
        }
        if (fields == null || fields.isEmpty()) {
            return;
        }
        ArrayList<DSFieldKey> newFields = new ArrayList<DSFieldKey>();
        if (filters != null) {
            newFields.addAll(fields);
            for (IPushdownFilter filter : filters) {
                newFields.addAll(filter.getAssociatedFields());
            }
        }
        boolean differentEntity = false;
        String firstEntityName = null;
        for (int index = 0; index < newFields.size(); ++index) {
            DSFieldKey field = (DSFieldKey)newFields.get(index);
            String entityName = field.getEntityName();
            if (firstEntityName == null) {
                firstEntityName = entityName;
                continue;
            }
            if (firstEntityName.equals(entityName)) continue;
            differentEntity = true;
            break;
        }
        ArrayList<DSFieldKey> exsitField = new ArrayList<DSFieldKey>();
        boolean hasFieldExsit = false;
        MetaInfo metaInfo = this.getMetaInfo();
        for (int index = 0; index < fields.size(); ++index) {
            DSFieldKey field = fields.get(index);
            String fieldName = null;
            fieldName = differentEntity ? field.toFullName() : field.getPropertyName();
            int fieldNameIndex = metaInfo.getFieldNameIndex(fieldName);
            if (fieldNameIndex < 0) {
                fields.set(index, null);
                continue;
            }
            hasFieldExsit = true;
            exsitField.add(field);
        }
        if (!hasFieldExsit) {
            return;
        }
        this.doCollectDistinctValue(valueCollecter, fields, exsitField, filters);
    }

    public void doCollectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, List<DSFieldKey> exsitFields, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        AbstractSingleDataSourceVisitor.collectDistinctValueWithIterator(this.iterator(), valueCollecter, fields, exsitFields, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectDistinctValueWithIterator(IDataIterator iterator, IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, List<DSFieldKey> exsitField, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        HashSet<DistinctCompositeKey> distinctValues = new HashSet<DistinctCompositeKey>();
        try {
            HashSet<DSFieldKey> keys = new HashSet<DSFieldKey>();
            keys.addAll(exsitField);
            iterator.init(keys, filters, null);
            while (iterator.hasNextRow()) {
                ServerRequestInvokeContext.staticCheckInterrupt();
                Map row = iterator.nextRow();
                DistinctCompositeKey distinctCompositeKey = new DistinctCompositeKey();
                for (DSFieldKey field : fields) {
                    if (field == null) continue;
                    String fieldKey = field.toFullName();
                    Object member = row.get(fieldKey);
                    distinctCompositeKey.addMember(fieldKey, member);
                }
                distinctValues.add(distinctCompositeKey);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{iterator});
        for (DistinctCompositeKey distinctCompositeKey : distinctValues) {
            ServerRequestInvokeContext.staticCheckInterrupt();
            valueCollecter.collect(distinctCompositeKey.getDims());
            if (!valueCollecter.isBreak()) continue;
            return;
        }
    }
}

