/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.DistinctCompositeKey;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import com.kingdee.bos.qing.datasource.spec.ListDataIterator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListSingleDataSourceVisitor
extends AbstractSingleDataSourceVisitor {
    private List<AbstractSingleDataSourceVisitor> singleDataSourceVisitors;

    public ListSingleDataSourceVisitor(List<AbstractSingleDataSourceVisitor> singleDataSourceVisitors) {
        this.singleDataSourceVisitors = singleDataSourceVisitors;
    }

    public IDataIterator iterator() throws AbstractDataSourceException {
        if (!this.hasData()) {
            throw new DataSourceNoDataException("no data in datasource");
        }
        ArrayList<IDataIterator> dataIterators = new ArrayList<IDataIterator>();
        try {
            for (AbstractSingleDataSourceVisitor singleDataSourceVisitor : this.singleDataSourceVisitors) {
                if (!singleDataSourceVisitor.hasData()) continue;
                dataIterators.add(singleDataSourceVisitor.iterator());
            }
        }
        catch (AbstractDataSourceException e) {
            for (IDataIterator dataIterator : dataIterators) {
                dataIterator.close();
            }
            throw e;
        }
        if (dataIterators.isEmpty()) {
            throw new DataSourceNoDataException("no data in datasource");
        }
        return new ListDataIterator(dataIterators);
    }

    @Override
    public void collectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> field, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        final HashSet distinctValues = new HashSet();
        IDistinctValueCollecter newValueCollecter = new IDistinctValueCollecter(){

            public boolean isBreak() {
                return false;
            }

            public void collect(Map<String, Object> value) {
                DistinctCompositeKey distinctCompositeKey = new DistinctCompositeKey();
                distinctCompositeKey.setDims(value);
                distinctValues.add(distinctCompositeKey);
            }
        };
        for (AbstractSingleDataSourceVisitor singleDataSourceVisitor : this.singleDataSourceVisitors) {
            singleDataSourceVisitor.collectDistinctValue(newValueCollecter, field, filters);
        }
        for (DistinctCompositeKey distinctCompositeKey : distinctValues) {
            valueCollecter.collect(distinctCompositeKey.getDims());
            if (!valueCollecter.isBreak()) continue;
            return;
        }
    }

    public Calendar[] getDateScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        Calendar minValue = null;
        Calendar maxValue = null;
        for (AbstractSingleDataSourceVisitor singleDataSourceVisitor : this.singleDataSourceVisitors) {
            Calendar[] subResult = singleDataSourceVisitor.getDateScope(field);
            Calendar minCalendar = null;
            Calendar maxCalendar = null;
            if (subResult != null) {
                minCalendar = subResult[0];
                maxCalendar = subResult[1];
            }
            if (minCalendar != null && (minValue == null || minCalendar.compareTo(minValue) < 0)) {
                minValue = minCalendar;
            }
            if (maxCalendar == null || maxValue != null && maxCalendar.compareTo(maxValue) <= 0) continue;
            maxValue = maxCalendar;
        }
        if (minValue == null && maxValue == null) {
            return null;
        }
        return new Calendar[]{minValue, maxValue};
    }

    public BigDecimal[] getNumberScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        BigDecimal minValue = null;
        BigDecimal maxValue = null;
        for (AbstractDataSourceVisitor abstractDataSourceVisitor : this.singleDataSourceVisitors) {
            BigDecimal[] subResult = abstractDataSourceVisitor.getNumberScope(field);
            if (subResult == null) continue;
            BigDecimal minSubValue = subResult[0];
            BigDecimal maxSubValue = subResult[1];
            minValue = minValue == null ? minSubValue : minValue.min(minSubValue);
            if (maxValue == null) {
                maxValue = maxSubValue;
                continue;
            }
            maxValue = maxValue.max(maxSubValue);
        }
        if (minValue == null && maxValue == null) {
            return null;
        }
        return new BigDecimal[]{minValue, maxValue};
    }

    @Override
    public boolean hasData() {
        for (AbstractSingleDataSourceVisitor singleDataSourceVisitor : this.singleDataSourceVisitors) {
            if (!singleDataSourceVisitor.hasData()) continue;
            return true;
        }
        return false;
    }

    public DSMeta getMeta() {
        return this.singleDataSourceVisitors.get(0).getMeta();
    }

    @Override
    public MetaInfo getMetaInfo() {
        return this.singleDataSourceVisitors.get(0).getMetaInfo();
    }
}

