/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.csv;

import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.exception.UnAnalysableException;
import com.kingdee.bos.qing.datasource.meta.DSElimination;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.csv.CsvDataIterator;
import com.kingdee.bos.qing.datasource.spec.csv.CsvReader;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CsvDataSourceVisitor
extends AbstractSingleDataSourceVisitor {
    private long _rowCount = -1L;
    private MetaInfo _metaInfo;
    private List<DSElimination> _eliminations;
    private IQingFileVisitor _dataFile;
    private DSMeta _dSMeta;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CsvDataSourceVisitor(IQingFileVisitor dataFile, IQingFileVisitor metaFile) throws AbstractDataSourceException {
        this._dataFile = dataFile;
        try (CsvReader reader = null;){
            List<DataType> fieldDataTypes;
            List<String> fieldDisplayNames;
            List<String> fieldNames;
            boolean fromMeta = true;
            try {
                reader = new CsvReader(new InputStreamReader((InputStream)metaFile.getInputStream(), "utf-8"));
            }
            catch (Exception e) {
                fromMeta = false;
                reader = new CsvReader(new InputStreamReader((InputStream)dataFile.getInputStream(), "utf-8"));
            }
            if (fromMeta) {
                reader.readHeaders();
                fieldNames = Arrays.asList(reader.getHeaders());
                reader.readRecord();
                fieldDisplayNames = Arrays.asList(reader.getValues());
                reader.readRecord();
                fieldDataTypes = this.parseDataType(Arrays.asList(reader.getValues()));
            } else {
                reader.readHeaders();
                fieldDisplayNames = fieldNames = Arrays.asList(reader.getHeaders());
                reader.readRecord();
                fieldDataTypes = this.parserFirstData2DataType(Arrays.asList(reader.getValues()));
            }
            this._metaInfo = new MetaInfo();
            for (int columnIndex = 0; columnIndex < fieldNames.size(); ++columnIndex) {
                this._metaInfo.addField(fieldNames.get(columnIndex), fieldDisplayNames.get(columnIndex), fieldDataTypes.get(columnIndex));
            }
        }
        HashSet<DSFieldKey> testFields = new HashSet<DSFieldKey>();
        testFields.add(new DSFieldKey(this._metaInfo.getFieldName(0)));
        IDataIterator iterator = null;
        try {
            iterator = this.iterator();
            this._rowCount = 0L;
            iterator.init(testFields, null, null);
            while (iterator.hasNextRow()) {
                ++this._rowCount;
            }
        }
        catch (UnAnalysableException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            CloseUtil.close((Closeable[])new Closeable[]{iterator});
        }
        catch (InterruptedException e2) {
            LogUtil.error((String)e2.getMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{iterator});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{iterator});
        }
        CloseUtil.close((Closeable[])new Closeable[]{iterator});
    }

    @Override
    public boolean hasData() {
        return this._rowCount != 0L;
    }

    public final IDataIterator iterator() throws DataSourceNoDataException {
        if (!this.hasData()) {
            throw new DataSourceNoDataException("no data in datasource");
        }
        return new CsvDataIterator(this.getMetaInfo(), this._dataFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar[] getDateScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        if (!this.hasData()) {
            return null;
        }
        String fieldName = field.getPropertyName();
        int fieldNameIndex = this._metaInfo.getFieldNameIndex(fieldName);
        DataType dataType = this._metaInfo.getFieldDataType(fieldNameIndex);
        if (dataType == null || DataType.DATE != dataType || DataType.DATETIME == dataType) {
            return null;
        }
        Calendar minValue = null;
        Calendar maxValue = null;
        IDataIterator iterator = this.iterator();
        HashSet<DSFieldKey> keys = new HashSet<DSFieldKey>();
        keys.add(field);
        try {
            iterator.init(keys, null, null);
            while (iterator.hasNextRow()) {
                ServerRequestInvokeContext.staticCheckInterrupt();
                Map row = iterator.nextRow();
                Object value = row.get(field.toFullName());
                if (value == null) continue;
                if (minValue == null) {
                    minValue = (Calendar)value;
                } else if (((Calendar)value).compareTo(minValue) < 0) {
                    minValue = (Calendar)value;
                }
                if (maxValue == null) {
                    maxValue = (Calendar)value;
                    continue;
                }
                if (((Calendar)value).compareTo(maxValue) <= 0) continue;
                maxValue = (Calendar)value;
            }
        }
        catch (UnAnalysableException e) {
            try {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{iterator});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{iterator});
        }
        CloseUtil.close((Closeable[])new Closeable[]{iterator});
        if (minValue == null && maxValue == null) {
            return null;
        }
        return new Calendar[]{minValue, maxValue};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal[] getNumberScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        if (!this.hasData()) {
            return null;
        }
        String fieldName = field.getPropertyName();
        int fieldNameIndex = this._metaInfo.getFieldNameIndex(fieldName);
        DataType dataType = this._metaInfo.getFieldDataType(fieldNameIndex);
        if (dataType == null || DataType.INT != dataType && DataType.NUMBER != dataType) {
            return null;
        }
        BigDecimal minValue = null;
        BigDecimal maxValue = null;
        IDataIterator iterator = this.iterator();
        try {
            HashSet<DSFieldKey> keys = new HashSet<DSFieldKey>();
            keys.add(field);
            iterator.init(keys, null, null);
            while (iterator.hasNextRow()) {
                ServerRequestInvokeContext.staticCheckInterrupt();
                Map row = iterator.nextRow();
                Object value = row.get(field.toFullName());
                if (value == null) continue;
                BigDecimal comparingValue = null;
                comparingValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(String.valueOf(value));
                minValue = minValue == null ? comparingValue : minValue.min(comparingValue);
                if (maxValue == null) {
                    maxValue = comparingValue;
                    continue;
                }
                maxValue = maxValue.max(comparingValue);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{iterator});
        if (minValue == null && maxValue == null) {
            return null;
        }
        return new BigDecimal[]{minValue, maxValue};
    }

    private List<DataType> parseDataType(List<String> values) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            String dataType = values.get(i);
            dataTypes.add(DataType.valueOf((String)dataType));
        }
        return dataTypes;
    }

    private List<DataType> parserFirstData2DataType(List<String> values) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            if (Pattern.matches("^\\d{4}(/|-)\\d{1,2}(/|-)\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}", value) || Pattern.matches("^\\d{4}(/|-)\\d{1,2}(/|-)\\d{1,2}", value)) {
                dataTypes.add(DataType.DATE);
                continue;
            }
            if (Pattern.matches("^-?\\d+(\\.\\d+)?$", value)) {
                dataTypes.add(DataType.NUMBER);
                continue;
            }
            dataTypes.add(DataType.STRING);
        }
        return dataTypes;
    }

    public void setEliminations(List<DSElimination> eliminations) {
        this._eliminations = eliminations;
    }

    @Override
    public MetaInfo getMetaInfo() {
        return this._metaInfo;
    }

    public DSMeta getMeta() {
        if (this._dSMeta == null) {
            this._dSMeta = new DSMeta();
            ArrayList<DSMetaProperty> properties = new ArrayList<DSMetaProperty>(this._metaInfo.getSize());
            int c = this._metaInfo.getSize();
            for (int i = 0; i < c; ++i) {
                String name = this._metaInfo.getFieldName(i);
                String displayName = this._metaInfo.getFieldDisplayName(i);
                DataType dataType = this._metaInfo.getFieldDataType(i);
                Boolean fieldIsHide = this._metaInfo.getFieldIsHides(i);
                properties.add(new DSMetaProperty(name, displayName, dataType, null, fieldIsHide));
            }
            DSMetaEntity dsme = DSMetaEntity.createInstanceForSingleMode(properties);
            ArrayList<DSMetaEntity> dsmes = new ArrayList<DSMetaEntity>();
            dsmes.add(dsme);
            this._dSMeta.setEntities(dsmes);
            this._dSMeta.setEliminations(this._eliminations);
        }
        return this._dSMeta;
    }
}

