/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dbmanage.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.model.DBConnectionPO;
import com.kingdee.bos.qing.dbmanage.model.DBRefInfo;
import com.kingdee.bos.qing.dbmanage.model.RefFromType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class DBConnectionDao {
    private IDBExcuter dbExcuter;

    public DBConnectionDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveDBConnection(DBConnectionPO dbConnection) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_DBINFO (FID, FNAME, FCREATORID, FCONTENT, FDBSOURCETYPE, FCREATETIME, FMODIFIERID, FMODIFYTIME, FHASHCODE, FSHARED) VALUES (?,?,?,?,?,?,?,?,?,?)";
        Object[] params = new Object[10];
        String fId = dbConnection.getId();
        if (fId == null) {
            fId = UUID.randomUUID().toString();
        }
        byte[] dbSourceBytes = dbConnection.getContent();
        int i = 0;
        params[i++] = fId;
        params[i++] = dbConnection.getName();
        params[i++] = dbConnection.getCreatorId();
        params[i++] = this.dbExcuter.createSqlParameterBytes(dbSourceBytes, 0, dbSourceBytes.length);
        params[i++] = dbConnection.getDbSourceType();
        params[i++] = dbConnection.getCreateTime() == null ? new Date() : dbConnection.getCreateTime();
        params[i++] = dbConnection.getModifierId();
        params[i++] = dbConnection.getModifyTime() == null ? new Date() : dbConnection.getModifyTime();
        params[i++] = dbConnection.getDBHashCode();
        params[i++] = Character.valueOf(dbConnection.isShared() ? (char)'1' : '0');
        this.dbExcuter.execute(sql, params);
        return fId;
    }

    public List<DBConnectionPO> loadDBConnWithoutDBCenter() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FCONTENT, FDBSOURCETYPE, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FSHARED FROM T_QING_DBINFO WHERE FDBSOURCETYPE <> 1 ORDER BY FCREATETIME desc";
        return (List)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<List<DBConnectionPO>>(){

            public List<DBConnectionPO> handle(ResultSet rs) throws SQLException {
                ArrayList<DBConnectionPO> dbConnections = new ArrayList<DBConnectionPO>(10);
                while (rs.next()) {
                    DBConnectionPO dbConnection = new DBConnectionPO();
                    dbConnection.setId(rs.getString("FID"));
                    dbConnection.setName(rs.getString("FNAME"));
                    dbConnection.setContent(rs.getBytes("FCONTENT"));
                    dbConnection.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                    dbConnection.setCreatorId(rs.getString("FCREATORID"));
                    dbConnection.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbConnection.setModifierId(rs.getString("FMODIFIERID"));
                    dbConnection.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    boolean bShared = rs.getString("FSHARED").equals("1");
                    dbConnection.setShared(bShared);
                    dbConnections.add(dbConnection);
                }
                return dbConnections;
            }
        });
    }

    public List<DBConnectionPO> loadAllConnIdsWithoutDBCenter() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FDBSOURCETYPE FROM T_QING_DBINFO WHERE FDBSOURCETYPE <> 1";
        return (List)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<List<DBConnectionPO>>(){

            public List<DBConnectionPO> handle(ResultSet rs) throws SQLException {
                ArrayList<DBConnectionPO> dbConnectionPOS = new ArrayList<DBConnectionPO>(16);
                while (rs.next()) {
                    DBConnectionPO dbConnection = new DBConnectionPO();
                    dbConnection.setId(rs.getString("FID"));
                    dbConnection.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                    dbConnectionPOS.add(dbConnection);
                }
                return dbConnectionPOS;
            }
        });
    }

    public List<DBConnectionPO> loadPermDBConnections(String userId, Set<String> roleId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FCONTENT, FDBSOURCETYPE, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME FROM T_QING_DBINFO ORDER BY FCREATETIME desc";
        return (List)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<List<DBConnectionPO>>(){

            public List<DBConnectionPO> handle(ResultSet rs) throws SQLException {
                ArrayList<DBConnectionPO> dbConnections = new ArrayList<DBConnectionPO>(10);
                while (rs.next()) {
                    DBConnectionPO dbConnection = new DBConnectionPO();
                    dbConnection.setId(rs.getString("FID"));
                    dbConnection.setName(rs.getString("FNAME"));
                    dbConnection.setContent(rs.getBytes("FCONTENT"));
                    dbConnection.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                    dbConnection.setCreatorId(rs.getString("FCREATORID"));
                    dbConnection.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbConnection.setModifierId(rs.getString("FMODIFIERID"));
                    dbConnection.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    dbConnections.add(dbConnection);
                }
                return dbConnections;
            }
        });
    }

    public List<DBConnectionPO> loadSharedDBConnections() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FCONTENT, FDBSOURCETYPE, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FSHARED  FROM T_QING_DBINFO where fshared <> '0' ORDER BY FCREATETIME desc";
        return (List)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<List<DBConnectionPO>>(){
            List<DBConnectionPO> dbConnections = new ArrayList<DBConnectionPO>(10);

            public List<DBConnectionPO> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    DBConnectionPO dbConnection = new DBConnectionPO();
                    dbConnection.setId(rs.getString("FID"));
                    dbConnection.setName(rs.getString("FNAME"));
                    dbConnection.setContent(rs.getBytes("FCONTENT"));
                    dbConnection.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                    dbConnection.setCreatorId(rs.getString("FCREATORID"));
                    dbConnection.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbConnection.setModifierId(rs.getString("FMODIFIERID"));
                    dbConnection.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    boolean bShared = rs.getString("FSHARED").equals("1");
                    dbConnection.setShared(bShared);
                    this.dbConnections.add(dbConnection);
                }
                return this.dbConnections;
            }
        });
    }

    public DBConnectionPO loadDBConnection(String dbInfoId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FCONTENT, FDBSOURCETYPE, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FHASHCODE FROM T_QING_DBINFO WHERE FID=?";
        return (DBConnectionPO)this.dbExcuter.query(sql, new Object[]{dbInfoId}, (ResultHandler)new ResultHandler<DBConnectionPO>(){

            public DBConnectionPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    DBConnectionPO dbConnection = new DBConnectionPO();
                    dbConnection.setId(rs.getString("FID"));
                    dbConnection.setName(rs.getString("FNAME"));
                    dbConnection.setContent(rs.getBytes("FCONTENT"));
                    dbConnection.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                    dbConnection.setCreatorId(rs.getString("FCREATORID"));
                    dbConnection.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbConnection.setModifierId(rs.getString("FMODIFIERID"));
                    dbConnection.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    dbConnection.setDBHashCode(rs.getString("FHASHCODE"));
                    return dbConnection;
                }
                return null;
            }
        });
    }

    public Boolean isDBConnPublic(String dbInfoId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FCONTENT, FDBSOURCETYPE, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FHASHCODE, FSHARED FROM T_QING_DBINFO WHERE FID=? and FSHARED = '1'";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{dbInfoId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    public DBConnectionPO loadDBConnectionByName(String name) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FCONTENT, FDBSOURCETYPE, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME FROM T_QING_DBINFO WHERE FNAME=?";
        return (DBConnectionPO)this.dbExcuter.query(sql, new Object[]{name}, (ResultHandler)new ResultHandler<DBConnectionPO>(){

            public DBConnectionPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    DBConnectionPO dbConnection = new DBConnectionPO();
                    dbConnection.setId(rs.getString("FID"));
                    dbConnection.setName(rs.getString("FNAME"));
                    dbConnection.setCreatorId(rs.getString("FCREATORID"));
                    dbConnection.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbConnection.setModifierId(rs.getString("FMODIFIERID"));
                    dbConnection.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    dbConnection.setContent(rs.getBytes("FCONTENT"));
                    dbConnection.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                    return dbConnection;
                }
                return null;
            }
        });
    }

    public DBConnectionPO loadDBConnectionByHashCode(String hashCode, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FCONTENT, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FDBSOURCETYPE FROM T_QING_DBINFO WHERE FHASHCODE=?";
        return (DBConnectionPO)this.dbExcuter.query(sql, new Object[]{hashCode}, (ResultHandler)new ResultHandler<DBConnectionPO>(){

            public DBConnectionPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    DBConnectionPO dbConnection = new DBConnectionPO();
                    dbConnection.setId(rs.getString("FID"));
                    dbConnection.setName(rs.getString("FNAME"));
                    dbConnection.setCreatorId(rs.getString("FCREATORID"));
                    dbConnection.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbConnection.setModifierId(rs.getString("FMODIFIERID"));
                    dbConnection.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    dbConnection.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                    dbConnection.setContent(rs.getBytes("FCONTENT"));
                    return dbConnection;
                }
                return null;
            }
        });
    }

    public void deleteDBConnection(String dbInfoId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_DBINFO WHERE FID=?";
        this.dbExcuter.execute(sql, new Object[]{dbInfoId});
    }

    public void deleteDBConnections(List<String> dbInfoIds) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(dbInfoIds.size());
        for (String fId : dbInfoIds) {
            paramList.add(new Object[]{fId});
        }
        this.dbExcuter.executeBatch("DELETE FROM T_QING_DBINFO WHERE FID=?", paramList);
    }

    public void updateDBConnection(DBConnectionPO dbConnection) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_DBINFO SET FNAME=?, FMODIFIERID=?, FCONTENT=?, FMODIFYTIME=?, FHASHCODE=? WHERE FID=?";
        Object[] params = new Object[6];
        byte[] content = dbConnection.getContent();
        int i = 0;
        params[i++] = dbConnection.getName();
        params[i++] = dbConnection.getModifierId();
        params[i++] = this.dbExcuter.createSqlParameterBytes(content, 0, content.length);
        params[i++] = dbConnection.getModifyTime() == null ? new Date() : dbConnection.getModifyTime();
        params[i++] = dbConnection.getDBHashCode();
        params[i++] = dbConnection.getId();
        this.dbExcuter.execute(sql, params);
    }

    public String saveDBInfoRef(String fromId, String toId, String hashCode, String userId, RefFromType refSourceType) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_DBINFO_REF (FID, FFROMID, FTOID, FHASHCODE, FFROMTYPE, FCREATORID, FCREATETIME) VALUES (?,?,?,?,?,?,?)";
        String fid = UUID.randomUUID().toString();
        Object[] params = new Object[7];
        int i = 0;
        params[i++] = fid;
        params[i++] = fromId;
        params[i++] = toId;
        params[i++] = hashCode;
        params[i++] = refSourceType.toPersistent();
        params[i++] = userId;
        params[i++] = new Date();
        this.dbExcuter.execute(sql, params);
        return fid;
    }

    public void updateDBInfoRef(DBRefInfo dbRefInfo) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_DBINFO_REF SET FFROMID=?, FTOID=?, FHASHCODE=?, FFROMTYPE=?, FCREATORID=?, FCREATETIME=?";
        Object[] params = new Object[6];
        int i = 0;
        params[i++] = dbRefInfo.getFromId();
        params[i++] = dbRefInfo.getToId();
        params[i++] = dbRefInfo.getDBHashcode();
        params[i++] = dbRefInfo.getFromType().toPersistent();
        params[i++] = dbRefInfo.getCreatorId();
        params[i] = new Date();
        this.dbExcuter.execute(sql, params);
    }

    public List<DBRefInfo> loadDBRefInfo(String refToId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FFROMID, FTOID, FHASHCODE, FFROMTYPE, FCREATORID, FCREATETIME FROM T_QING_DBINFO_REF WHERE FTOID=?";
        return (List)this.dbExcuter.query(sql, new Object[]{refToId}, (ResultHandler)new ResultHandler<List<DBRefInfo>>(){

            public List<DBRefInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<DBRefInfo> dbRefs = new ArrayList<DBRefInfo>(10);
                while (rs.next()) {
                    DBRefInfo dbRef = new DBRefInfo();
                    dbRef.setId(rs.getString("FID"));
                    dbRef.setCreatorId(rs.getString("FCREATORID"));
                    dbRef.setFromId(rs.getString("FFROMID"));
                    dbRef.setToId(rs.getString("FTOID"));
                    dbRef.setFromType(RefFromType.fromPersistent(rs.getInt("FFROMTYPE")));
                    dbRef.setDBHashcode(rs.getString("FHASHCODE"));
                    dbRef.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbRefs.add(dbRef);
                }
                return dbRefs;
            }
        });
    }

    public List<DBRefInfo> loadDBRefInfoByHashCode(String hashCode) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FFROMID, FTOID, FHASHCODE, FFROMTYPE, FCREATORID, FCREATETIME FROM T_QING_DBINFO_REF WHERE FHASHCODE=?";
        return (List)this.dbExcuter.query(sql, new Object[]{hashCode}, (ResultHandler)new ResultHandler<List<DBRefInfo>>(){

            public List<DBRefInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<DBRefInfo> dbRefs = new ArrayList<DBRefInfo>(10);
                while (rs.next()) {
                    DBRefInfo dbRef = new DBRefInfo();
                    dbRef.setId(rs.getString("FID"));
                    dbRef.setCreatorId(rs.getString("FCREATORID"));
                    dbRef.setFromId(rs.getString("FFROMID"));
                    dbRef.setToId(rs.getString("FTOID"));
                    dbRef.setFromType(RefFromType.fromPersistent(rs.getInt("FFROMTYPE")));
                    dbRef.setDBHashcode(rs.getString("FHASHCODE"));
                    dbRef.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbRefs.add(dbRef);
                }
                return dbRefs;
            }
        });
    }

    public List<DBRefInfo> loadDBRefInfoByFromId(String fromId, RefFromType refFromType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FFROMID, FTOID, FHASHCODE, FFROMTYPE, FCREATORID, FCREATETIME FROM T_QING_DBINFO_REF WHERE FFROMID=? AND FFROMTYPE=?";
        return (List)this.dbExcuter.query(sql, new Object[]{fromId, refFromType.toPersistent()}, (ResultHandler)new ResultHandler<List<DBRefInfo>>(){

            public List<DBRefInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<DBRefInfo> dbRefs = new ArrayList<DBRefInfo>(10);
                while (rs.next()) {
                    DBRefInfo dbRef = new DBRefInfo();
                    dbRef.setId(rs.getString("FID"));
                    dbRef.setCreatorId(rs.getString("FCREATORID"));
                    dbRef.setFromId(rs.getString("FFROMID"));
                    dbRef.setToId(rs.getString("FTOID"));
                    dbRef.setFromType(RefFromType.fromPersistent(rs.getInt("FFROMTYPE")));
                    dbRef.setDBHashcode(rs.getString("FHASHCODE"));
                    dbRef.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    dbRefs.add(dbRef);
                }
                return dbRefs;
            }
        });
    }

    public void deleteDBRefInfo(String refFromId, RefFromType refFromType) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_DBINFO_REF WHERE FFROMID=? AND FFROMTYPE=?", new Object[]{refFromId, refFromType.toPersistent()});
    }

    public void updateRefToIdByHashCode(String toId, String hashCode) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("UPDATE T_QING_DBINFO_REF SET FTOID=? WHERE FHASHCODE=?", new Object[]{toId, hashCode});
    }

    public void updateRefHashCodeByToId(String toId, String hashCode) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("UPDATE T_QING_DBINFO_REF SET FHASHCODE=? WHERE FTOID=?", new Object[]{hashCode, toId});
    }
}

