/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dbmanage.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.model.DBPermissionInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBPermissionDao {
    private IDBExcuter dbExecutor;

    public DBPermissionDao(IDBExcuter dbExecutor) {
        this.dbExecutor = dbExecutor;
    }

    public void deleteDBPermission(String infoId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{infoId};
        String sqlDelPermission = "DELETE FROM T_QING_PERM_DBINFO WHERE FDBINFOID in (?)";
        this.dbExecutor.execute(sqlDelPermission, params);
    }

    public void insertDBPermissionInfo(List<DBPermissionInfo> permInfos) throws AbstractQingIntegratedException, SQLException {
        String sqlInsert = "INSERT INTO T_QING_PERM_DBINFO (FID,FDBINFOID,FVIEWERID,FTYPE,FCREATORID,FCREATETIME) VALUES(?,?,?,?,?,?)";
        Object[] params = null;
        DBPermissionInfo permInfo = null;
        Iterator<DBPermissionInfo> iter = permInfos.iterator();
        ArrayList<Object[]> listParam = new ArrayList<Object[]>(10);
        while (iter.hasNext()) {
            permInfo = iter.next();
            String perInfoId = permInfo.getId();
            if (perInfoId == null || "".equals(perInfoId.trim())) continue;
            params = new Object[]{permInfo.getId(), permInfo.getDbinfoId(), permInfo.getViewerId(), permInfo.getType(), permInfo.getCreatorId(), permInfo.getCreateTime()};
            listParam.add(params);
        }
        this.dbExecutor.executeBatch(sqlInsert, listParam);
    }

    public List<DBPermissionInfo> loadDBPermissionInfo(final String dbinfoId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FDBINFOID,FVIEWERID,FTYPE,FCREATORID,FCREATETIME FROM T_QING_PERM_DBINFO WHERE FDBINFOID = ?";
        Object[] params = new Object[]{dbinfoId};
        return (List)this.dbExecutor.query(sql, params, (ResultHandler)new ResultHandler<List<DBPermissionInfo>>(){

            public List<DBPermissionInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<DBPermissionInfo> result = new ArrayList<DBPermissionInfo>(10);
                while (rs.next()) {
                    DBPermissionInfo permissionInfo = new DBPermissionInfo();
                    permissionInfo.setDbinfoId(dbinfoId);
                    permissionInfo.setId(rs.getString("FID"));
                    permissionInfo.setType(rs.getInt("FTYPE"));
                    permissionInfo.setViewerId(rs.getString("FVIEWERID"));
                    permissionInfo.setCreatorId(rs.getString("FCREATORID"));
                    permissionInfo.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    result.add(permissionInfo);
                }
                return result;
            }
        });
    }

    public Map<String, List<DBPermissionInfo>> loadDBPermissionInfo(List<String> ids) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlInQuestionBuilder;
        String sqlInQuestion = "null";
        if (ids != null && ids.size() > 0) {
            sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < ids.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
        } else {
            return new HashMap<String, List<DBPermissionInfo>>(16);
        }
        sqlInQuestion = sqlInQuestionBuilder.toString();
        String sql = "SELECT FID,FDBINFOID,FVIEWERID,FTYPE,FCREATORID,FCREATETIME FROM T_QING_PERM_DBINFO WHERE FDBINFOID IN (" + sqlInQuestion + ")";
        return (Map)this.dbExecutor.query(sql, ids.toArray(), (ResultHandler)new ResultHandler<Map<String, List<DBPermissionInfo>>>(){

            public Map<String, List<DBPermissionInfo>> handle(ResultSet rs) throws SQLException {
                HashMap<String, List<DBPermissionInfo>> map = new HashMap<String, List<DBPermissionInfo>>(10);
                while (rs.next()) {
                    DBPermissionInfo permissionInfo = new DBPermissionInfo();
                    permissionInfo.setId(rs.getString("FID"));
                    String fdbinfoId = rs.getString("FDBINFOID");
                    permissionInfo.setDbinfoId(fdbinfoId);
                    permissionInfo.setType(rs.getInt("FTYPE"));
                    permissionInfo.setViewerId(rs.getString("FVIEWERID"));
                    permissionInfo.setCreatorId(rs.getString("FCREATORID"));
                    permissionInfo.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    ArrayList<DBPermissionInfo> list = (ArrayList<DBPermissionInfo>)map.get(fdbinfoId);
                    if (list == null) {
                        list = new ArrayList<DBPermissionInfo>();
                    }
                    list.add(permissionInfo);
                    map.put(fdbinfoId, list);
                }
                return map;
            }
        });
    }

    public void saveOrUpdateDBPermissionInfo(String dbInfoId, List<DBPermissionInfo> permInfos) throws AbstractQingIntegratedException, SQLException {
        String sqlDelete = "DELETE FROM T_QING_PERM_DBINFO WHERE FDBINFOID=?";
        this.dbExecutor.execute(sqlDelete, new Object[]{dbInfoId});
        if (permInfos != null && !permInfos.isEmpty()) {
            this.insertDBPermissionInfo(permInfos);
        }
    }

    public void saveOrUpdateDBPermissionInfo(String dbInfoId, char authToAll) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_DBINFO SET FSHARED = ? WHERE FID = ?";
        Object[] params = new Object[]{Character.valueOf(authToAll), dbInfoId};
        this.dbExecutor.execute(sql, params);
        String sqlDelete = "DELETE FROM T_QING_PERM_DBINFO WHERE FDBINFOID=?";
        this.dbExecutor.execute(sqlDelete, new Object[]{dbInfoId});
    }
}

