/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dbmanage.model;

import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.dbmanage.model.DBConnectionPO;
import com.kingdee.bos.qing.dbmanage.model.ValueTextPair;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.List;
import org.jdom2.Element;

public class DBConnection {
    private String id;
    private String name;
    private AbstractSource dbSource;
    private int refTime;
    private SourceType dbSourceType;
    private String creatorId;
    private String creatorName;
    private String modifierId;
    private String modifierName;
    private long createTime;
    private long modifyTime;
    protected List<ValueTextPair> users;
    protected List<ValueTextPair> roles;
    private boolean shared = true;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractSource getDbSource() {
        return this.dbSource;
    }

    public void setDbSource(AbstractSource dbSource) {
        this.dbSource = dbSource;
    }

    public int getRefTime() {
        return this.refTime;
    }

    public void setRefTime(int refTime) {
        this.refTime = refTime;
    }

    public boolean isDBSource() {
        return this.dbSourceType == SourceType.DB;
    }

    public boolean isDBCenterSource() {
        return this.dbSourceType == SourceType.BizMeta;
    }

    public List<ValueTextPair> getUsers() {
        return this.users;
    }

    public void setUsers(List<ValueTextPair> users) {
        this.users = users;
    }

    public List<ValueTextPair> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ValueTextPair> roles) {
        this.roles = roles;
    }

    public SourceType getDbSourceType() {
        return this.dbSourceType;
    }

    public void setDbSourceType(SourceType dbSourceType) {
        this.dbSourceType = dbSourceType;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getModifierName() {
        return this.modifierName;
    }

    public void setModifierName(String modifierName) {
        this.modifierName = modifierName;
    }

    public String getDBHashCode() {
        return this.dbSource.getSourceHashCode();
    }

    public DBConnectionPO toPO() {
        int type;
        DBConnectionPO dbPO = new DBConnectionPO();
        dbPO.setId(this.id);
        dbPO.setName(this.name);
        dbPO.setCreatorId(this.creatorId);
        dbPO.setModifierId(this.modifierId);
        dbPO.setShared(this.shared);
        if (this.dbSource != null) {
            byte[] dbSourceBytes = XmlUtil.toByteArray((Element)this.dbSource.toXml());
            dbPO.setContent(dbSourceBytes);
            dbPO.setDBHashCode(this.dbSource.getSourceHashCode());
        }
        switch (this.dbSourceType) {
            case DB: {
                type = 0;
                break;
            }
            case BizMeta: {
                type = 1;
                break;
            }
            case OPENAPI: {
                type = 2;
                break;
            }
            default: {
                type = 0;
            }
        }
        dbPO.setDbSourceType(type);
        return dbPO;
    }
}

