/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.model.DBConnectionPO;
import com.kingdee.bos.qing.macro.model.MacroType;
import com.kingdee.bos.qing.macro.model.po.MacroPO;
import com.kingdee.bos.qing.macro.model.po.MacroReference;
import com.kingdee.bos.qing.macro.model.po.SQLMacroPO;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MacroManageDao {
    private IDBExcuter dbExcuter;

    public MacroManageDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveMacro(String userId, Macro macro) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_MACRO (FID, FUID, FNAME, FDESC, FTYPE, FMULTIVALUED, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME) VALUES (?,?,?,?,?,?,?,?,?,?)";
        Object[] params = new Object[10];
        int i = 0;
        String fId = UUID.randomUUID().toString();
        params[i++] = fId;
        params[i++] = macro.getUid();
        params[i++] = macro.getName();
        params[i++] = macro.getDesc() == null ? "" : macro.getDesc();
        params[i++] = macro.getType().toPersistent();
        params[i++] = macro.isMultiValued() ? "1" : "0";
        params[i++] = userId;
        params[i++] = new Date();
        params[i++] = userId;
        params[i++] = new Date();
        this.dbExcuter.execute(sql, params);
        return fId;
    }

    public void updateMacro(Macro macro, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_MACRO SET FNAME=?, FDESC=?, FTYPE=?, FMULTIVALUED=?, FMODIFIERID=?, FMODIFYTIME=? WHERE FID=?";
        Object[] params = new Object[7];
        int i = 0;
        params[i++] = macro.getName();
        params[i++] = macro.getDesc();
        params[i++] = macro.getType().toPersistent();
        params[i++] = macro.isMultiValued() ? "1" : "0";
        params[i++] = userId;
        params[i++] = new Date();
        params[i++] = macro.getFid();
        this.dbExcuter.execute(sql, params);
    }

    public void deleteMacro(String fId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_MACRO WHERE FID=?", new Object[]{fId});
    }

    public void deleteMacro(List<String> fIds) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(fIds.size());
        for (String fId : fIds) {
            paramList.add(new Object[]{fId});
        }
        this.dbExcuter.executeBatch("DELETE FROM T_QING_MACRO WHERE FID=?", paramList);
    }

    public void deleteMacroByUid(String uid) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_MACRO WHERE FUID=?", new Object[]{uid});
    }

    public Macro loadMacro(String fId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FUID, FNAME, FDESC, FTYPE, FMULTIVALUED, FCREATORID FROM T_QING_MACRO WHERE FID=? ORDER BY FCREATETIME";
        return (Macro)this.dbExcuter.query(sql, new Object[]{fId}, (ResultHandler)new ResultHandler<Macro>(){

            public Macro handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    Macro macro = new Macro();
                    macro.setFid(rs.getString("FID"));
                    macro.setUid(rs.getString("FUID"));
                    macro.setName(rs.getString("FNAME"));
                    macro.setDesc(rs.getString("FDESC"));
                    macro.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macro.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macro.setCreatorId(rs.getString("FCREATORID"));
                    return macro;
                }
                return null;
            }
        });
    }

    public Macro loadMacroByUid(String uid) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FUID, FNAME, FDESC, FTYPE, FMULTIVALUED, FCREATORID FROM T_QING_MACRO WHERE FUID=? ORDER BY FCREATETIME";
        return (Macro)this.dbExcuter.query(sql, new Object[]{uid}, (ResultHandler)new ResultHandler<Macro>(){

            public Macro handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    Macro macro = new Macro();
                    macro.setFid(rs.getString("FID"));
                    macro.setUid(rs.getString("FUID"));
                    macro.setName(rs.getString("FNAME"));
                    macro.setDesc(rs.getString("FDESC"));
                    macro.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macro.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macro.setCreatorId(rs.getString("FCREATORID"));
                    return macro;
                }
                return null;
            }
        });
    }

    public Macro loadMacroByName(String name) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FUID, FNAME, FDESC, FTYPE, FMULTIVALUED, FCREATORID FROM T_QING_MACRO WHERE FNAME=?";
        return (Macro)this.dbExcuter.query(sql, new Object[]{name}, (ResultHandler)new ResultHandler<Macro>(){

            public Macro handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    Macro macro = new Macro();
                    macro.setFid(rs.getString("FID"));
                    macro.setUid(rs.getString("FUID"));
                    macro.setName(rs.getString("FNAME"));
                    macro.setDesc(rs.getString("FDESC"));
                    macro.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macro.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macro.setCreatorId(rs.getString("FCREATORID"));
                    return macro;
                }
                return null;
            }
        });
    }

    public List<MacroPO> loadMacrosByMultiName(Set<String> names) throws AbstractQingIntegratedException, SQLException {
        if (names == null || names.size() == 0) {
            return new ArrayList<MacroPO>();
        }
        String sqlPrefix = "SELECT FID, FUID, FNAME, FDESC, FTYPE, FMULTIVALUED, FCREATORID FROM T_QING_MACRO WHERE FNAME IN";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(sqlPrefix);
        sqlBuilder.append(" (");
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            sqlBuilder.append(i == size - 1 ? "?)" : "?,");
        }
        String sql = sqlBuilder.toString();
        Object[] params = new Object[size];
        int i = 0;
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            params[i++] = iterator.next();
        }
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<MacroPO>>(){

            public List<MacroPO> handle(ResultSet rs) throws SQLException {
                ArrayList<MacroPO> macroInfos = new ArrayList<MacroPO>(10);
                while (rs.next()) {
                    MacroPO macroInfo = new MacroPO();
                    macroInfo.setFid(rs.getString("FID"));
                    macroInfo.setUid(rs.getString("FUID"));
                    macroInfo.setName(rs.getString("FNAME"));
                    macroInfo.setDesc(rs.getString("FDESC"));
                    macroInfo.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macroInfo.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macroInfo.setCreatorId(rs.getString("FCREATORID"));
                    macroInfos.add(macroInfo);
                }
                return macroInfos;
            }
        });
    }

    public List<SQLMacroPO> loadMacrosByMultiUid(Set<String> macroUids) throws AbstractQingIntegratedException, SQLException {
        if (macroUids == null || macroUids.size() == 0) {
            return new ArrayList<SQLMacroPO>(1);
        }
        String sqlPrefix = "SELECT M.FID, M.FUID, M.FNAME, M.FDESC, M.FTYPE, M.FMULTIVALUED, M.FCREATORID, M.FCREATETIME, M.FMODIFIERID, M.FMODIFYTIME, D.FID as FDBINFOFID, D.FCONTENT, D.FDBSOURCETYPE, D.FNAME AS FDBNAME FROM ((T_QING_MACRO M LEFT JOIN T_QING_DBINFO_REF DR ON M.FID = DR.FFROMID) LEFT JOIN T_QING_DBINFO D ON DR.FTOID = D.FID) WHERE M.FUID IN";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(sqlPrefix);
        sqlBuilder.append(" (");
        int size = macroUids.size();
        for (int i = 0; i < size; ++i) {
            sqlBuilder.append(i == size - 1 ? "?)" : "?,");
        }
        String sql = sqlBuilder.toString();
        Object[] params = new Object[size];
        int i = 0;
        Iterator<String> iterator = macroUids.iterator();
        while (iterator.hasNext()) {
            params[i++] = iterator.next();
        }
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<SQLMacroPO>>(){

            public List<SQLMacroPO> handle(ResultSet rs) throws SQLException {
                ArrayList<SQLMacroPO> macros = new ArrayList<SQLMacroPO>(10);
                while (rs.next()) {
                    SQLMacroPO macro = new SQLMacroPO();
                    macro.setFid(rs.getString("FID"));
                    macro.setUid(rs.getString("FUID"));
                    macro.setName(rs.getString("FNAME"));
                    macro.setDesc(rs.getString("FDESC"));
                    macro.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macro.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macro.setCreatorId(rs.getString("FCREATORID"));
                    macro.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    macro.setModifierId(rs.getString("FMODIFIERID"));
                    macro.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    String dbInfoFid = rs.getString("FDBINFOFID");
                    if (dbInfoFid != null) {
                        DBConnectionPO dbInfo = new DBConnectionPO();
                        dbInfo.setId(rs.getString("FDBINFOFID"));
                        dbInfo.setName(rs.getString("FDBNAME"));
                        dbInfo.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                        dbInfo.setContent(rs.getBytes("FCONTENT"));
                        macro.setDBInfo(dbInfo);
                    }
                    macros.add(macro);
                }
                return macros;
            }
        });
    }

    public void batchSaveReference(List<MacroReference> macroReferences) throws AbstractQingIntegratedException, SQLException {
        if (macroReferences == null || macroReferences.size() == 0) {
            return;
        }
        String sql = "INSERT INTO T_QING_MACRO_REF (FID, FFROMID, FTOID, FTOPATH, FCREATORID, FREFTIME) VALUES (?,?,?,?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (MacroReference macroReference : macroReferences) {
            Object[] param = new Object[6];
            int i = 0;
            param[i++] = UUID.randomUUID().toString();
            param[i++] = macroReference.getFromId();
            param[i++] = macroReference.getToId();
            param[i++] = macroReference.getToPath();
            param[i++] = macroReference.getCreatorId();
            param[i++] = macroReference.getRefTime();
            params.add(param);
        }
        this.dbExcuter.executeBatch(sql, params);
    }

    public void deleteReferenceByFromId(String refFromId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_MACRO_REF WHERE FFROMID=?";
        this.dbExcuter.execute(sql, new Object[]{refFromId});
    }

    public List<MacroReference> loadMacroReferenceByRefToId(String refToId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FFROMID, FTOID, FCREATORID, FREFTIME FROM T_QING_MACRO_REF WHERE FTOID=?";
        return (List)this.dbExcuter.query(sql, new Object[]{refToId}, (ResultHandler)new ResultHandler<List<MacroReference>>(){

            public List<MacroReference> handle(ResultSet rs) throws SQLException {
                ArrayList<MacroReference> macroRefs = new ArrayList<MacroReference>(10);
                while (rs.next()) {
                    MacroReference reference = new MacroReference();
                    reference.setFromId(rs.getString("FFROMID"));
                    reference.setRefTime(rs.getInt("FREFTIME"));
                    reference.setCreatorId(rs.getString("FCREATORID"));
                    reference.setToId(rs.getString("FTOID"));
                    macroRefs.add(reference);
                }
                return macroRefs;
            }
        });
    }

    public void updateRefToIdByToPath(String refToPath, String refToId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_MACRO_REF SET FTOID=? WHERE FTOPATH=?";
        this.dbExcuter.execute(sql, new Object[]{refToId, refToPath});
    }
}

