/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.SQLMacroDomain;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.model.MacroType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class MacroDomainFactory {
    private static Map<MacroType, Class<? extends AbstractMacroDomain>> map = new HashMap<MacroType, Class<? extends AbstractMacroDomain>>();

    public static AbstractMacroDomain getDomain(MacroType type, IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext) throws QingMacroException {
        Class<? extends AbstractMacroDomain> clazz = map.get((Object)type);
        try {
            Constructor<? extends AbstractMacroDomain> constructor = clazz.getDeclaredConstructor(IDBExcuter.class, ITransactionManagement.class, QingContext.class);
            return constructor.newInstance(dbExcuter, tx, qingContext);
        }
        catch (InstantiationException e) {
            throw new QingMacroException(e);
        }
        catch (IllegalAccessException e) {
            throw new QingMacroException(e);
        }
        catch (NoSuchMethodException e) {
            throw new QingMacroException(e);
        }
        catch (SecurityException e) {
            throw new QingMacroException(e);
        }
        catch (IllegalArgumentException e) {
            throw new QingMacroException(e);
        }
        catch (InvocationTargetException e) {
            throw new QingMacroException(e);
        }
    }

    static {
        map.put(MacroType.SQL, SQLMacroDomain.class);
    }
}

