/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.macro.IMacroVarProvider;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.macro.MacroExecuteException;
import com.kingdee.bos.qing.data.exception.macro.MacroNotFoundException;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.macro.domain.MacroDomainFactory;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.MacroValue;
import com.kingdee.bos.qing.macro.util.MacroFormatHelper;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class SQLMacroVarCompareProvider
implements IMacroVarProvider {
    protected abstract IDBExcuter getDbExcuter();

    @Override
    public boolean isMultiValue(String uidInBox, QingContext qingContext) {
        MacroCommonDomain macroCommonDomain = new MacroCommonDomain(this.getDbExcuter(), qingContext);
        String macroUid = uidInBox;
        try {
            Macro macro = null;
            macro = macroCommonDomain.loadCommonMacroByUid(macroUid);
            if (macro == null) {
                return true;
            }
            return macro.isMultiValued();
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"get qing macro info failed when filter", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"get qing macro info failed when filter", (Throwable)e);
        }
        return false;
    }

    @Override
    public Set<Object> getMacroValue(String uidInBox, QingContext qingContext) throws AbstractMacroException {
        MacroCommonDomain macroCommonDomain = new MacroCommonDomain(this.getDbExcuter(), qingContext);
        boolean sysSharedFormat = MacroFormatHelper.isSysSharedUidFormat(uidInBox);
        String macroUid = uidInBox;
        if (sysSharedFormat) {
            macroUid = MacroFormatHelper.removeSharedUidPrefix(uidInBox);
        }
        Macro macro = null;
        try {
            macro = macroCommonDomain.loadCommonMacroByUid(macroUid);
            if (macro == null) {
                throw new com.kingdee.bos.qing.macro.exception.MacroNotFoundException();
            }
            AbstractMacroDomain macroDomain = MacroDomainFactory.getDomain(macro.getType(), this.getDbExcuter(), null, qingContext);
            MacroValue macroValue = macroDomain.getMacroExecuteResult(macro.getFid());
            if (macroValue != null && macroValue.getColumnValues() != null && macroValue.getColumnValues().get(0) != null) {
                return new HashSet<Object>((Collection)macroValue.getColumnValues().get(0));
            }
            return new HashSet<Object>();
        }
        catch (com.kingdee.bos.qing.macro.exception.MacroNotFoundException e) {
            throw new MacroNotFoundException(macroUid);
        }
        catch (Exception e) {
            throw new MacroExecuteException(e);
        }
    }
}

