/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacroFormatHelper {
    private static final String FORMAT = "'$%s'";
    private static Pattern pattern;
    private static final String SYS_SHARED_UID_PREFIX = "SHARED-";
    private static final String SYS_SHARED_DISPLAYNAME_PREFIX = "SHARED-";

    public static String format(String macroId) {
        return String.format(FORMAT, macroId);
    }

    public static Matcher matcher(String sql) {
        return pattern.matcher(sql);
    }

    public static boolean isSysSharedUidFormat(String text) {
        return text.startsWith("SHARED-");
    }

    public static String removeSharedUidPrefix(String text) {
        if (MacroFormatHelper.isSysSharedUidFormat(text)) {
            text = text.substring("SHARED-".length());
        }
        return text;
    }

    public static String addSharedUidPrefix(String text) {
        return "SHARED-" + text;
    }

    public static boolean isSysSharedDisplayNameFormat(String text) {
        return text.startsWith("SHARED-");
    }

    public static String removeSharedDisplayNamePrefix(String text) {
        if (MacroFormatHelper.isSysSharedDisplayNameFormat(text)) {
            text = text.substring("SHARED-".length());
        }
        return text;
    }

    public static String addSharedDisplayNamePrefix(String text) {
        return "SHARED-" + text;
    }

    static {
        String regex = "(?<=\\'\\$).*?(?=\\')";
        pattern = Pattern.compile(regex);
    }
}

