/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.message.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageReadFlagEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.po.MessagePO;
import com.kingdee.bos.qing.message.model.vo.BaseMessageDeailVO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageDao {
    private static final int MESSAGE_TITLE_LENGTH = 80;
    private IDBExcuter dbExcuter;

    public MessageDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveMessage(MessagePO messagePO) throws AbstractQingIntegratedException, SQLException {
        String fid = this.dbExcuter.genStringId("T_QING_MESSAGE");
        this.writeBlock("INSERT INTO T_QING_MESSAGE(FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE) values (?,?,?,?,?,?,?,?,?,?)", fid, messagePO);
        return fid;
    }

    public void updateToHasReadByReceiverIdAndBizType(String userId, List<String> messageIdList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(MessageReadFlagEnum.READ.getIsRead());
        queryValue.add(new Date());
        queryValue.addAll(messageIdList);
        queryValue.add(userId);
        this.dbExcuter.execute("UPDATE T_QING_MESSAGE_RECEIVER_REL SET FISREAD=?,FREADDATE=? WHERE FMESSAGEID IN (" + this.getListParamStrInSQL(messageIdList) + ") AND FRECEVIERID=? AND FISREAD='0'", queryValue.toArray());
    }

    private String getListParamStrInSQL(List<String> paramList) {
        String sqlInParam = "null";
        if (paramList == null) {
            return sqlInParam;
        }
        StringBuilder sqlInParamBuilder = new StringBuilder();
        sqlInParamBuilder.append("?");
        for (int i = 1; i < paramList.size(); ++i) {
            sqlInParamBuilder.append(",?");
        }
        sqlInParam = sqlInParamBuilder.toString();
        return sqlInParam;
    }

    private void writeBlock(String blockSql, String messageId, MessagePO messagePO) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(messageId);
        params.add(messagePO.getMessageLevel());
        params.add(messagePO.getMessageType());
        params.add(messagePO.getBizType());
        params.add(messagePO.getBizId());
        if (StringUtils.isNotEmpty((CharSequence)messagePO.getMessageTitle())) {
            params.add(messagePO.getMessageTitle().substring(0, Math.min(80, messagePO.getMessageTitle().length())));
        }
        if (messagePO.getMessageContent() != null) {
            params.add(this.dbExcuter.createSqlParameterBytes(messagePO.getMessageContent(), 0, messagePO.getMessageContent().length));
        } else {
            params.add(null);
        }
        params.add(messagePO.getSenderId());
        params.add(messagePO.getSendDate() != null ? messagePO.getSendDate() : new Date());
        params.add(null);
        this.dbExcuter.execute(blockSql, params.toArray());
    }

    public MessagePO getByMessageId(String messageId) throws AbstractQingIntegratedException, SQLException {
        return (MessagePO)this.dbExcuter.query("SELECT FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE FROM T_QING_MESSAGE WHERE FID=?", new Object[]{messageId}, (ResultHandler)new ResultHandler<MessagePO>(){

            public MessagePO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MessagePO messagePO = new MessagePO();
                    messagePO.setMessageId(rs.getString("FID"));
                    messagePO.setMessageLevel(rs.getString("FMESSAGELEVEL"));
                    messagePO.setMessageType(rs.getString("FMESSAGETYPE"));
                    messagePO.setBizType(rs.getString("FBIZTYPE"));
                    messagePO.setBizId(rs.getString("FBIZID"));
                    messagePO.setMessageTitle(rs.getString("FTITLE"));
                    if (rs.getBytes("FMESSAGECONTENT") != null) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        try {
                            os.write(rs.getBytes("FMESSAGECONTENT"));
                            messagePO.setMessageContent(os.toByteArray());
                        }
                        catch (IOException e) {
                            LogUtil.error((String)e.getMessage(), (Throwable)e);
                        }
                    }
                    messagePO.setSenderId(rs.getString("FSENDERID"));
                    messagePO.setSendDate(rs.getTimestamp("FSENDDATE"));
                    return messagePO;
                }
                return null;
            }
        });
    }

    public MessagePO getByBizId(String bizId, BizTypeEnum bizTypeEnum) throws AbstractQingIntegratedException, SQLException {
        return (MessagePO)this.dbExcuter.query("SELECT FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE FROM T_QING_MESSAGE WHERE FBIZID=? AND FBIZTYPE=?", new Object[]{bizId, bizTypeEnum.getBizType()}, (ResultHandler)new ResultHandler<MessagePO>(){

            public MessagePO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MessagePO messagePO = new MessagePO();
                    messagePO.setMessageId(rs.getString("FID"));
                    messagePO.setMessageLevel(rs.getString("FMESSAGELEVEL"));
                    messagePO.setMessageType(rs.getString("FMESSAGETYPE"));
                    messagePO.setBizType(rs.getString("FBIZTYPE"));
                    messagePO.setBizId(rs.getString("FBIZID"));
                    messagePO.setMessageTitle(rs.getString("FTITLE"));
                    if (rs.getBytes("FMESSAGECONTENT") != null) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        try {
                            os.write(rs.getBytes("FMESSAGECONTENT"));
                            messagePO.setMessageContent(os.toByteArray());
                        }
                        catch (IOException e) {
                            LogUtil.error((String)e.getMessage(), (Throwable)e);
                        }
                    }
                    messagePO.setSenderId(rs.getString("FSENDERID"));
                    messagePO.setSendDate(rs.getTimestamp("FSENDDATE"));
                    return messagePO;
                }
                return null;
            }
        });
    }

    public List<MessagePO> queryUnReadSystemMessageList(String userid) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT QM.FID,QM.FMESSAGELEVEL FROM T_QING_MESSAGE QM LEFT JOIN T_QING_MESSAGE_RECEIVER_REL QMR ON QM.FID=QMR.FMESSAGEID AND QMR.FRECEVIERID=? WHERE QM.FMESSAGETYPE IN ('2','3') AND QMR.FID IS NULL ", new Object[]{userid}, (ResultHandler)new ResultHandler<List<MessagePO>>(){

            public List<MessagePO> handle(ResultSet rs) throws SQLException {
                ArrayList<MessagePO> resultList = new ArrayList<MessagePO>(10);
                while (rs.next()) {
                    MessagePO messagePO = new MessagePO();
                    messagePO.setMessageId(rs.getString("FID"));
                    messagePO.setMessageLevel(rs.getString("FMESSAGELEVEL"));
                    resultList.add(messagePO);
                }
                return resultList;
            }
        });
    }

    public List<BaseMessageDeailVO> queryUnReadMessageDetailList(String userId, String messageLevel) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT MESSAGEID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE,MESSAGERECEIVERRELID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM (");
        sql.append("SELECT ");
        sql.append("QM.FID AS MESSAGEID,QM.FMESSAGELEVEL,QM.FMESSAGETYPE,QM.FBIZTYPE,QM.FBIZID,QM.FTITLE,QM.FMESSAGECONTENT,QM.FSENDERID,QM.FSENDDATE,QM.FEFFECTIVEDATE,QMR.FID AS MESSAGERECEIVERRELID,QMR.FMESSAGEID,QMR.FRECEVIERID,QMR.FISREAD,QMR.FREADDATE ");
        sql.append("FROM (SELECT FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE  from T_QING_MESSAGE where FMESSAGETYPE='1')   QM ");
        sql.append("LEFT JOIN (SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FRECEVIERID=? AND FISREAD='0')   QMR ");
        paramList.add(userId);
        sql.append("ON QM.FID=QMR.FMESSAGEID ");
        sql.append("WHERE QMR.FRECEVIERID=? AND QMR.FISREAD='0' ");
        paramList.add(userId);
        sql.append(" UNION ALL ");
        sql.append("SELECT QM.FID AS MESSAGEID,QM.FMESSAGELEVEL,QM.FMESSAGETYPE,QM.FBIZTYPE,QM.FBIZID,QM.FTITLE,QM.FMESSAGECONTENT,QM.FSENDERID,QM.FSENDDATE,QM.FEFFECTIVEDATE,QMR.FID AS MESSAGERECEIVERRELID,QMR.FMESSAGEID,QMR.FRECEVIERID,QMR.FISREAD,QMR.FREADDATE ");
        sql.append("FROM (SELECT FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE  FROM T_QING_MESSAGE WHERE FMESSAGETYPE IN ('2','3') )   QM ");
        sql.append("LEFT JOIN (select FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FRECEVIERID=?)   QMR ");
        paramList.add(userId);
        sql.append("ON QM.FID=QMR.FMESSAGEID ");
        sql.append("WHERE  QMR.FID IS NULL ");
        sql.append(" )   UNREADMESSAGE ");
        if (StringUtils.isNotEmpty((CharSequence)messageLevel)) {
            sql.append("  WHERE FMESSAGELEVEL=? ");
            paramList.add(messageLevel);
        }
        sql.append(" ORDER BY FSENDDATE ASC");
        return (List)this.dbExcuter.query(sql.toString(), paramList.toArray(), (ResultHandler)new ResultHandler<List<BaseMessageDeailVO>>(){

            public List<BaseMessageDeailVO> handle(ResultSet rs) throws SQLException {
                ArrayList<BaseMessageDeailVO> resultList = new ArrayList<BaseMessageDeailVO>(10);
                while (rs.next()) {
                    BaseMessageDeailVO messageDeailVo = MessageDao.this.getBaseMessageDeailVo(rs);
                    messageDeailVo.setEffectiveDate(rs.getTimestamp("FEFFECTIVEDATE"));
                    resultList.add(messageDeailVo);
                }
                return resultList;
            }
        });
    }

    public int queryUnReadMessageCount(String userId, String messageLevel) throws AbstractQingIntegratedException, SQLException {
        Date currentDate = new Date();
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder("SELECT COUNT(1) AS COUNT FROM ");
        sql.append("(SELECT QM.FID,QM.FMESSAGELEVEL,QM.FSENDDATE ");
        sql.append("FROM (SELECT FID,FMESSAGELEVEL,FSENDDATE FROM T_QING_MESSAGE WHERE FMESSAGETYPE='1')   QM ");
        sql.append("LEFT JOIN (SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FRECEVIERID=? AND FISREAD='0')    QMR ON QM.FID=QMR.FMESSAGEID ");
        sql.append("WHERE QMR.FRECEVIERID=? AND QMR.FISREAD='0'");
        sql.append(" UNION ALL ");
        sql.append("SELECT QM.FID,QM.FMESSAGELEVEL,QM.FSENDDATE ");
        sql.append("FROM (SELECT FID,FMESSAGELEVEL,FSENDDATE FROM T_QING_MESSAGE WHERE FMESSAGETYPE IN ('2','3') AND FEFFECTIVEDATE IS NULL)   QM ");
        sql.append("WHERE NOT EXISTS (SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL QMR WHERE  QMR.FRECEVIERID=? AND QM.FID=QMR.FMESSAGEID AND QMR.FISREAD=?) ");
        sql.append(" UNION ALL ");
        sql.append("SELECT QM.FID,QM.FMESSAGELEVEL,QM.FSENDDATE ");
        sql.append("FROM (SELECT FID,FMESSAGELEVEL,FSENDDATE FROM T_QING_MESSAGE WHERE FMESSAGETYPE IN ('2','3') AND FEFFECTIVEDATE > ?)   QM ");
        sql.append("WHERE NOT EXISTS  (SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL QMR WHERE  QMR.FRECEVIERID=? AND QM.FID=QMR.FMESSAGEID AND QMR.FISREAD=?)  ");
        sql.append(" )   UNREADMESSAGE WHERE UNREADMESSAGE.FSENDDATE<=?");
        paramList.add(userId);
        paramList.add(userId);
        paramList.add(userId);
        paramList.add(MessageReadFlagEnum.READ.getIsRead());
        paramList.add(currentDate);
        paramList.add(userId);
        paramList.add(MessageReadFlagEnum.READ.getIsRead());
        paramList.add(currentDate);
        if (StringUtils.isNotEmpty((CharSequence)messageLevel)) {
            sql.append("  WHERE FMESSAGELEVEL=? ");
            paramList.add(messageLevel);
        }
        return (Integer)this.dbExcuter.query(sql.toString(), paramList.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("COUNT");
                }
                return 0;
            }
        });
    }

    private BaseMessageDeailVO getBaseMessageDeailVo(ResultSet rs) throws SQLException {
        BaseMessageDeailVO messageDeailVo = new BaseMessageDeailVO();
        messageDeailVo.setMessageId(rs.getString("MESSAGEID"));
        messageDeailVo.setMessageLevel(rs.getString("FMESSAGELEVEL"));
        messageDeailVo.setMessageType(rs.getString("FMESSAGETYPE"));
        messageDeailVo.setBizType(rs.getString("FBIZTYPE"));
        messageDeailVo.setBizId(rs.getString("FBIZID"));
        messageDeailVo.setMessageTitle(rs.getString("FTITLE"));
        if (rs.getBytes("FMESSAGECONTENT") != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                os.write(rs.getBytes("FMESSAGECONTENT"));
                messageDeailVo.setMessageContentStr(new String(os.toByteArray()));
            }
            catch (IOException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        messageDeailVo.setSenderId(rs.getString("FSENDERID"));
        messageDeailVo.setSendDate(rs.getTimestamp("FSENDDATE"));
        messageDeailVo.setSendDateStr(messageDeailVo.getSendDateRuleStr());
        messageDeailVo.setMessageReceiverRelId(rs.getString("MESSAGERECEIVERRELID"));
        messageDeailVo.setIsRead(rs.getString("FISREAD"));
        messageDeailVo.setReceiverId(rs.getString("FRECEVIERID"));
        messageDeailVo.setReadDate(rs.getTimestamp("FREADDATE"));
        messageDeailVo.setSendDateFormatStr(rs.getTimestamp("FSENDDATE"));
        messageDeailVo.setEffectiveDate(rs.getTimestamp("FEFFECTIVEDATE"));
        return messageDeailVo;
    }

    public Date queryMinSendDate(String userId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT MIN(FSENDDATE) AS FSENDDATE ");
        sql.append("FROM ");
        sql.append("(SELECT MIN(QM.FSENDDATE) AS FSENDDATE ");
        sql.append("FROM (SELECT FID,FMESSAGELEVEL,FSENDDATE FROM T_QING_MESSAGE where FMESSAGETYPE=?)   QM ");
        paramList.add(MessageTypeEnum.BIZ_NEWS.getMessageType());
        sql.append("LEFT JOIN (SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FRECEVIERID=?)   QMR ON QM.FID=QMR.FMESSAGEID ");
        paramList.add(userId);
        sql.append("WHERE QMR.FRECEVIERID=?  ");
        paramList.add(userId);
        sql.append(" UNION ALL ");
        sql.append("SELECT MIN(QM.FSENDDATE) AS FSENDDATE ");
        sql.append("FROM T_QING_MESSAGE QM  WHERE QM.FMESSAGETYPE IN (?,?)");
        paramList.add(MessageTypeEnum.PUBLISH_NEWS.getMessageType());
        paramList.add(MessageTypeEnum.SYSTEM_NEWS.getMessageType());
        sql.append(" )   UNREADMESSAGE ");
        return (Date)this.dbExcuter.query(sql.toString(), paramList.toArray(), (ResultHandler)new ResultHandler<Date>(){

            public Date handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getDate("FSENDDATE");
                }
                return null;
            }
        });
    }

    public List<BaseMessageDeailVO> queryMessageListByReadFlagAndLevel(String userId, String isRead, String messageLevel) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT QM.FID AS MESSAGEID,QM.FMESSAGELEVEL,QM.FMESSAGETYPE,QM.FBIZTYPE,QM.FBIZID,QM.FTITLE,QM.FMESSAGECONTENT,QM.FSENDERID,QM.FSENDDATE,QMR.FID AS MESSAGERECEIVERRELID,QMR.FMESSAGEID,QMR.FRECEVIERID,QMR.FISREAD,QMR.FREADDATE FROM T_QING_MESSAGE QM LEFT JOIN T_QING_MESSAGE_RECEIVER_REL QMR ON QMR.MESSAGEID=QM.MESSAGEID  WHERE QMR.FRECEVIERID=? AND QMR.FISREAD=? AND QM.FMESSAGELEVEL=? ORDER BY QM.FSENDDATE DESC", new Object[]{userId, isRead, messageLevel}, (ResultHandler)new ResultHandler<List<BaseMessageDeailVO>>(){

            public List<BaseMessageDeailVO> handle(ResultSet rs) throws SQLException {
                ArrayList<BaseMessageDeailVO> resultList = new ArrayList<BaseMessageDeailVO>(10);
                while (rs.next()) {
                    BaseMessageDeailVO messageDeailVo = MessageDao.this.getBaseMessageDeailVo(rs);
                    resultList.add(messageDeailVo);
                }
                return resultList;
            }
        });
    }

    public List<BaseMessageDeailVO> queryListByDateRangeAndMsgType(final String userId, Date startDate, Date endDate, String messageType) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder sql = new StringBuilder("SELECT MESSAGEID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE,MESSAGERECEIVERRELID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM ");
        sql.append("(SELECT QM.FID AS MESSAGEID,QM.FMESSAGELEVEL,QM.FMESSAGETYPE,QM.FBIZTYPE,QM.FBIZID,QM.FTITLE,QM.FMESSAGECONTENT,QM.FSENDERID,QM.FSENDDATE,QM.FEFFECTIVEDATE,QMR.FID AS MESSAGERECEIVERRELID,QMR.FMESSAGEID,QMR.FRECEVIERID,QMR.FISREAD,QMR.FREADDATE ");
        sql.append("FROM ( ");
        sql.append("SELECT FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE ");
        sql.append("FROM T_QING_MESSAGE WHERE FSENDDATE BETWEEN  ? AND ?  AND FMESSAGETYPE =?)   QM ");
        sql.append("RIGHT JOIN (SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FRECEVIERID=?)   QMR ON QMR.FMESSAGEID=QM.FID ");
        params.add(startDate);
        params.add(endDate);
        params.add(MessageTypeEnum.BIZ_NEWS.getMessageType());
        params.add(userId);
        sql.append(" WHERE  QMR.FRECEVIERID=? AND QM.FSENDDATE BETWEEN  ? AND ?  AND QM.FMESSAGETYPE =?");
        params.add(userId);
        params.add(startDate);
        params.add(endDate);
        params.add(MessageTypeEnum.BIZ_NEWS.getMessageType());
        sql.append(" UNION ALL");
        sql.append(" SELECT QM.FID AS MESSAGEID,QM.FMESSAGELEVEL,QM.FMESSAGETYPE,QM.FBIZTYPE,QM.FBIZID,QM.FTITLE,QM.FMESSAGECONTENT,QM.FSENDERID,QM.FSENDDATE,QM.FEFFECTIVEDATE,").append("QMR.FID AS MESSAGERECEIVERRELID,QMR.FMESSAGEID,QMR.FRECEVIERID,QMR.FISREAD,QMR.FREADDATE ");
        sql.append("FROM (SELECT FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE ");
        sql.append("FROM T_QING_MESSAGE WHERE FSENDDATE BETWEEN  ? AND ?  AND FMESSAGETYPE IN (?,?) )   QM ");
        params.add(startDate);
        params.add(endDate);
        params.add(MessageTypeEnum.PUBLISH_NEWS.getMessageType());
        params.add(MessageTypeEnum.SYSTEM_NEWS.getMessageType());
        sql.append("LEFT JOIN (SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE  FRECEVIERID=? )   QMR ON QMR.FMESSAGEID=QM.FID ");
        params.add(userId);
        sql.append(")   USERALLMESSAGE ");
        sql.append(" WHERE 1=1  ");
        if (StringUtils.isNotEmpty((CharSequence)messageType)) {
            sql.append(" AND FMESSAGETYPE=?  ");
            params.add(messageType);
        }
        sql.append(" ORDER BY FSENDDATE DESC");
        return (List)this.dbExcuter.query(sql.toString(), params.toArray(), (ResultHandler)new ResultHandler<List<BaseMessageDeailVO>>(){

            public List<BaseMessageDeailVO> handle(ResultSet rs) throws SQLException {
                ArrayList<BaseMessageDeailVO> resultList = new ArrayList<BaseMessageDeailVO>(10);
                while (rs.next()) {
                    BaseMessageDeailVO messageDeailVo = MessageDao.this.getBaseMessageDeailVo(rs);
                    messageDeailVo.setReceiverId(userId);
                    resultList.add(messageDeailVo);
                }
                return resultList;
            }
        });
    }

    public List<MessagePO> queryByBizIds(List<String> sourceIdList) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("SELECT FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FSENDERID,FSENDDATE FROM T_QING_MESSAGE ");
        if (CollectionUtils.isNotEmpty(sourceIdList)) {
            sql.append(" WHERE FBIZID IN (");
            for (String sourceId : sourceIdList) {
                sql.append("?,");
            }
            sql.delete(sql.length() - 1, sql.length()).append(")");
        }
        return (List)this.dbExcuter.query(sql.toString(), sourceIdList.toArray(), (ResultHandler)new ResultHandler<List<MessagePO>>(){

            public List<MessagePO> handle(ResultSet rs) throws SQLException {
                ArrayList<MessagePO> resultList = new ArrayList<MessagePO>(10);
                while (rs.next()) {
                    MessagePO messagePO = new MessagePO();
                    messagePO.setMessageId(rs.getString("FID"));
                    messagePO.setMessageLevel(rs.getString("FMESSAGELEVEL"));
                    messagePO.setMessageType(rs.getString("FMESSAGETYPE"));
                    messagePO.setBizType(rs.getString("FBIZTYPE"));
                    messagePO.setBizId(rs.getString("FBIZID"));
                    messagePO.setMessageTitle(rs.getString("FTITLE"));
                    messagePO.setSenderId(rs.getString("FSENDERID"));
                    messagePO.setSendDate(rs.getTimestamp("FSENDDATE"));
                    resultList.add(messagePO);
                }
                return resultList;
            }
        });
    }

    public void updateBatch(List<MessagePO> updateMessageList) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(updateMessageList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(updateMessageList.size());
        for (MessagePO messagePO : updateMessageList) {
            Object[] param = new Object[9];
            param[0] = messagePO.getMessageLevel();
            param[1] = messagePO.getMessageType();
            param[2] = messagePO.getBizType();
            param[3] = messagePO.getBizId();
            String messageTitle = messagePO.getMessageTitle();
            if (StringUtils.isNotEmpty((CharSequence)messageTitle)) {
                messageTitle = messagePO.getMessageTitle().substring(0, Math.min(80, messagePO.getMessageTitle().length()));
            }
            param[4] = messageTitle;
            param[5] = messagePO.getMessageContent() != null ? this.dbExcuter.createSqlParameterBytes(messagePO.getMessageContent(), 0, messagePO.getMessageContent().length) : null;
            param[6] = messagePO.getSenderId();
            param[7] = messagePO.getEffectiveDate();
            param[8] = messagePO.getMessageId();
            paramsList.add(param);
        }
        this.dbExcuter.executeBatch("UPDATE T_QING_MESSAGE SET FMESSAGELEVEL=?,FMESSAGETYPE=?,FBIZTYPE=?,FBIZID=?,FTITLE=?,FMESSAGECONTENT=?,FSENDERID=?,FEFFECTIVEDATE=? WHERE FID=?", paramsList);
    }

    public void insertList(List<MessagePO> insertMessageList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(insertMessageList.size());
        for (MessagePO messagePO : insertMessageList) {
            Object[] param = new Object[10];
            param[0] = messagePO.getMessageId();
            param[1] = messagePO.getMessageLevel();
            param[2] = messagePO.getMessageType();
            param[3] = messagePO.getBizType();
            param[4] = messagePO.getBizId();
            String messageTitle = messagePO.getMessageTitle();
            if (StringUtils.isNotEmpty((CharSequence)messageTitle)) {
                messageTitle = messagePO.getMessageTitle().substring(0, Math.min(80, messagePO.getMessageTitle().length()));
            }
            param[5] = messageTitle;
            param[6] = messagePO.getMessageContent() != null ? this.dbExcuter.createSqlParameterBytes(messagePO.getMessageContent(), 0, messagePO.getMessageContent().length) : null;
            param[7] = messagePO.getSenderId();
            param[8] = messagePO.getSendDate();
            param[9] = messagePO.getEffectiveDate();
            paramsList.add(param);
        }
        this.dbExcuter.executeBatch("INSERT INTO T_QING_MESSAGE(FID,FMESSAGELEVEL,FMESSAGETYPE,FBIZTYPE,FBIZID,FTITLE,FMESSAGECONTENT,FSENDERID,FSENDDATE,FEFFECTIVEDATE) values (?,?,?,?,?,?,?,?,?,?)", paramsList);
    }

    public void deleteById(String messageId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_MESSAGE WHERE FID=?", new Object[]{messageId});
    }

    public void deleteByIds(List<String> deleteMessageIdList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(deleteMessageIdList.size());
        for (String messageId : deleteMessageIdList) {
            Object[] param = new Object[]{messageId};
            paramsList.add(param);
        }
        this.dbExcuter.executeBatch("DELETE FROM T_QING_MESSAGE WHERE FID=?", paramsList);
    }

    public List<String> selectInvalidEffectivedate() throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("SELECT FID  FROM T_QING_MESSAGE WHERE FEFFECTIVEDATE < ? ");
        return (List)this.dbExcuter.query(sql.toString(), new Object[]{new Date()}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> resultList = new ArrayList<String>(10);
                while (rs.next()) {
                    resultList.add(rs.getString("FID"));
                }
                return resultList;
            }
        });
    }

    public Map<String, List<String>> queryBizIdsByUserId(Set<String> receiverUserIdList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT QM.FBIZID,QMR.FRECEVIERID  FROM T_QING_MESSAGE QM ");
        sql.append("LEFT JOIN T_QING_MESSAGE_RECEIVER_REL QMR ON QM.FID=QMR.FMESSAGEID ");
        sql.append("WHERE QMR.FRECEVIERID IN (");
        StringBuffer whereUserIdParamStr = new StringBuffer("?");
        for (int i = 1; i < receiverUserIdList.size(); ++i) {
            whereUserIdParamStr.append(",?");
        }
        paramList.addAll(receiverUserIdList);
        sql.append(whereUserIdParamStr);
        sql.append(") AND QM.FBIZTYPE = ? ");
        paramList.add(BizTypeEnum.AUTHORIZED_NEWS.getBizType());
        sql.append(" UNION ALL ");
        sql.append("SELECT LSR.FPUBLISHID AS FBIZID,QMR.FRECEVIERID  FROM T_QING_MESSAGE QM ");
        sql.append("LEFT JOIN T_QING_MESSAGE_RECEIVER_REL QMR ON QM.FID=QMR.FMESSAGEID ");
        sql.append("LEFT JOIN T_QING_PUB_LAPP_SYNC_GROUP LSG ON QM.FID=LSG.FMESSAGEID ");
        sql.append("LEFT JOIN T_QING_PUB_LAPP_SYNC_RECORD LSR ON LSG.FID=LSR.FGROUPID ");
        sql.append("WHERE QMR.FRECEVIERID IN (");
        sql.append(whereUserIdParamStr);
        paramList.addAll(receiverUserIdList);
        sql.append(") AND QM.FBIZTYPE = ? ");
        paramList.add(BizTypeEnum.LAPP_SYNC_ROLE.getBizType());
        return (Map)this.dbExcuter.query(sql.toString(), paramList.toArray(), (ResultHandler)new ResultHandler<Map<String, List<String>>>(){

            public Map<String, List<String>> handle(ResultSet rs) throws SQLException {
                HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
                while (rs.next()) {
                    String bizId = rs.getString("FBIZID");
                    String userId = rs.getString("FRECEVIERID");
                    if (resultMap.get(userId) == null) {
                        resultMap.put(userId, new ArrayList());
                    }
                    ((List)resultMap.get(userId)).add(bizId);
                }
                return resultMap;
            }
        });
    }
}

