/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.message.domain;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.message.dao.MessageReceiverRelDaoImpl;
import com.kingdee.bos.qing.message.domain.IMessageDomain;
import com.kingdee.bos.qing.message.model.MessageReadFlagEnum;
import com.kingdee.bos.qing.message.model.po.MessagePO;
import com.kingdee.bos.qing.message.model.po.MessageReceiverRelPO;
import com.kingdee.bos.qing.message.model.vo.AbstractMessageDetailVO;
import com.kingdee.bos.qing.message.model.vo.BaseMessageDeailVO;
import java.sql.SQLException;

public abstract class AbstractMessageDomain
implements IDBAccessable,
IQingContextable,
IMessageDomain {
    protected QingContext context;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    private MessageReceiverRelDaoImpl messageReceiverRelDao;

    public void setDbExcuter(IDBExcuter idbExcuter) {
        this.dbExcuter = idbExcuter;
    }

    public void setTx(ITransactionManagement iTransactionManagement) {
        this.tx = iTransactionManagement;
    }

    public void setQingContext(QingContext qingContext) {
        this.context = qingContext;
    }

    public AbstractMessageDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.context = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    protected MessageReceiverRelDaoImpl getMessageReceiverRelDao() {
        if (this.messageReceiverRelDao == null) {
            this.messageReceiverRelDao = new MessageReceiverRelDaoImpl(this.dbExcuter);
        }
        return this.messageReceiverRelDao;
    }

    @Override
    public AbstractMessageDetailVO queryMessageDetailById(MessagePO messagePO, String userId) throws AbstractQingIntegratedException, SQLException {
        MessageReceiverRelPO messageReceiverRelPO = this.getMessageReceiverRelDao().getByMessageIdAndReceiverId(messagePO.getMessageId(), userId);
        BaseMessageDeailVO baseMessageDeailVo = new BaseMessageDeailVO();
        baseMessageDeailVo.setMessageId(messagePO.getMessageId());
        baseMessageDeailVo.setMessageLevel(messagePO.getMessageLevel());
        baseMessageDeailVo.setMessageTitle(messagePO.getMessageTitle());
        baseMessageDeailVo.setMessageType(messagePO.getMessageType());
        baseMessageDeailVo.setMessageContent(messagePO.getMessageContent());
        baseMessageDeailVo.setBizId(messagePO.getBizId());
        baseMessageDeailVo.setBizType(messagePO.getBizType());
        if (messageReceiverRelPO == null) {
            baseMessageDeailVo.setIsRead(MessageReadFlagEnum.UNREAD.getIsRead());
            baseMessageDeailVo.setReceiverId(userId);
        } else {
            baseMessageDeailVo.setIsRead(messageReceiverRelPO.getIsRead());
            baseMessageDeailVo.setReadDate(messageReceiverRelPO.getReadDate());
            baseMessageDeailVo.setReceiverId(messageReceiverRelPO.getReceiverId());
        }
        return baseMessageDeailVo;
    }

    protected void setBaseMessageVo(AbstractMessageDetailVO resultVo, MessagePO messagePO, String userId) throws AbstractQingIntegratedException, SQLException {
        MessageReceiverRelPO messageReceiverRelPO = this.getMessageReceiverRelDao().getByMessageIdAndReceiverId(messagePO.getMessageId(), userId);
        resultVo.setMessageId(messagePO.getMessageId());
        resultVo.setMessageLevel(messagePO.getMessageLevel());
        resultVo.setMessageTitle(messagePO.getMessageTitle());
        resultVo.setMessageType(messagePO.getMessageType());
        resultVo.setMessageContent(messagePO.getMessageContent());
        resultVo.setBizId(messagePO.getBizId());
        resultVo.setBizType(messagePO.getBizType());
        resultVo.setSendDate(messagePO.getSendDate());
        if (messageReceiverRelPO != null) {
            resultVo.setIsRead(messageReceiverRelPO.getIsRead());
            resultVo.setReadDate(messageReceiverRelPO.getReadDate());
            resultVo.setReceiverId(messageReceiverRelPO.getReceiverId());
            resultVo.setSendDateFormatStr(messagePO.getSendDate());
        }
    }
}

