/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.IResourceLock;
import com.kingdee.bos.qing.common.lock.ResourceLockFactory;
import com.kingdee.bos.qing.common.lock.model.ResourceLockResult;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.domain.IPublishSourceDomain;
import com.kingdee.bos.qing.publish.domain.PublishSourceDomainFactory;
import com.kingdee.bos.qing.publish.exception.MismatchSourceTypeException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstarctPublishVO;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVOJsonDecoder;
import com.kingdee.bos.qing.publish.model.ValueTextPair;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.IScheduleEngineable;
import com.kingdee.bos.qing.util.JsonUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import oadd.org.apache.commons.lang3.BooleanUtils;

public abstract class AbstractPublishManageService
extends BehaviorService
implements IQingContextable,
IDBAccessable,
IScheduleEngineable {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected IScheduleEngine scheduleEngine;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    protected abstract AbstractPublishManageDomain getPublishManageDomain();

    public static final byte[] getRuntimePublishInfo(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, String publishId, boolean isCheckPermission) {
        CommonPublishDomain commonPublishDomain = new CommonPublishDomain(qingContext, tx, dbExcuter);
        try {
            Map<String, String> result = commonPublishDomain.getRuntimePublishInfo(publishId, isCheckPermission);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public static final byte[] getPublishInfoForEditSchema(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, String publishId) {
        CommonPublishDomain commonPublishDomain = new CommonPublishDomain(qingContext, tx, dbExcuter);
        try {
            Map<String, String> result = commonPublishDomain.getPublishInfoForEditSchema(publishId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] savePublishInfo(Map<String, String> params) {
        String publishJsonString = params.get("publishInfo");
        String modelJsonString = params.get("schemeModel");
        String oldPublishId = params.get("oldPublishId");
        String tag = params.get("tag");
        String dsbPublishId = params.get("sDsbPublishId");
        String scene = params.get("scene");
        ResponseSuccessWrap wrap = null;
        String userId = this.qingContext.getUserId();
        AbstarctPublishVO publishVO = PublishVOJsonDecoder.decode(publishJsonString);
        if (publishVO.getId() == null || "".equals(publishVO.getId())) {
            publishVO.setId(PublishUtil.getPublishId(UUID.randomUUID().toString()));
        }
        PublishPO publishInfo = publishVO.toPO(userId);
        List<PermissionInfo> permInfos = this.buildPermissionInfo(publishVO);
        try {
            this.getPublishManageDomain().savePublishInfo(tag, publishInfo, permInfos, modelJsonString, oldPublishId, dsbPublishId, scene);
            wrap = new ResponseSuccessWrap((Object)publishInfo.getId());
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] deletePublishInfo(Map<String, String> params) {
        ResponseSuccessWrap wrap = null;
        String infoId = params.get("id");
        try {
            this.getPublishManageDomain().deletePublishInfo(infoId);
            wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] deletePublishInfos(Map<String, String> params) {
        List infoIds = (List)JsonUtil.decodeFromString((String)params.get("ids"), List.class);
        try {
            List<String> publishIds = this.getPublishManageDomain().deletePublishInfos(infoIds);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(publishIds);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] updatePublishInfo(Map<String, String> params) {
        String userId = this.qingContext.getUserId();
        int updateType = Integer.parseInt(params.get("updateType"));
        String name = params.get("name");
        String publishJsonString = params.get("publishInfo");
        AbstarctPublishVO publishVO = PublishVOJsonDecoder.decode(publishJsonString);
        PublishPO publishInfo = null;
        List<PermissionInfo> permInfos = null;
        String modelJsonString = params.get("schemeModel");
        try {
            switch (updateType) {
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    publishInfo = publishVO.toPO(userId);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: {
                    publishInfo = publishVO.toPO(userId);
                    permInfos = this.buildUpdatePermissionInfo(publishVO, updateType);
                    break;
                }
                default: {
                    throw new PublishException("invalid updateType: " + updateType);
                }
            }
            this.getPublishManageDomain().updatePublishInfo(updateType, publishInfo, permInfos, modelJsonString, name);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)publishInfo);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    protected List<PermissionInfo> buildPermissionInfo(AbstarctPublishVO publishVO) {
        ArrayList<PermissionInfo> permInfos = new ArrayList<PermissionInfo>();
        String publishId = publishVO.getId();
        List<ValueTextPair> userPair = publishVO.getUsers();
        this.buildPermInfos(publishId, userPair, 0, permInfos);
        List<ValueTextPair> rolePair = publishVO.getRoles();
        this.buildPermInfos(publishId, rolePair, 1, permInfos);
        return permInfos;
    }

    protected List<PermissionInfo> buildUpdatePermissionInfo(AbstarctPublishVO publishVO, int updateType) {
        ArrayList<PermissionInfo> permInfos = new ArrayList<PermissionInfo>();
        String publishId = publishVO.getId();
        if (updateType == 9 || updateType == 2 || updateType == 6 || updateType == 7) {
            List<ValueTextPair> userPair = publishVO.getUsers();
            this.buildPermInfos(publishId, userPair, 0, permInfos);
        }
        if (updateType == 9 || 3 == updateType || updateType == 6 || updateType == 7) {
            List<ValueTextPair> rolePair = publishVO.getRoles();
            this.buildPermInfos(publishId, rolePair, 1, permInfos);
        }
        return permInfos;
    }

    private void buildPermInfos(String publishId, List<ValueTextPair> pairs, int type, List<PermissionInfo> permInfos) {
        PermissionInfo permInfo = null;
        if (pairs == null || pairs.isEmpty()) {
            return;
        }
        Date date = new Date();
        for (ValueTextPair pair : pairs) {
            permInfo = new PermissionInfo();
            permInfo.setId(UUID.randomUUID().toString());
            permInfo.setPublishId(publishId);
            permInfo.setViewerId(pair.getValue());
            permInfo.setType(type);
            permInfo.setCreateTime(date);
            permInfos.add(permInfo);
        }
    }

    public byte[] saveMessage(Map<String, String> params) {
        try {
            String publishIdUserMapStr = params.get("publishIdUserMap");
            Map publishIdUserMap = (Map)JsonUtil.decodeFromString((String)publishIdUserMapStr, Map.class);
            this.getPublishManageDomain().saveMessage(publishIdUserMap);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPublishOperModel(Map<String, String> params) {
        try {
            String biztag = params.get("biztag");
            boolean isEdit = BooleanUtils.toBoolean((String)params.get("isEdit"));
            boolean isTimedPush = Boolean.parseBoolean(params.get("timedPush"));
            String reftoPublishId = params.get("dsbRefToPublishId");
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getPublishManageDomain().loadParentPublishOperModel(biztag, isEdit, reftoPublishId, isTimedPush));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPublishOperList(Map<String, String> params) {
        try {
            String publishId = params.get("publishId");
            String dsbPublishId = params.get("dsbPublishId");
            boolean isTimedPush = Boolean.parseBoolean(params.get("timedPush"));
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getPublishManageDomain().loadPublishOperList(publishId, dsbPublishId, true, isTimedPush));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadUserByRoles(Map<String, String> params) {
        try {
            String rolesJson = params.get("roles");
            List roleIdList = (List)JsonUtil.decodeFromString((String)rolesJson, List.class);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getPublishManageDomain().loadUserByRoles(roleIdList));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getAllSchemaAttrs(Map<String, String> params) {
        String publishJsonString = params.get("publishSourceType");
        String bizTag = params.get("bizTag");
        String iSource = params.get("source");
        int source = 0;
        if (iSource != null) {
            source = Integer.parseInt(iSource);
        }
        String isEditPublishInfo = params.get("isEditPublishInfo");
        String userId = this.qingContext.getUserId();
        try {
            PublishSourceEnum publishSourceEnum = (PublishSourceEnum)((Object)JsonUtil.decodeFromString((String)publishJsonString, PublishSourceEnum.class));
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishSourceEnum);
            return publishSourceDomain.getAllSchemaAttrs(bizTag, source, userId, Boolean.parseBoolean(isEditPublishInfo));
        }
        catch (MismatchSourceTypeException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
    }

    public byte[] getSchemaAttrByPublishId(Map<String, String> params) {
        String publishId = params.get("publishId");
        String publishJsonString = params.get("publishSourceType");
        String iSource = params.get("source");
        int source = 0;
        if (iSource != null) {
            source = Integer.parseInt(iSource);
        }
        String userId = "SystemUser";
        try {
            PublishSourceEnum publishSourceEnum = (PublishSourceEnum)((Object)JsonUtil.decodeFromString((String)publishJsonString, PublishSourceEnum.class));
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishSourceEnum);
            return publishSourceDomain.getSchemaAttrByPublishId(publishId, userId, source);
        }
        catch (MismatchSourceTypeException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
    }

    public byte[] publicSchema_setDefaultAttr(Map<String, String> params) {
        String publishJsonString = params.get("publishInfo");
        String bizTag = params.get("bizTag");
        String modelJsonString = params.get("model");
        String userId = this.qingContext.getUserId();
        AbstarctPublishVO publishVO = PublishVOJsonDecoder.decode(publishJsonString);
        if (publishVO.getId() == null || "".equals(publishVO.getId())) {
            publishVO.setId(PublishUtil.getPublishId(UUID.randomUUID().toString()));
        }
        PublishPO publishInfo = publishVO.toPO(userId);
        try {
            PublishSourceEnum publishSourceEnum = PublishSourceDomainFactory.confirmSourceTypeByPublishInfo(this.qingContext, this.tx, this.dbExcuter, publishInfo);
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishSourceEnum);
            return publishSourceDomain.setPublicPlanDefaultAttr(bizTag, modelJsonString, userId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            return ResponseUtil.output((Exception)((Object)e));
        }
        catch (SQLException e) {
            this.tx.markRollback();
            return ResponseUtil.output((Exception)e);
        }
        catch (MismatchSourceTypeException e) {
            this.tx.markRollback();
            return ResponseUtil.output((Exception)((Object)e));
        }
    }

    public byte[] judgePublishOper(Map<String, String> params) {
        try {
            String publishId = params.get("publishId");
            String dsbPublishId = params.get("dsbPublishId");
            String scene = params.get("scene");
            String publishOper = params.get("publishOperValue");
            this.getPublishManageDomain().judgePublishOper(publishId, dsbPublishId, scene, publishOper);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getPublishedRecordNameByInputText(Map<String, String> params) {
        String publishSourceType = params.get("publishSourceType");
        String inputText = params.get("inputText");
        String publishTargetType = params.get("publishTargetType");
        String userId = this.qingContext.getUserId();
        try {
            PublishSourceEnum publishSourceEnum = (PublishSourceEnum)((Object)JsonUtil.decodeFromString((String)publishSourceType, PublishSourceEnum.class));
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishSourceEnum);
            List<String> publishedRecordNameList = publishSourceDomain.getPublishedRecordNameByInputText(userId, inputText, publishSourceType, publishTargetType);
            HashMap<String, List<String>> publishedNameMap = new HashMap<String, List<String>>(1);
            publishedNameMap.put(inputText, publishedRecordNameList);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(publishedNameMap);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkOperatorResourceLock(Map<String, String> params) {
        String groupId = params.get("groupId");
        String opResourceId = params.get("OpResourceId").substring(13).replaceAll("-", "");
        String resourceId = params.get("resourceId").substring(13).replaceAll("-", "");
        try {
            IResourceLock resourceLock = ResourceLockFactory.createLock((String)groupId, (String)groupId, (boolean)true);
            ResourceLockResult resourceLockResult = resourceLock.lock(opResourceId);
            if (resourceLockResult.isSuccessed()) {
                resourceLock.lock(resourceId);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)resourceLockResult.isSuccessed()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] tryRequireResourceLock(Map<String, String> params) {
        String groupId = params.get("groupId");
        String resourceId = params.get("resourceId").substring(13).replaceAll("-", "");
        try {
            IResourceLock resourceLock = ResourceLockFactory.createLock((String)groupId, (String)groupId, (boolean)true);
            ResourceLockResult lockResult = resourceLock.lock(resourceId);
            if (lockResult.isSuccessed()) {
                resourceLock.unlock(resourceId);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)lockResult.isSuccessed()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] tryAddResourceLock(Map<String, String> params) {
        String groupId = params.get("groupId");
        String resourceId = params.get("resourceId").substring(13).replaceAll("-", "");
        try {
            IResourceLock resourceLock = ResourceLockFactory.createLock((String)groupId, (String)groupId, (boolean)true);
            ResourceLockResult lockResult = resourceLock.lock(resourceId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)lockResult.isSuccessed()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] closeResourceLock(Map<String, String> params) {
        String groupId = params.get("groupId");
        String opResourceId = params.get("OpResourceId").substring(13).replaceAll("-", "");
        String resourceId = params.get("resourceId").substring(13).replaceAll("-", "");
        try {
            IResourceLock resourceLock = ResourceLockFactory.createLock((String)groupId, (String)groupId, (boolean)true);
            resourceLock.unlock(resourceId);
            if (opResourceId != null) {
                resourceLock.unlock(opResourceId);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkBeforeEditAndPublishInfo(Map<String, String> params) {
        String publishId = params.get("publishId");
        String publishSourceType = params.get("publishSourceType");
        String arrJsonSelectSchema = params.get("arrJsonSelectSchemaModel");
        try {
            PublishPO publishPO = this.getPublishManageDomain().loadPublishInfo(publishId);
            PublishSourceEnum publishSourceEnum = (PublishSourceEnum)((Object)JsonUtil.decodeFromString((String)publishSourceType, PublishSourceEnum.class));
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishSourceEnum);
            List schemaModelStrList = (List)JsonUtil.decodeFromString((String)arrJsonSelectSchema, List.class);
            ArrayList<AbstractPublishSourceModel> abstractPublishSourceModelList = new ArrayList<AbstractPublishSourceModel>(schemaModelStrList.size());
            for (int i = 0; i < schemaModelStrList.size(); ++i) {
                AbstractPublishSourceModel abstractPublishSourceModel = publishSourceDomain.parsePublishSourceModel(JsonUtil.encodeToString(schemaModelStrList.get(i)));
                abstractPublishSourceModelList.add(abstractPublishSourceModel);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)publishSourceDomain.checkBeforeEditAndPublishInfo(publishPO, abstractPublishSourceModelList)));
        }
        catch (AbstractQingIntegratedException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
        catch (SQLException e) {
            return ResponseUtil.output((Exception)e);
        }
        catch (MismatchSourceTypeException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
        catch (PublishException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
    }

    public byte[] checkPublishInfoIsExist(Map<String, String> params) {
        String publishId = params.get("publishId");
        try {
            PublishPO publishPO = this.getPublishManageDomain().loadPublishInfo(publishId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)(publishPO == null ? 1 : 0)));
        }
        catch (AbstractQingIntegratedException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
        catch (SQLException e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

