/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PublishPermissionDao {
    private IDBExcuter dbExcuter;

    public PublishPermissionDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void deletePublishPermission(String infoId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{infoId};
        String sqlDelPermission = "DELETE FROM T_QING_PERMPUBLISH WHERE FPUBLISHID in (?)";
        this.dbExcuter.execute(sqlDelPermission, params);
    }

    public void insertPermissoinInfo(List<PermissionInfo> permInfos) throws AbstractQingIntegratedException, SQLException {
        String sqlInsert = "INSERT INTO T_QING_PERMPUBLISH (FID,FPUBLISHID,FVIEWERID,FTYPE,FCREATETIME) VALUES(?,?,?,?,?)";
        Object[] params = null;
        PermissionInfo permInfo = null;
        Iterator<PermissionInfo> iter = permInfos.iterator();
        ArrayList<Object[]> listParam = new ArrayList<Object[]>(10);
        while (iter.hasNext()) {
            permInfo = iter.next();
            String perInfoId = permInfo.getId();
            if (perInfoId == null || "".equals(perInfoId.trim())) continue;
            params = new Object[]{permInfo.getId(), permInfo.getPublishId(), permInfo.getViewerId(), permInfo.getType(), permInfo.getCreateTime()};
            listParam.add(params);
        }
        this.dbExcuter.executeBatch(sqlInsert, listParam);
    }

    public List<PermissionInfo> loadPublishPermissionInfo(final String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select FID,FPUBLISHID,FVIEWERID,FTYPE,FCREATETIME from T_QING_PERMPUBLISH where FPUBLISHID = ?";
        Object[] params = new Object[]{publishId};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<PermissionInfo>>(){

            public List<PermissionInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<PermissionInfo> result = new ArrayList<PermissionInfo>(10);
                while (rs.next()) {
                    PermissionInfo permissionInfo = new PermissionInfo();
                    permissionInfo.setPublishId(publishId);
                    permissionInfo.setId(rs.getString("FID"));
                    permissionInfo.setViewerId(rs.getString("FVIEWERID"));
                    permissionInfo.setType(rs.getInt("FTYPE"));
                    permissionInfo.setViewerId(rs.getString("FVIEWERID"));
                    permissionInfo.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    result.add(permissionInfo);
                }
                return result;
            }
        });
    }

    public Map<String, List<PermissionInfo>> loadPublishPermissionInfo(List<String> ids) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlInQuestionBuilder;
        String sqlInQuestion = "null";
        if (ids != null && ids.size() > 0) {
            sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < ids.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
        } else {
            return new HashMap<String, List<PermissionInfo>>();
        }
        sqlInQuestion = sqlInQuestionBuilder.toString();
        String sql = "SELECT FID,FPUBLISHID,FVIEWERID,FTYPE,FCREATETIME FROM T_QING_PERMPUBLISH WHERE FPUBLISHID IN (" + sqlInQuestion + ")";
        return (Map)this.dbExcuter.query(sql, ids.toArray(), (ResultHandler)new ResultHandler<Map<String, List<PermissionInfo>>>(){

            public Map<String, List<PermissionInfo>> handle(ResultSet rs) throws SQLException {
                HashMap<String, List<PermissionInfo>> map = new HashMap<String, List<PermissionInfo>>(10);
                while (rs.next()) {
                    PermissionInfo permissionInfo = new PermissionInfo();
                    String publishId = rs.getString("FPUBLISHID");
                    permissionInfo.setPublishId(publishId);
                    permissionInfo.setId(rs.getString("FID"));
                    permissionInfo.setViewerId(rs.getString("FVIEWERID"));
                    permissionInfo.setType(rs.getInt("FTYPE"));
                    permissionInfo.setViewerId(rs.getString("FVIEWERID"));
                    permissionInfo.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    ArrayList<PermissionInfo> list = (ArrayList<PermissionInfo>)map.get(publishId);
                    if (list == null) {
                        list = new ArrayList<PermissionInfo>();
                    }
                    list.add(permissionInfo);
                    map.put(publishId, list);
                }
                return map;
            }
        });
    }

    public void updatePermissionInfo(String publishId, List<PermissionInfo> permInfos) throws AbstractQingIntegratedException, SQLException {
        String sqlDelete = "DELETE FROM T_QING_PERMPUBLISH WHERE FPUBLISHID=?";
        this.dbExcuter.execute(sqlDelete, new Object[]{publishId});
        if (permInfos != null && !permInfos.isEmpty()) {
            this.insertPermissoinInfo(permInfos);
        }
    }

    public void addPermissoinInfo(String publishId, List<PermissionInfo> newPermInfos) throws AbstractQingIntegratedException, SQLException {
        if (newPermInfos != null && !newPermInfos.isEmpty()) {
            List<PermissionInfo> oldPermInfos = this.loadPublishPermissionInfo(publishId);
            newPermInfos.addAll(oldPermInfos);
            ArrayList<PermissionInfo> mergerPermInfos = new ArrayList<PermissionInfo>();
            for (int i = 0; i < newPermInfos.size(); ++i) {
                PermissionInfo newPermInfo = newPermInfos.get(i);
                boolean addFlag = true;
                for (int j = 0; j < mergerPermInfos.size(); ++j) {
                    PermissionInfo mergerPermInfo = (PermissionInfo)mergerPermInfos.get(j);
                    if (mergerPermInfo.getType() != newPermInfo.getType() || (mergerPermInfo.getViewerId() == null || !mergerPermInfo.getViewerId().equals(newPermInfo.getViewerId())) && (mergerPermInfo.getViewerId() != null || newPermInfo.getViewerId() != null)) continue;
                    addFlag = false;
                    break;
                }
                if (!addFlag) continue;
                mergerPermInfos.add(newPermInfos.get(i));
            }
            this.updatePermissionInfo(publishId, mergerPermInfos);
        }
    }

    public boolean isEncryptedTheme(String themeId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FEncryptedStatus FROM T_QING_THEME  WHERE FID=? and FISDELETE='0'";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{themeId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getBoolean("FEncryptedStatus");
                }
                return false;
            }
        });
    }
}

