/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.publish.IPublishStrategy;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.message.domain.MessageDomain;
import com.kingdee.bos.qing.message.exception.MessageParamErrorException;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.vo.SaveMessageVo;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.publish.dao.PubLappSyncGroupDao;
import com.kingdee.bos.qing.publish.dao.PubLappSyncRecordDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.dao.PublishOperPermissionsDao;
import com.kingdee.bos.qing.publish.dao.PublishPermissionDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.domain.IBillPublishSourceDomain;
import com.kingdee.bos.qing.publish.domain.IPublishSourceDomain;
import com.kingdee.bos.qing.publish.domain.PublishSourceDomainFactory;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishNoOperAuthException;
import com.kingdee.bos.qing.publish.exception.PublishNoPermissionException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishOverMaxLevelException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.OperCodeEnum;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PubLappSyncGroupPO;
import com.kingdee.bos.qing.publish.model.PubLappSyncRecordPO;
import com.kingdee.bos.qing.publish.model.PublishOperModelVO;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsPO;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.model.SceneType;
import com.kingdee.bos.qing.publish.model.ValueTextPair;
import com.kingdee.bos.qing.publish.model.VerifyVo;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractPublishManageDomain
extends CommonPublishDomain {
    protected IScheduleEngine scheduleEngine;
    private MessageDomain messageDomain;
    private PubLappSyncGroupDao pubLappSyncGroupDao;
    private PubLappSyncRecordDao pubLappSyncRecordDao;
    public static final int MAX_PUBLISH_LEVEL = 5;

    public AbstractPublishManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter);
        this.scheduleEngine = scheduleEngine;
    }

    private MessageDomain getMessageDomain() {
        if (this.messageDomain == null) {
            this.messageDomain = new MessageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.messageDomain;
    }

    private PubLappSyncGroupDao getPubLappSyncGroupDao() {
        if (this.pubLappSyncGroupDao == null) {
            this.pubLappSyncGroupDao = new PubLappSyncGroupDao(this.dbExcuter);
        }
        return this.pubLappSyncGroupDao;
    }

    private PubLappSyncRecordDao getPubLappSyncRecordDao() {
        if (this.pubLappSyncRecordDao == null) {
            this.pubLappSyncRecordDao = new PubLappSyncRecordDao(this.dbExcuter);
        }
        return this.pubLappSyncRecordDao;
    }

    public final void updatePublishInfo(int updateType, PublishPO publishInfoNew, List<PermissionInfo> permInfos, String modelJsonString, String name) throws PublishException, AbstractQingIntegratedException {
        PublishVO publishVO;
        PublishPO oldPublishPO;
        try {
            String bizTag = this.getOriginalSourceId(publishInfoNew.getTagId());
            this.verifyPublishInfoWhenUpdate(publishInfoNew, bizTag);
        }
        catch (SQLException e) {
            throw new PublishException(e);
        }
        try {
            this.tx.beginRequired();
            String publishId = publishInfoNew.getId();
            oldPublishPO = this.loadPublishInfo(publishId);
            publishInfoNew.setSchemaId(oldPublishPO.getSchemaId());
            publishVO = this.getPublishVO(oldPublishPO.getId());
            if (oldPublishPO == null) {
                throw new PublishNotFoundException();
            }
            if (!oldPublishPO.getCreatorId().equals(this.qingContext.getUserId())) {
                throw new PublishNoPermissionException(null);
            }
            PublishSourceEnum sourceType = PublishSourceDomainFactory.confirmSourceTypeByPublishInfo(this.qingContext, this.tx, this.dbExcuter, oldPublishPO);
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, sourceType);
            AbstractPublishSourceModel abstractPublishSourceModel = null;
            if (publishSourceDomain != null && modelJsonString != null && !modelJsonString.isEmpty()) {
                List schemaModelStrList = (List)JsonUtil.decodeFromString((String)modelJsonString, List.class);
                ArrayList<AbstractPublishSourceModel> abstractPublishSourceModelList = new ArrayList<AbstractPublishSourceModel>(schemaModelStrList.size());
                for (int i = 0; i < schemaModelStrList.size(); ++i) {
                    abstractPublishSourceModel = publishSourceDomain.parsePublishSourceModel(JsonUtil.encodeToString(schemaModelStrList.get(i)));
                    abstractPublishSourceModelList.add(abstractPublishSourceModel);
                }
                publishSourceDomain.updatePublish(updateType, publishInfoNew, oldPublishPO, abstractPublishSourceModelList);
            } else {
                publishInfoNew.setSchemaId(oldPublishPO.getSchemaId());
            }
            AbstractPublishTargetDomain publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine, oldPublishPO.getPublishTargetType());
            if (publishTargetDomain != null) {
                publishTargetDomain.updatePublish(updateType, publishInfoNew);
            }
            switch (updateType) {
                case 0: 
                case 1: 
                case 5: {
                    this.getPublishInfoDao().updatePublishInfo(updateType, publishInfoNew);
                    break;
                }
                case 2: 
                case 3: 
                case 9: {
                    this.getPublishPermissionDao().updatePermissionInfo(publishId, permInfos);
                    break;
                }
                case 6: 
                case 7: {
                    this.getPublishInfoDao().updatePublishInfo(updateType, publishInfoNew);
                    this.getPublishPermissionDao().updatePermissionInfo(publishId, permInfos);
                    break;
                }
            }
            this.updatePublishOperPers(publishId, publishInfoNew, oldPublishPO);
            String messageTitle = Messages.getMLS((QingContext)this.qingContext, (String)"messageTitlePublishAuth", (String)"\u201c$param1\u201d\u53d1\u5e03\u4e86\u201c$param2\u201d\u5e76\u6388\u6743\u7ed9\u60a8", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING).replace("$param1", IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, publishInfoNew.getCreatorId())).replace("$param2", name == null ? publishInfoNew.getName() : name);
            this.saveOrUpdateMessage(permInfos, messageTitle, publishId, true, publishInfoNew.getFailedUserIds());
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new PublishException(e);
        }
        finally {
            this.tx.end();
        }
        String oldName = oldPublishPO.getName();
        String newName = publishInfoNew.getName();
        String oldPath = oldPublishPO.getPath();
        String newPath = publishInfoNew.getPath();
        String pathText = publishInfoNew.getPathText();
        if (pathText != null && pathText.endsWith("/")) {
            pathText = pathText.substring(0, pathText.lastIndexOf(47));
        }
        try {
            ArrayList<String> params = new ArrayList<String>(4);
            if (!oldName.equals(newName) && oldPath.equals(newPath)) {
                params.add(oldName);
                params.add(newName);
                params.add(pathText);
                this.addPublishOpLog(OpLogActionType.EDIT, params, "\u201c$param\u201d\u7684\u540d\u79f0\u4e3a\u201c$param\u201d");
            } else if (oldName.equals(newName) && !oldPath.equals(newPath)) {
                params.add(oldName);
                if (publishVO != null) {
                    params.add(publishVO.getPathText());
                    params.add(pathText);
                    this.addPublishOpLogWithPath(OpLogActionType.EDIT, params, "\u201c$param\u201d\u7684\u53d1\u5e03\u8def\u5f84\u201c$param\u201d\u4e3a\u201c$param\u201d");
                }
            } else if (!oldName.equals(newName)) {
                params.add(oldName);
                params.add(newName);
                if (publishVO != null) {
                    params.add(publishVO.getPathText());
                    params.add(pathText);
                    this.addPublishOpLogWithPath(OpLogActionType.EDIT, params, "\u201c$param\u201d\u7684\u540d\u79f0\u4e3a\u201c$param\u201d\uff0c\u53d1\u5e03\u8def\u5f84\u201c$param\u201d\u4e3a\u201c$param\u201d");
                }
            } else {
                params.add(oldName);
                this.addPublishOpLogWithPath(OpLogActionType.EDIT, params, "\u201c$param\u201d");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void savePublishInfo(String tag, PublishPO publishInfo, List<PermissionInfo> permInfos, String modelJsonString, String oldPublishId, String dsbPublishId, String scene) throws PublishException, AbstractQingIntegratedException {
        ArrayList<IQingFile> savedQingFiles = new ArrayList<IQingFile>();
        try {
            this.tx.beginRequired();
            List schemaModelStrList = (List)JsonUtil.decodeFromString((String)modelJsonString, List.class);
            PublishSourceEnum publishSourceType = publishInfo.getPublishSourceType();
            AbstractPublishSourceModel abstractPublishSourceModel = null;
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishSourceType);
            ArrayList<AbstractPublishSourceModel> abstractPublishSourceModelList = new ArrayList<AbstractPublishSourceModel>(schemaModelStrList.size());
            if (publishSourceDomain != null) {
                for (int i = 0; i < schemaModelStrList.size(); ++i) {
                    abstractPublishSourceModel = publishSourceDomain.parsePublishSourceModel(JsonUtil.encodeToString(schemaModelStrList.get(i)));
                    abstractPublishSourceModelList.add(abstractPublishSourceModel);
                }
            }
            if (publishInfo.getPublishSourceFId() != null && PublishUtil.isPublish(publishInfo.getPublishSourceFId())) {
                if (SceneType.Longer.name().equals(scene)) {
                    this.judgePublishOperAuth(publishInfo.getPublishSourceFId(), dsbPublishId, OperCodeEnum.analysis_publish);
                }
                if (SceneType.Square.name().equals(scene)) {
                    this.judgePublishOperAuth(publishInfo.getPublishSourceFId(), dsbPublishId, OperCodeEnum.card_publish);
                }
            }
            this.savePublishInfoNotTx(tag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, oldPublishId, dsbPublishId);
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(savedQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            FileFactory.clearFile(savedQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            FileFactory.clearFile(savedQingFiles);
            this.tx.markRollback();
            throw new PublishException(e);
        }
        finally {
            this.tx.end();
        }
        String name = publishInfo.getName();
        String pathText = publishInfo.getPathText();
        if (name != null && pathText != null) {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(name);
            if (pathText.endsWith("/")) {
                pathText = pathText.substring(0, pathText.lastIndexOf(47));
            }
            params.add(pathText);
            this.addPublishOpLog(OpLogActionType.NEW, params, "\u201c$param\u201d");
        }
    }

    public final String savePublishInfoNotTx(String tag, PublishPO publishInfo, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles, String needOverwritePublishId, String dsbPublishId) throws PublishException, AbstractQingIntegratedException, SQLException {
        String publishId = publishInfo.getId();
        if (publishInfo.getPublishSourceFId() != null && PublishUtil.isPublish(publishInfo.getPublishSourceFId())) {
            PublishPO parentPublishPo = this.getPublishInfoDao().getPublishInfoByInfoId(publishInfo.getPublishSourceFId());
            StringBuilder parentFullPath = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)parentPublishPo.getParentPublishIdFullPath())) {
                parentFullPath.append(parentPublishPo.getParentPublishIdFullPath()).append(',');
            }
            parentFullPath.append(publishInfo.getPublishSourceFId());
            if (StringUtils.isNotEmpty((CharSequence)dsbPublishId)) {
                parentFullPath.append(',').append(dsbPublishId);
            }
            publishInfo.setParentPublishIdFullPath(parentFullPath.toString());
            if (publishInfo.getParentPublishIdFullPath().split(",").length > 5) {
                throw new PublishOverMaxLevelException("5");
            }
        } else if (StringUtils.isNotEmpty((CharSequence)dsbPublishId)) {
            publishInfo.setParentPublishIdFullPath(dsbPublishId);
        }
        String bizTag = this.getOriginalSourceId(publishInfo.getTagId());
        VerifyVo verifyVo = new VerifyVo();
        this.verifyPublishInfoWhenSave(bizTag, verifyVo, publishInfo);
        if (needOverwritePublishId != null) {
            if (publishInfo.isOverwrite() && publishInfo.getPublishTargetType() == 2) {
                PublishPO oldPublishPO = this.getPublishInfoDao().getPublishInfoByInfoId(needOverwritePublishId);
                publishId = oldPublishPO != null ? this.overwritePublishInfo(needOverwritePublishId, tag, bizTag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, null) : this.savePublishInfo(tag, bizTag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, null);
            }
        } else {
            publishId = verifyVo.isSameSourceNameExist() ? this.overwritePublishInfo(needOverwritePublishId, tag, bizTag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, null) : this.savePublishInfo(tag, bizTag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, null);
        }
        return publishId;
    }

    public final String saveBillPublishInfo(String tag, PublishPO publishInfo, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles, String ctrlKey, byte[] filterContent) throws PublishException, AbstractQingIntegratedException, SQLException {
        String publishId;
        String bizTag = this.getOriginalSourceId(publishInfo.getTagId());
        VerifyVo verifyVo = new VerifyVo();
        this.verifyPublishInfoWhenSave(bizTag, verifyVo, publishInfo);
        if (verifyVo.isSameSourceNameExist()) {
            HashMap<String, Object> billContent = new HashMap<String, Object>(2);
            billContent.put("ctrlKey", ctrlKey);
            billContent.put("filterContent", filterContent);
            publishId = this.overwritePublishInfo(null, tag, bizTag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, billContent);
        } else {
            HashMap<String, Object> billContent = new HashMap<String, Object>(2);
            billContent.put("ctrlKey", ctrlKey);
            billContent.put("filterContent", filterContent);
            publishId = this.savePublishInfo(tag, bizTag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, billContent);
        }
        return publishId;
    }

    public void savePublishByModel(String tag, PublishPO publishInfo, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, SQLException, PublishException {
        String newBizTag = this.getOriginalSourceId(publishInfo.getTagId());
        this.savePublishInfo(tag, newBizTag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, null);
    }

    private String savePublishInfo(String tag, String bizTag, PublishPO publishInfo, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles, Map<String, Object> billContent) throws AbstractQingIntegratedException, PublishException, SQLException {
        AbstractPublishTargetDomain publishTargetDomain;
        String name = publishInfo.getName();
        PublishSourceEnum publishSourceType = publishInfo.getPublishSourceType();
        IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishSourceType);
        if (publishSourceDomain != null) {
            publishInfo = publishSourceDomain instanceof IBillPublishSourceDomain && billContent != null ? ((IBillPublishSourceDomain)((Object)publishSourceDomain)).savePublishWithCtrlKey(publishInfo, abstractPublishSourceModelList, billContent) : publishSourceDomain.savePublish(tag, bizTag, publishInfo, abstractPublishSourceModelList, savedQingFiles);
        }
        if ((publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine, publishInfo.getPublishTargetType())) != null) {
            publishInfo = publishTargetDomain.savePublish(tag, publishSourceType, publishInfo, abstractPublishSourceModelList);
        }
        if (permInfos != null && !permInfos.isEmpty()) {
            this.getPublishPermissionDao().insertPermissoinInfo(permInfos);
        }
        publishInfo.setTagId(bizTag);
        this.getPublishInfoDao().savePublishInfo(publishInfo);
        this.savePublishOperPers(publishInfo);
        String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, publishInfo.getCreatorId());
        String messageTitle = Messages.getMLS((QingContext)this.qingContext, (String)"messageTitlePublishAuth", (String)"\u201c$param1\u201d\u53d1\u5e03\u4e86\u201c$param2\u201d\u5e76\u6388\u6743\u7ed9\u60a8", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING).replace("$param1", userName == null ? "undefined" : userName).replace("$param2", name);
        this.saveOrUpdateMessage(permInfos, messageTitle, publishInfo.getId(), false, publishInfo.getFailedUserIds());
        return publishInfo.getId();
    }

    private void savePublishOperPers(PublishPO publishInfo) throws AbstractQingIntegratedException, SQLException, PublishException {
        if (publishInfo.getNoOperValueMap() != null && !publishInfo.getNoOperValueMap().isEmpty()) {
            ArrayList<PublishOperPermissionsPO> operPermissionsPOList = new ArrayList<PublishOperPermissionsPO>(16);
            String parentPublishId = null;
            if (StringUtils.isNotEmpty((CharSequence)publishInfo.getParentPublishIdFullPath())) {
                String[] parentPublishIds = publishInfo.getParentPublishIdFullPath().split(",");
                parentPublishId = parentPublishIds[parentPublishIds.length - 1];
            }
            Map<Object, Object> parentNoOperValueMap = new HashMap(4);
            if (parentPublishId != null) {
                parentNoOperValueMap = this.loadPublishOperList(parentPublishId, null, true, false);
            }
            for (String type : publishInfo.getNoOperValueMap().keySet()) {
                PublishOperPermissionsPO publishOperPermissionsPO = new PublishOperPermissionsPO();
                publishOperPermissionsPO.setType(type);
                if (parentNoOperValueMap.get(type) != null) {
                    publishOperPermissionsPO.setNoOperAuthValue(publishInfo.getNoOperValueMap().get(type) | (Integer)parentNoOperValueMap.get(type));
                } else {
                    publishOperPermissionsPO.setNoOperAuthValue(publishInfo.getNoOperValueMap().get(type));
                }
                publishOperPermissionsPO.setPublishId(publishInfo.getId());
                operPermissionsPOList.add(publishOperPermissionsPO);
            }
            this.getPublishOperPermissionsDao().insertList(operPermissionsPOList);
        }
    }

    private final String overwritePublishInfo(String oldPublishId, String tag, String bizTag, PublishPO publishInfoNew, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles, Map<String, Object> billContent) throws PublishException, AbstractQingIntegratedException, SQLException {
        List<PublishPO> childrenPublishPoList;
        AbstractPublishTargetDomain publishTargetDomain;
        PublishSourceEnum sourceType;
        IPublishSourceDomain publishSourceDomain;
        int publishTargetType = publishInfoNew.getPublishTargetType();
        String name = publishInfoNew.getName();
        String path = publishInfoNew.getPath();
        String creatorId = publishInfoNew.getCreatorId();
        PublishPO oldPublishPO = null;
        if (oldPublishId == null) {
            oldPublishPO = this.getPublishInfoDao().loadPublishInfo(publishTargetType, name, path, creatorId, bizTag);
            if (oldPublishPO == null) {
                throw new PublishNotFoundException();
            }
            oldPublishId = oldPublishPO.getId();
        } else {
            oldPublishPO = this.getPublishInfoDao().getPublishInfoByInfoId(oldPublishId);
        }
        publishInfoNew.setId(oldPublishId);
        for (PermissionInfo permissionInfo : permInfos) {
            permissionInfo.setPublishId(oldPublishId);
        }
        boolean isOnlyKeepOldPubPerm = false;
        IPublishStrategy publishStrategy = (IPublishStrategy)CustomStrategyRegistrar.getStrategy(IPublishStrategy.class);
        if (publishStrategy != null) {
            isOnlyKeepOldPubPerm = publishStrategy.isOnlyKeepOldPubPerm();
        }
        boolean isPresetScene = false;
        String presetUserID = IntegratedHelper.getPresetUserId();
        if (presetUserID != null && presetUserID.equals(this.qingContext.getUserId())) {
            isPresetScene = true;
        }
        String tagId = publishInfoNew.getTagId();
        boolean isEncryptedTheme = this.getPublishPermissionDao().isEncryptedTheme(tagId);
        if (!(isOnlyKeepOldPubPerm && isPresetScene && isEncryptedTheme)) {
            if (publishInfoNew.isAddOldPermission()) {
                this.getPublishPermissionDao().addPermissoinInfo(oldPublishId, permInfos);
            } else {
                this.getPublishPermissionDao().updatePermissionInfo(oldPublishId, permInfos);
            }
        }
        if ((publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, sourceType = PublishSourceDomainFactory.confirmSourceTypeByPublishInfo(this.qingContext, this.tx, this.dbExcuter, oldPublishPO))) != null) {
            if (publishSourceDomain instanceof IBillPublishSourceDomain && billContent != null) {
                ((IBillPublishSourceDomain)((Object)publishSourceDomain)).overwritePublishWithCtrlKey(publishInfoNew, oldPublishPO, abstractPublishSourceModelList, billContent);
            } else {
                publishSourceDomain.overwritePublish(tag, publishInfoNew, oldPublishPO, abstractPublishSourceModelList, savedQingFiles);
            }
        }
        if ((publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine, oldPublishPO.getPublishTargetType())) != null) {
            publishTargetDomain.overwritePublish(tag, 6, publishInfoNew, abstractPublishSourceModelList);
        }
        if (CollectionUtils.isNotEmpty(childrenPublishPoList = this.getPublishInfoDao().queryParentFullPathByPublishId(oldPublishId))) {
            for (PublishPO childrenPublishPo : childrenPublishPoList) {
                String parentPubIdFullPath = childrenPublishPo.getParentPublishIdFullPath();
                String[] parentPublishIds = parentPubIdFullPath.split(",");
                StringBuilder newParentPubIdFullPath = new StringBuilder();
                for (String parentPublishId : parentPublishIds) {
                    if (parentPublishId.equals(oldPublishId)) continue;
                    newParentPubIdFullPath.append(parentPublishId).append(",");
                }
                if (newParentPubIdFullPath.length() != 0) {
                    childrenPublishPo.setParentPublishIdFullPath(newParentPubIdFullPath.substring(0, newParentPubIdFullPath.length() - 1));
                    continue;
                }
                childrenPublishPo.setParentPublishIdFullPath(null);
            }
            this.getPublishInfoDao().updateParentFullPath(childrenPublishPoList);
        }
        this.getPublishInfoDao().updatePublishInfo(8, publishInfoNew);
        this.updatePublishOperPers(oldPublishId, publishInfoNew, oldPublishPO);
        String messageTitle = Messages.getMLS((QingContext)this.qingContext, (String)"messageTitlePublishAuth", (String)"\u201c$param1\u201d\u53d1\u5e03\u4e86\u201c$param2\u201d\u5e76\u6388\u6743\u7ed9\u60a8", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING).replace("$param1", IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, publishInfoNew.getCreatorId())).replace("$param2", name);
        this.saveOrUpdateMessage(permInfos, messageTitle, publishInfoNew.getId(), true, publishInfoNew.getFailedUserIds());
        return publishInfoNew.getId();
    }

    private void updatePublishOperPers(String oldPublishId, PublishPO publishInfoNew, PublishPO oldPublishPO) throws AbstractQingIntegratedException, SQLException, PublishException {
        this.getPublishOperPermissionsDao().deleteByPublishId(oldPublishId);
        this.savePublishOperPers(publishInfoNew);
    }

    public static void doDeletePublishInfo(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, IScheduleEngine scheduleEngine, PublishPO publishInfo, PublishSourceEnum sourceType, PublishInfoDao getPublishInfoDao, PublishPermissionDao publishPermissionDao, PublishOperPermissionsDao publishOperPermissionsDao) throws AbstractQingIntegratedException, SQLException, PublishException {
        AbstractPublishTargetDomain publishTargetDomain;
        String infoId = publishInfo.getId();
        IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(qingContext, dbExcuter, tx, sourceType);
        if (publishSourceDomain != null) {
            publishSourceDomain.deletePublish(publishInfo);
        }
        if ((publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain(qingContext, tx, dbExcuter, scheduleEngine, publishInfo.getPublishTargetType())) != null) {
            publishTargetDomain.deletePublish(publishInfo);
        }
        getPublishInfoDao.deletePublishInfo(infoId);
        publishPermissionDao.deletePublishPermission(infoId);
        ArrayList<String> parentPublishIdList = new ArrayList<String>(16);
        parentPublishIdList.add(infoId);
        if (StringUtils.isNotEmpty((CharSequence)publishInfo.getParentPublishIdFullPath())) {
            String[] parentIds;
            for (String parentId : parentIds = publishInfo.getParentPublishIdFullPath().split(",")) {
                parentPublishIdList.add(parentId);
            }
        }
        for (String publishId : parentPublishIdList) {
            List<PublishPO> parentPublishList = getPublishInfoDao.queryParentFullPathByPublishId(publishId);
            if (!CollectionUtils.isEmpty(parentPublishList)) continue;
            publishOperPermissionsDao.deleteByPublishId(infoId);
        }
    }

    public final void deletePublishInfo(String infoId) throws PublishException, AbstractQingIntegratedException, SQLException {
        PublishVO publishVO;
        try {
            this.tx.beginRequired();
            publishVO = this.getPublishVO(infoId);
            this.deletePublishInfoNoTx(infoId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException throwables) {
            this.tx.markRollback();
            throw throwables;
        }
        finally {
            this.tx.end();
        }
        this.addDelLog(publishVO);
    }

    private void addDelLog(PublishVO publishVO) {
        if (publishVO != null) {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(publishVO.getName());
            params.add(publishVO.getPathText());
            this.addPublishOpLog(OpLogActionType.DELETE, params, "\u201c$param\u201d");
        }
    }

    public PublishVO getPublishVO(String fid) throws AbstractQingIntegratedException, SQLException {
        return null;
    }

    public void addPublishOpLog(OpLogActionType opLogActionType, List<String> params, String opLogParam) {
    }

    public void addPublishOpLogWithPath(OpLogActionType opLogActionType, List<String> params, String opLogParam) {
    }

    public final void deletePublishInfoNoTx(String infoId) throws PublishException, AbstractQingIntegratedException {
        PublishPO publishInfo;
        try {
            publishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(infoId);
            if (publishInfo == null || !this.qingContext.getUserId().equals(publishInfo.getCreatorId())) {
                return;
            }
        }
        catch (SQLException e) {
            throw new PublishException(e);
        }
        try {
            PublishSourceEnum sourceType = PublishSourceDomainFactory.confirmSourceTypeByPublishInfo(this.qingContext, this.tx, this.dbExcuter, publishInfo);
            AbstractPublishManageDomain.doDeletePublishInfo(this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine, publishInfo, sourceType, this.getPublishInfoDao(), this.getPublishPermissionDao(), this.getPublishOperPermissionsDao());
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (PublishException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PublishException(e);
        }
    }

    private String getOriginalSourceId(String bizTag) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException {
        if (bizTag != null && PublishUtil.isPublish(bizTag)) {
            PublishPO oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(bizTag);
            if (oldInfo == null) {
                throw new PublishSourcePublishNotExistException();
            }
            bizTag = oldInfo.getTagId();
        }
        return bizTag;
    }

    public List<String> deletePublishInfos(List<String> infoIds) throws PublishException, AbstractQingIntegratedException {
        try {
            this.tx.beginRequired();
            ArrayList<String> deletedPublishIds = new ArrayList<String>(10);
            List<PublishPO> publishInfos = this.getPublishInfoDao().getPublishInfoByInfoIds(infoIds, this.qingContext.getUserId());
            for (PublishPO publishInfo : publishInfos) {
                PublishVO publishVO = this.getPublishVO(publishInfo.getId());
                PublishSourceEnum sourceType = PublishSourceDomainFactory.confirmSourceTypeByPublishInfo(this.qingContext, this.tx, this.dbExcuter, publishInfo);
                AbstractPublishManageDomain.doDeletePublishInfo(this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine, publishInfo, sourceType, this.getPublishInfoDao(), this.getPublishPermissionDao(), this.getPublishOperPermissionsDao());
                deletedPublishIds.add(publishInfo.getId());
                this.addDelLog(publishVO);
            }
            ArrayList<String> arrayList = deletedPublishIds;
            return arrayList;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new PublishException(e);
        }
        finally {
            this.tx.end();
        }
    }

    private void saveOrUpdateMessage(List<PermissionInfo> permInfos, String messageTitle, String bizId, boolean isUpdate, List<String> failedUserIds) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(permInfos)) {
            return;
        }
        HashSet<String> messageReceiverIdSet = new HashSet<String>();
        for (PermissionInfo permissionInfo : permInfos) {
            if (0 == permissionInfo.getType()) {
                messageReceiverIdSet.add(permissionInfo.getViewerId());
            }
            if (1 != permissionInfo.getType()) continue;
            messageReceiverIdSet.addAll(IntegratedHelper.getUserIdsByRoleId(this.qingContext, this.dbExcuter, permissionInfo.getViewerId()));
        }
        if (isUpdate) {
            List<String> hadSendedReceiveridList = this.getMessageDomain().queryReceiverIdsByBizid(bizId);
            messageReceiverIdSet.removeAll(hadSendedReceiveridList);
            if (CollectionUtils.isNotEmpty(messageReceiverIdSet)) {
                Map<String, List<String>> existsUserPublishIdsMap = this.getMessageDomain().queryBizIdsByUserId(messageReceiverIdSet);
                for (Map.Entry<String, List<String>> entry : existsUserPublishIdsMap.entrySet()) {
                    String userId = entry.getKey();
                    List<String> hadSendPublishIds = existsUserPublishIdsMap.get(userId);
                    if (!hadSendPublishIds.contains(bizId)) continue;
                    messageReceiverIdSet.remove(userId);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(failedUserIds)) {
            messageReceiverIdSet.removeAll(failedUserIds);
        }
        if (CollectionUtils.isEmpty(messageReceiverIdSet)) {
            return;
        }
        ArrayList<String> messageReceiverIdList = new ArrayList<String>();
        messageReceiverIdList.addAll(messageReceiverIdSet);
        SaveMessageVo saveMessageVo = new SaveMessageVo();
        saveMessageVo.setMessageLevel(MessageLevelTypeEnum.NORMAL_LEVEL);
        saveMessageVo.setMessageType(MessageTypeEnum.BIZ_NEWS);
        saveMessageVo.setMessageTitle(messageTitle);
        saveMessageVo.setBizId(bizId);
        saveMessageVo.setBizType(BizTypeEnum.AUTHORIZED_NEWS);
        saveMessageVo.setReceiverIdList(messageReceiverIdList);
        try {
            this.getMessageDomain().saveMessageNoTx(saveMessageVo);
        }
        catch (MessageParamErrorException messageParamErrorException) {
            // empty catch block
        }
    }

    public void saveMessage(Map<String, List<String>> publishIdUserMap) throws AbstractQingIntegratedException, SQLException {
        if (publishIdUserMap == null || publishIdUserMap.isEmpty()) {
            return;
        }
        String loginUserId = this.qingContext.getUserId();
        String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, loginUserId);
        Iterator<Map.Entry<String, List<String>>> iterator = publishIdUserMap.entrySet().iterator();
        HashMap userPublishIdsMap = new HashMap();
        HashSet<String> userIdSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            String publisId = entry.getKey();
            List<String> userIds = entry.getValue();
            userIdSet.addAll(userIds);
            for (String string : userIds) {
                if (userPublishIdsMap.get(string) == null) {
                    userPublishIdsMap.put(string, new ArrayList());
                }
                ((List)userPublishIdsMap.get(string)).add(publisId);
            }
        }
        if (CollectionUtils.isEmpty(userIdSet)) {
            return;
        }
        Map<String, List<String>> existsUserPublishIdsMap = this.getMessageDomain().queryBizIdsByUserId(userIdSet);
        ArrayList<PubLappSyncRecordPO> lappSyncRecordPOList = new ArrayList<PubLappSyncRecordPO>();
        ArrayList<SaveMessageVo> saveMessageVoList = new ArrayList<SaveMessageVo>(10);
        ArrayList<PubLappSyncGroupPO> lappSyncGroupPOList = new ArrayList<PubLappSyncGroupPO>(10);
        for (Map.Entry entry : userPublishIdsMap.entrySet()) {
            String userId = (String)entry.getKey();
            List publisIdList = (List)userPublishIdsMap.get(userId);
            List<String> existsPublishIdList = existsUserPublishIdsMap.get(userId);
            publisIdList.removeAll(existsPublishIdList);
            if (CollectionUtils.isEmpty((Collection)publisIdList)) continue;
            String messageId = this.dbExcuter.genStringId("T_QING_MESSAGE");
            SaveMessageVo saveMessageVo = new SaveMessageVo();
            saveMessageVo.setMessageId(messageId);
            saveMessageVo.setMessageLevel(MessageLevelTypeEnum.NORMAL_LEVEL);
            saveMessageVo.setMessageType(MessageTypeEnum.BIZ_NEWS);
            saveMessageVo.setBizType(BizTypeEnum.LAPP_SYNC_ROLE);
            saveMessageVo.setReceiverIdList(Collections.singletonList(userId));
            PubLappSyncGroupPO pubLappSyncGroupPO = new PubLappSyncGroupPO();
            String groupId = this.dbExcuter.genStringId("T_QING_PUB_LAPP_SYNC_GROUP");
            saveMessageVo.setBizId(groupId);
            pubLappSyncGroupPO.setGroupId(groupId);
            pubLappSyncGroupPO.setMessageId(messageId);
            lappSyncGroupPOList.add(pubLappSyncGroupPO);
            List<PublishPO> publishPOList = this.getPublishInfoDao().getPublishInfoByInfoIds(publisIdList, null);
            StringBuffer publisNameTopThree = new StringBuffer();
            int count = 0;
            int minCount = Math.min(publishPOList.size(), 3);
            for (PublishPO publishPO : publishPOList) {
                PubLappSyncRecordPO messageLappPubUserPO = new PubLappSyncRecordPO();
                messageLappPubUserPO.setPublishId(publishPO.getId());
                messageLappPubUserPO.setGroupId(groupId);
                lappSyncRecordPOList.add(messageLappPubUserPO);
                if (count < 3) {
                    if (publishPO.getName().length() > 36) {
                        publisNameTopThree.append("\u201c").append(publishPO.getName().substring(0, publishPO.getName().length() - 36)).append("\u201d");
                    } else {
                        publisNameTopThree.append("\u201c").append(publishPO.getName()).append("\u201d");
                    }
                    if (count < minCount - 1) {
                        publisNameTopThree.append("\u3001");
                    }
                }
                ++count;
            }
            String messageTitle = Messages.getMLS((QingContext)this.qingContext, (String)"messageTitlePublishAuthFirst", (String)"\u201c$param1\u201d\u53d1\u5e03\u4e86$param2", (Messages.ProjectName)Messages.ProjectName.QING_THEME).replace("$param1", userName).replace("$param2", publisNameTopThree);
            if (publishPOList.size() > 3) {
                messageTitle = messageTitle + Messages.getMLS((QingContext)this.qingContext, (String)"messageTitleEtc", (String)"\u7b49$param3\u9879\u5185\u5bb9", (Messages.ProjectName)Messages.ProjectName.QING_THEME).replace("$param3", publishPOList.size() + "");
            }
            messageTitle = messageTitle + Messages.getMLS((QingContext)this.qingContext, (String)"messageTitlePublishAuthEnd", (String)"\u5e76\u6388\u6743\u7ed9\u60a8", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
            saveMessageVo.setMessageTitle(messageTitle);
            saveMessageVoList.add(saveMessageVo);
        }
        try {
            this.tx.beginRequired();
            if (CollectionUtils.isNotEmpty(saveMessageVoList)) {
                this.getMessageDomain().saveMessageListNoTx(saveMessageVoList);
            }
            if (CollectionUtils.isNotEmpty(lappSyncGroupPOList)) {
                this.getPubLappSyncGroupDao().deleteAbolishData();
                this.getPubLappSyncGroupDao().insertList(lappSyncGroupPOList);
            }
            if (CollectionUtils.isNotEmpty(lappSyncRecordPOList)) {
                this.getPubLappSyncRecordDao().deleteAbolishData();
                this.getPubLappSyncRecordDao().insertList(lappSyncRecordPOList);
            }
        }
        catch (AbstractQingIntegratedException abstractQingIntegratedException) {
            this.tx.markRollback();
            throw abstractQingIntegratedException;
        }
        catch (SQLException sQLException) {
            this.tx.markRollback();
            throw sQLException;
        }
        finally {
            this.tx.end();
        }
    }

    public PublishOperModelVO loadParentPublishOperModel(String biztag, boolean isEdit, String reftoPublishId, boolean isTimedPush) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException {
        PublishOperModelVO publishOperModelVO = new PublishOperModelVO();
        PublishVO parentPublishVo = new PublishVO();
        String publishId = null;
        if (biztag != null && PublishUtil.isPublish(biztag)) {
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(biztag);
            publishId = biztag;
            if (isEdit) {
                publishOperModelVO.setNoOperValueMap(this.loadPublishOperList(biztag, reftoPublishId, false, isTimedPush));
            } else {
                publishOperModelVO.setNoOperValueMap(this.loadPublishOperList(biztag, reftoPublishId, true, isTimedPush));
            }
        } else if (!isEdit && StringUtils.isNotEmpty((CharSequence)reftoPublishId)) {
            publishId = reftoPublishId;
            publishOperModelVO.setNoOperValueMap(this.loadPublishOperList(null, reftoPublishId, true, false));
        }
        publishOperModelVO.setParentPublishVo(this.loadParentPublishVO(publishId, isEdit));
        return publishOperModelVO;
    }

    public List<ValueTextPair> loadUserByRoles(List<String> roleIds) throws IntegratedRuntimeException {
        ArrayList<ValueTextPair> userList = new ArrayList<ValueTextPair>();
        for (String roleId : roleIds) {
            List<String> userIdList = IntegratedHelper.getUserIdsByRoleId(this.qingContext, this.dbExcuter, roleId);
            for (int i = 0; i < userIdList.size(); ++i) {
                ValueTextPair valueTextPair = new ValueTextPair();
                valueTextPair.setValue(userIdList.get(i));
                valueTextPair.setText(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, userIdList.get(i)));
                userList.add(valueTextPair);
            }
        }
        return userList;
    }

    public void judgePublishOper(String publishId, String dsbPublishId, String scene, String publishOperValueStr) throws PublishNoOperAuthException, AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException {
        if (StringUtils.isNotEmpty((CharSequence)publishId) && !PublishUtil.isPublish(publishId) && StringUtils.isEmpty((CharSequence)dsbPublishId)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)publishOperValueStr)) {
            return;
        }
        int publishOperValue = Integer.parseInt(publishOperValueStr);
        OperCodeEnum operCodeEnum = OperCodeEnum.getByCodeValue(publishOperValue);
        if (operCodeEnum == null) {
            throw new PublishNoOperAuthException();
        }
        this.judgePublishOperAuth(publishId, dsbPublishId, operCodeEnum);
    }

    public boolean judgeNameIsExist(Integer type, String name, String path) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishInfoDao().isNameExist(Integer.parseInt(String.valueOf(type)), name, path);
    }

    protected void verifyPublishInfoWhenUpdate(PublishPO publishPO, String bizTag) throws PublishException, AbstractQingIntegratedException, SQLException {
        boolean isSameSourceNameExist = this.getPublishInfoDao().checkSameSourceNameExist(publishPO, bizTag, false);
        if (isSameSourceNameExist) {
            throw new PublishSameSourceNameDuplicateException();
        }
    }

    protected void verifyPublishInfoWhenSave(String bizTag, VerifyVo verifyVo, PublishPO publishInfo) throws PublishException, AbstractQingIntegratedException, SQLException {
        boolean nameExist = this.getPublishInfoDao().isNameExist(publishInfo.getPublishTargetType(), publishInfo.getName(), publishInfo.getPath(), this.qingContext.getUserId());
        boolean isSameSourceNameExist = this.getPublishInfoDao().checkSameSourceNameExist(publishInfo, bizTag, true);
        verifyVo.setNameExist(nameExist);
        verifyVo.setSameSourceNameExist(isSameSourceNameExist);
        if (nameExist && !isSameSourceNameExist) {
            throw new PublishNameDuplicateException();
        }
        if (isSameSourceNameExist && !publishInfo.isOverwrite()) {
            throw new PublishSameSourceNameDuplicateException();
        }
    }
}

