/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.domain.IPublishSourceDomain;
import com.kingdee.bos.qing.publish.exception.MismatchSourceTypeException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.util.LogUtil;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PublishSourceDomainFactory {
    private static Map<PublishSourceEnum, Constructor<? extends IPublishSourceDomain>> PUBLISH_SOURCE_DOMAIN_CLASS_MAP = new HashMap<PublishSourceEnum, Constructor<? extends IPublishSourceDomain>>();

    PublishSourceDomainFactory() {
    }

    public static IPublishSourceDomain createPublishSourceDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, PublishSourceEnum publishSourceEnum) throws MismatchSourceTypeException {
        Constructor<? extends IPublishSourceDomain> constructor = PUBLISH_SOURCE_DOMAIN_CLASS_MAP.get((Object)publishSourceEnum);
        if (constructor == null) {
            throw new MismatchSourceTypeException("can't confirm SourceType : " + publishSourceEnum.name());
        }
        try {
            return constructor.newInstance(qingContext, dbExcuter, tx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registPublishSourceDomain(PublishSourceEnum publishSource, Class<? extends IPublishSourceDomain> clazz) {
        try {
            Constructor<? extends IPublishSourceDomain> constructor = clazz.getConstructor(QingContext.class, IDBExcuter.class, ITransactionManagement.class);
            PUBLISH_SOURCE_DOMAIN_CLASS_MAP.put(publishSource, constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getPublishSourceName(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, String bizTag, PublishSourceEnum publishSourceEnum) throws SQLException, AbstractQingIntegratedException, MismatchSourceTypeException {
        IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(qingContext, dbExcuter, tx, publishSourceEnum);
        if (publishSourceDomain != null) {
            return publishSourceDomain.getPublishSourceName(bizTag, publishSourceEnum.name());
        }
        return bizTag;
    }

    public static String getPublishSourceGroupName(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, String bizTag, PublishSourceEnum publishSourceEnum) throws SQLException, AbstractQingIntegratedException, MismatchSourceTypeException {
        IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(qingContext, dbExcuter, tx, publishSourceEnum);
        if (publishSourceDomain != null) {
            return publishSourceDomain.getPublishSourceGroupName(bizTag, publishSourceEnum.name());
        }
        return bizTag;
    }

    public static PublishSourceEnum confirmSourceTypeByPublishInfo(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, PublishPO publishInfo) throws AbstractQingIntegratedException, SQLException {
        if (publishInfo == null) {
            return null;
        }
        if (publishInfo.getPublishSourceType() != null) {
            return publishInfo.getPublishSourceType();
        }
        Set<PublishSourceEnum> keyset = PUBLISH_SOURCE_DOMAIN_CLASS_MAP.keySet();
        for (PublishSourceEnum key : keyset) {
            IPublishSourceDomain publishSourceDomain;
            try {
                publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(qingContext, dbExcuter, tx, key);
            }
            catch (MismatchSourceTypeException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)((Object)e));
                continue;
            }
            PublishSourceEnum sourceType = publishSourceDomain.confirmSourceTypeByPublishInfo(publishInfo);
            if (sourceType == null) continue;
            return sourceType;
        }
        if (publishInfo.getSchemaId() == null) {
            return PublishSourceEnum.dashboard;
        }
        return PublishSourceEnum.subject;
    }
}

