/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.publish.AbstractPublishManageService;
import com.kingdee.bos.qing.publish.target.analysiscenter.domain.AnalysisCenterManageDomain;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.List;
import java.util.Map;

public class AnalysisCenterManageService
extends AbstractPublishManageService {
    private AnalysisCenterManageDomain analysisCenterDomain;

    @Override
    protected AnalysisCenterManageDomain getPublishManageDomain() {
        if (this.analysisCenterDomain == null) {
            this.analysisCenterDomain = new AnalysisCenterManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.analysisCenterDomain;
    }

    @BehaviorAssociate(behavior=true)
    public byte[] loadCenterGroup(Map<String, String> params) {
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getPublishManageDomain().loadCenterGroup()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveCenterGroup(Map<String, String> params) {
        String name = params.get("name");
        String centerId1 = params.get("centerId1");
        String centerId2 = params.get("centerId2");
        String centerId3 = params.get("centerId3");
        String centerId4 = params.get("centerId4");
        QingCenterGroupVO centerVO = new QingCenterGroupVO();
        centerVO.setName(name);
        centerVO.setLevelId1(centerId1);
        centerVO.setLevelId2(centerId2);
        centerVO.setLevelId3(centerId3);
        centerVO.setLevelId4(centerId4);
        String addType = params.get("addType");
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getPublishManageDomain().saveCenterGroup(centerVO, addType)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] deleteCenterGroup(Map<String, String> params) {
        List deleteDirRelationIdList = (List)JsonUtil.decodeFromString((String)params.get("arrDeleteRelationId"), List.class);
        try {
            this.getPublishManageDomain().deleteCenterGroup(deleteDirRelationIdList);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] updateCenterGroup(Map<String, String> params) {
        Integer iLevel = Integer.valueOf(params.get("iLevel"));
        String name = params.get("name");
        String centerId1 = params.get("centerId1");
        String centerId2 = params.get("centerId2");
        String centerId3 = params.get("centerId3");
        String centerId4 = params.get("centerId4");
        QingCenterGroupVO centerVO = new QingCenterGroupVO();
        centerVO.setName(name);
        centerVO.setLevelId1(centerId1);
        centerVO.setLevelId2(centerId2);
        centerVO.setLevelId3(centerId3);
        centerVO.setLevelId4(centerId4);
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getPublishManageDomain().updateCenterGroup(centerVO, iLevel)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] loadPublishInfos(Map<String, String> params) {
        try {
            String pathId = params.get("path");
            boolean isPreset = "true".equals(params.get("isPreset"));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getPublishManageDomain().loadPublishInfos(pathId, isPreset)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] loadAllPublishInfos(Map<String, String> params) {
        try {
            boolean isPresetPublish = Boolean.parseBoolean(params.get("isPresetPublish"));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getPublishManageDomain().loadAllPublishInfos(isPresetPublish)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

