/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.publish.model.AbstarctPublishVO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.ACFolderNameDuplicateException;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.AbstractQingCenterVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterMenuVO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisCenterDAO {
    public static final String MY_QING_ANALYSIS_ID = "c81a0135-1157-41a4-8e08-de55179916c1";
    public static final String ADD_SUB = "ADD_SUB";
    private IDBExcuter dbExcuter;
    private QingContext context;
    private static final String EXTREPORT = "extreport";
    private static final String SQUARE = "square";
    private static final String ALL = "all";

    public AnalysisCenterDAO(QingContext context, IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
        this.context = context;
    }

    private boolean checkAddCenterGroupNameExist(QingCenterGroupVO centerVO, String newCenterGoupId, String addType, String userId) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT CR.FID FROM T_QING_CENTER_RELATION CR";
        ArrayList<String> params = new ArrayList<String>(10);
        params.add(userId);
        String centerId1 = centerVO.getLevelId1();
        String centerId2 = centerVO.getLevelId2();
        String centerId3 = centerVO.getLevelId3();
        String centerId4 = centerVO.getLevelId4();
        if (StringUtils.isNotBlank((CharSequence)addType) && ADD_SUB.equals(addType)) {
            if (StringUtils.isNotBlank((CharSequence)centerId3)) {
                sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=?";
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                params.add(newCenterGoupId);
            } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
                sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=?";
                params.add(centerId1);
                params.add(centerId2);
                params.add(newCenterGoupId);
            } else {
                sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=?";
                params.add(centerId1);
                params.add(newCenterGoupId);
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerId4)) {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=? ";
            params.add(centerId1);
            params.add(centerId2);
            params.add(centerId3);
            params.add(newCenterGoupId);
        } else if (StringUtils.isNotBlank((CharSequence)centerId3)) {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? ";
            params.add(centerId1);
            params.add(centerId2);
            params.add(newCenterGoupId);
        } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=?";
            params.add(centerId1);
            params.add(newCenterGoupId);
        } else {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=?";
            params.add(newCenterGoupId);
        }
        return (Boolean)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public void initDefaultGroup(String userId) throws AbstractQingIntegratedException, SQLException {
        boolean existsCenter = (Boolean)this.dbExcuter.query("SELECT 1 FROM T_QING_CENTER WHERE FID=?", new Object[]{MY_QING_ANALYSIS_ID}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
        if (!existsCenter) {
            Object[] params = new Object[]{MY_QING_ANALYSIS_ID, Messages.getMLS((QingContext)this.context, (String)"myAnalysis", (String)"\u6211\u7684\u8f7b\u5206\u6790", (Messages.ProjectName)Messages.ProjectName.QING_THEME)};
            this.dbExcuter.execute("INSERT INTO T_QING_CENTER(FID, FNAME) VALUES(?,?)", params);
        }
        String sql = "SELECT 1 FROM T_QING_CENTER_RELATION WHERE FCREATORID=? AND FCENTERID1=' '";
        boolean exists = (Boolean)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
        if (!exists) {
            Date now = new Date(631123200000L);
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?)";
            this.dbExcuter.execute(sql, new Object[]{this.dbExcuter.genStringId("T_QING_CENTER_RELATION"), userId, MY_QING_ANALYSIS_ID, now, now});
        }
    }

    public List<QingCenterGroupVO> loadCenterGroups(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT CR.FID AS FRELATIONID, C1.FID as FCENTERID1, C1.FNAME as FCENTERNAME1, C2.FID as FCENTERID2, C2.FNAME as FCENTERNAME2, C3.FID as FCENTERID3, C3.FNAME as FCENTERNAME3, C4.FID as FCENTERID4, C4.FNAME as FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  WHERE CR.FCREATORID = ? ORDER BY CR.FCREATETIME ASC ";
        return (List)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<QingCenterGroupVO>>(){

            public List<QingCenterGroupVO> handle(ResultSet rs) throws SQLException {
                QingCenterGroupVO vo = null;
                ArrayList<QingCenterGroupVO> vos = new ArrayList<QingCenterGroupVO>(10);
                while (rs.next()) {
                    vo = new QingCenterGroupVO();
                    vo.setLevelId1(rs.getString("FCENTERID1"));
                    vo.setLevelName1(rs.getString("FCENTERNAME1"));
                    vo.setLevelId2(rs.getString("FCENTERID2"));
                    vo.setLevelName2(rs.getString("FCENTERNAME2"));
                    vo.setLevelId3(rs.getString("FCENTERID3"));
                    vo.setLevelName3(rs.getString("FCENTERNAME3"));
                    vo.setLevelId4(rs.getString("FCENTERID4"));
                    vo.setLevelName4(rs.getString("FCENTERNAME4"));
                    vo.setRelationId(rs.getString("FRELATIONID"));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID4"))) {
                        vo.setId(rs.getString("FCENTERID4"));
                        vo.setName(rs.getString("FCENTERNAME4"));
                    } else if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID3"))) {
                        vo.setId(rs.getString("FCENTERID3"));
                        vo.setName(rs.getString("FCENTERNAME3"));
                    } else if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID2"))) {
                        vo.setId(rs.getString("FCENTERID2"));
                        vo.setName(rs.getString("FCENTERNAME2"));
                    } else {
                        vo.setId(rs.getString("FCENTERID1"));
                        vo.setName(rs.getString("FCENTERNAME1"));
                    }
                    vos.add(vo);
                }
                return vos;
            }
        });
    }

    private String getUniqueQingCenterFID(String groupName) throws AbstractQingIntegratedException, SQLException {
        String sql = "select FID FROM T_QING_CENTER where FNAME=?";
        String sFID = (String)this.dbExcuter.query(sql, new Object[]{groupName}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
        if (sFID == null) {
            sFID = this.dbExcuter.genStringId("T_QING_CENTER");
            sql = "INSERT INTO T_QING_CENTER(FID, FNAME) VALUES(?,?)";
            Object[] params = new Object[]{sFID, groupName};
            this.dbExcuter.execute(sql, params);
        }
        return sFID;
    }

    public QingCenterGroupVO saveCenterGroup(QingCenterGroupVO centerVO, String addType, String userId) throws AbstractQingIntegratedException, ACFolderNameDuplicateException, SQLException {
        String newCenterGoupId = this.getUniqueQingCenterFID(centerVO.getName());
        if (this.checkAddCenterGroupNameExist(centerVO, newCenterGoupId, addType, userId)) {
            throw new ACFolderNameDuplicateException();
        }
        String sRelationId = this.dbExcuter.genStringId("T_QING_CENTER_RELATION");
        Date now = new Date();
        String sql = "";
        ArrayList<Object> params = new ArrayList<Object>(10);
        params.add(sRelationId);
        params.add(userId);
        String centerId1 = centerVO.getLevelId1();
        String centerId2 = centerVO.getLevelId2();
        String centerId3 = centerVO.getLevelId3();
        String centerId4 = centerVO.getLevelId4();
        if (StringUtils.isNotBlank((CharSequence)addType) && ADD_SUB.equals(addType)) {
            if (StringUtils.isNotBlank((CharSequence)centerId3)) {
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                params.add(newCenterGoupId);
                centerVO.setParentId(centerId3);
                centerVO.setLevelId4(newCenterGoupId);
                centerVO.setLevelName4(centerVO.getName());
                sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCENTERID3,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?,?)";
            } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
                params.add(centerId1);
                params.add(centerId2);
                params.add(newCenterGoupId);
                centerVO.setParentId(centerId2);
                centerVO.setLevelId3(newCenterGoupId);
                centerVO.setLevelName3(centerVO.getName());
                sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?)";
            } else {
                params.add(centerId1);
                params.add(newCenterGoupId);
                centerVO.setParentId(centerId1);
                centerVO.setLevelId2(newCenterGoupId);
                centerVO.setLevelName2(centerVO.getName());
                sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?)";
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerId4)) {
            params.add(centerId1);
            params.add(centerId2);
            params.add(centerId3);
            params.add(newCenterGoupId);
            centerVO.setParentId(centerId3);
            centerVO.setLevelId4(newCenterGoupId);
            centerVO.setLevelName4(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCENTERID3,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?,?)";
        } else if (StringUtils.isNotBlank((CharSequence)centerId3)) {
            params.add(centerId1);
            params.add(centerId2);
            params.add(newCenterGoupId);
            centerVO.setParentId(centerId2);
            centerVO.setLevelId3(newCenterGoupId);
            centerVO.setLevelName3(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?)";
        } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
            params.add(centerId1);
            params.add(newCenterGoupId);
            centerVO.setParentId(centerId1);
            centerVO.setLevelId2(newCenterGoupId);
            centerVO.setLevelName2(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?)";
        } else {
            params.add(newCenterGoupId);
            centerVO.setLevelId1(newCenterGoupId);
            centerVO.setLevelName1(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?)";
        }
        params.add(now);
        params.add(now);
        this.dbExcuter.execute(sql, params.toArray());
        centerVO.setRelationId(sRelationId);
        centerVO.setId(newCenterGoupId);
        return centerVO;
    }

    public void deleteCenterGroup(List<String> fidList) throws AbstractQingIntegratedException, SQLException {
        String sqlInFid = "null";
        if (fidList != null && fidList.size() > 0) {
            StringBuilder sqlInFidBuilder = new StringBuilder();
            sqlInFidBuilder.append("?");
            for (int i = 1; i < fidList.size(); ++i) {
                sqlInFidBuilder.append(",?");
            }
            sqlInFid = sqlInFidBuilder.toString();
        }
        ArrayList<String> queryValue = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(fidList)) {
            queryValue.addAll(fidList);
        }
        queryValue.add(this.context.getUserId());
        String sql = "DELETE T_QING_CENTER_RELATION WHERE FID IN (" + sqlInFid + ") and FCREATORID=?";
        this.dbExcuter.execute(sql, queryValue.toArray());
    }

    public Map<String, Object> updateCenterGroup(QingCenterGroupVO centerVO, Integer iLevel) throws ACFolderNameDuplicateException, AbstractQingIntegratedException, SQLException {
        String sFID = this.getUniqueQingCenterFID(centerVO.getName());
        if (this.checkUpdateCenterGroupNameExist(centerVO, sFID, iLevel).booleanValue()) {
            throw new ACFolderNameDuplicateException();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Object> updateParams = new ArrayList<Object>();
        updateParams.add(sFID);
        updateParams.add(new Date());
        updateParams.add(centerVO.getLevelId1());
        String updateSql = "";
        String querySql = "SELECT CR.FID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2, C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON  C1.FID=CR.FCENTERID LEFT JOIN T_QING_CENTER C2 ON  C2.FID=CR.FCENTERID1 LEFT JOIN T_QING_CENTER C3 ON  C3.FID=CR.FCENTERID2 LEFT JOIN T_QING_CENTER C4 ON  C4.FID=CR.FCENTERID3 WHERE CR.FCREATORID = ?";
        ArrayList<String> queryParams = new ArrayList<String>();
        queryParams.add(this.context.getUserId());
        queryParams.add(centerVO.getLevelId1());
        if (iLevel == 4) {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID3=?, FUPDATETIME=? WHERE FCENTERID=? AND FCENTERID1=? AND FCENTERID2=? AND FCENTERID3=? AND FCREATORID=? ";
            updateParams.add(centerVO.getLevelId2());
            updateParams.add(centerVO.getLevelId3());
            updateParams.add(centerVO.getLevelId4());
            querySql = querySql + " AND  CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=?";
            queryParams.add(centerVO.getLevelId2());
            queryParams.add(centerVO.getLevelId3());
            queryParams.add(centerVO.getLevelId4());
        } else if (iLevel == 3) {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID2=?, FUPDATETIME=? WHERE  FCENTERID=? AND FCENTERID1=? AND FCENTERID2=? AND FCREATORID=?";
            updateParams.add(centerVO.getLevelId2());
            updateParams.add(centerVO.getLevelId3());
            querySql = querySql + " AND  CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=?";
            queryParams.add(centerVO.getLevelId2());
            queryParams.add(centerVO.getLevelId3());
        } else if (iLevel == 2) {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID1=?, FUPDATETIME=? WHERE FCENTERID=? AND FCENTERID1=? AND FCREATORID=?";
            updateParams.add(centerVO.getLevelId2());
            querySql = querySql + " AND CR.FCENTERID=? AND CR.FCENTERID1=?";
            queryParams.add(centerVO.getLevelId2());
        } else {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID=?, FUPDATETIME=? WHERE FCENTERID=? AND FCREATORID=?";
            querySql = querySql + " AND CR.FCENTERID=?";
        }
        List updateGroups = (List)this.dbExcuter.query(querySql, queryParams.toArray(), (ResultHandler)new ResultHandler<List<QingCenterGroupVO>>(){

            public List<QingCenterGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<QingCenterGroupVO> groups = new ArrayList<QingCenterGroupVO>(10);
                QingCenterGroupVO centerGroupVO = null;
                while (rs.next()) {
                    centerGroupVO = new QingCenterGroupVO();
                    centerGroupVO.setRelationId(rs.getString("FID"));
                    centerGroupVO.setLevelId1(rs.getString("FCENTERID1"));
                    centerGroupVO.setLevelId2(rs.getString("FCENTERID2"));
                    centerGroupVO.setLevelId3(rs.getString("FCENTERID3"));
                    centerGroupVO.setLevelId4(rs.getString("FCENTERID4"));
                    centerGroupVO.setLevelName1(rs.getString("FCENTERNAME1"));
                    centerGroupVO.setLevelName2(rs.getString("FCENTERNAME2"));
                    centerGroupVO.setLevelName3(rs.getString("FCENTERNAME3"));
                    centerGroupVO.setLevelName4(rs.getString("FCENTERNAME4"));
                    groups.add(centerGroupVO);
                }
                return groups;
            }
        });
        resultMap.put("updateGroups", updateGroups);
        updateParams.add(this.context.getUserId());
        this.dbExcuter.execute(updateSql, updateParams.toArray());
        resultMap.put("newCenterID", sFID);
        return resultMap;
    }

    private Boolean checkUpdateCenterGroupNameExist(QingCenterGroupVO centerVO, String newCenterGroupId, Integer iLevel) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT FID FROM T_QING_CENTER_RELATION WHERE FCREATORID=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.context.getUserId());
        String centerId1 = centerVO.getLevelId1();
        String centerId2 = centerVO.getLevelId2();
        String centerId3 = centerVO.getLevelId3();
        if (iLevel == 4) {
            sqlCheck = sqlCheck + "AND  FCENTERID=? AND FCENTERID1=? AND FCENTERID2=? AND FCENTERID3=? ";
            params.add(centerId1);
            params.add(centerId2);
            params.add(centerId3);
            params.add(newCenterGroupId);
        } else if (iLevel == 3) {
            sqlCheck = sqlCheck + "AND  FCENTERID=? AND FCENTERID1=? AND FCENTERID2=?";
            params.add(centerId1);
            params.add(centerId2);
            params.add(newCenterGroupId);
        } else if (iLevel == 2) {
            sqlCheck = sqlCheck + "AND  FCENTERID=? AND FCENTERID1=?";
            params.add(centerId1);
            params.add(newCenterGroupId);
        } else {
            sqlCheck = sqlCheck + "AND FCENTERID=?";
            params.add(newCenterGroupId);
        }
        return (Boolean)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public List<QingCenterGroupVO> loadPublishedInfos(Set<String> roleIds) throws SQLException, AbstractQingIntegratedException {
        String userId = this.context.getUserId();
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String sql = "SELECT DISTINCT FID, FNAME, FTAGID, FSOURCE, FCREATETIME, DIRCREATETIME, PARENTID, FCREATORID, FCENTERID1, FCENTERNAME1, FCENTERID2, FCENTERNAME2, FCENTERID3, FCENTERNAME3, FCENTERID4, FCENTERNAME4  FROM ( SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, CR.FCREATETIME AS DIRCREATETIME, P.FPATH AS PARENTID, P.FCREATORID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PERMPUBLISH PERM  INNER JOIN T_QING_PUBLISH P ON PERM.FPUBLISHID=P.FID  INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3  WHERE P.FTYPE='1' AND ((PERM.FVIEWERID =? AND PERM.FTYPE='0') OR (PERM.FVIEWERID IN (" + sqlInQuestion + ") AND PERM.FTYPE='1'))  UNION  SELECT P.FID, P.FNAME, P.FTAGID, P.FSOURCE, P.FCREATETIME, CR.FCREATETIME AS DIRCREATETIME, P.FPATH AS PARENTID, P.FCREATORID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P  INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3 \tWHERE  P.FTYPE='1' AND P.FCREATORID=? ";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (CollectionUtils.isNotEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(userId);
        if (IntegratedHelper.isCurrentUserInQingAdminRole(this.context, this.dbExcuter)) {
            sql = sql + " UNION  SELECT P.FID, P.FNAME, P.FTAGID, P.FSOURCE, P.FCREATETIME, CR.FCREATETIME AS DIRCREATETIME, P.FPATH AS PARENTID, P.FCREATORID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P  INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  WHERE CR.FCREATORID = ?  ";
            queryValue.add(IntegratedHelper.getPresetUserId());
        }
        sql = sql + " ) T WHERE T.FID IS NOT NULL ORDER BY T.DIRCREATETIME ASC, T.FCREATETIME ASC";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<QingCenterGroupVO>>(){

            public List<QingCenterGroupVO> handle(ResultSet rs) throws SQLException {
                QingCenterMenuVO centerVO = null;
                QingCenterGroupVO groupVO = null;
                ArrayList<QingCenterGroupVO> vos = new ArrayList<QingCenterGroupVO>();
                while (rs.next()) {
                    QingCenterGroupVO groupParent2;
                    QingCenterGroupVO groupParent1;
                    String publishId = rs.getString("FID");
                    String centerId1 = rs.getString("FCENTERID1");
                    String centerId2 = rs.getString("FCENTERID2");
                    String centerId3 = rs.getString("FCENTERID3");
                    String centerId4 = rs.getString("FCENTERID4");
                    String centerName1 = rs.getString("FCENTERNAME1");
                    String centerName2 = rs.getString("FCENTERNAME2");
                    String centerName3 = rs.getString("FCENTERNAME3");
                    String centerName4 = rs.getString("FCENTERNAME4");
                    centerVO = new QingCenterMenuVO();
                    centerVO.setId(publishId);
                    centerVO.setName(rs.getString("FNAME"));
                    centerVO.setTagId(rs.getString("FTAGID"));
                    centerVO.setSource(rs.getString("FSOURCE"));
                    centerVO.setParentId(rs.getString("PARENTID"));
                    centerVO.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                    centerVO.setOrderPath(publishId);
                    ArrayList<AbstractQingCenterVO> childrens = new ArrayList<AbstractQingCenterVO>();
                    childrens.add(centerVO);
                    groupVO = new QingCenterGroupVO();
                    groupVO.setLevelId1(centerId1);
                    groupVO.setLevelName1(centerName1);
                    groupVO.setLevelId2(centerId2);
                    groupVO.setLevelName2(centerName2);
                    groupVO.setLevelId3(centerId3);
                    groupVO.setLevelName3(centerName3);
                    groupVO.setLevelId4(centerId4);
                    groupVO.setLevelName4(centerName4);
                    groupVO.setRelationId(rs.getString("PARENTID"));
                    if (StringUtils.isNotBlank((CharSequence)centerId4)) {
                        groupVO.setId(centerId4);
                        groupVO.setName(centerName4);
                        groupVO.setChildren(childrens);
                        groupVO.setParentId(centerId3);
                        groupVO.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3 + "/" + centerId4);
                        groupParent1 = new QingCenterGroupVO();
                        groupParent1.setLevelId1(centerId1);
                        groupParent1.setLevelName1(centerName1);
                        groupParent1.setId(centerId1);
                        groupParent1.setName(centerName1);
                        groupParent1.setOrderPath(centerId1);
                        vos.add(groupParent1);
                        groupParent2 = new QingCenterGroupVO();
                        groupParent2.setLevelId1(centerId1);
                        groupParent2.setLevelName1(centerName1);
                        groupParent2.setLevelId2(centerId2);
                        groupParent2.setLevelName2(centerName2);
                        groupParent2.setId(centerId2);
                        groupParent2.setName(centerName2);
                        groupParent2.setParentId(centerId1);
                        groupParent2.setOrderPath(centerId1 + "/" + centerId2);
                        vos.add(groupParent2);
                        QingCenterGroupVO groupParent3 = new QingCenterGroupVO();
                        groupParent3.setLevelId1(centerId1);
                        groupParent3.setLevelName1(centerName1);
                        groupParent3.setLevelId2(centerId2);
                        groupParent3.setLevelName2(centerName2);
                        groupParent3.setLevelId3(centerId3);
                        groupParent3.setLevelName3(centerName3);
                        groupParent3.setId(centerId3);
                        groupParent3.setName(centerName3);
                        groupParent3.setParentId(centerId2);
                        groupParent3.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3);
                        vos.add(groupParent3);
                    } else if (StringUtils.isNotBlank((CharSequence)centerId3)) {
                        groupVO.setId(centerId3);
                        groupVO.setName(centerName3);
                        groupVO.setChildren(childrens);
                        groupVO.setParentId(centerId2);
                        groupVO.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3);
                        groupParent1 = new QingCenterGroupVO();
                        groupParent1.setLevelId1(centerId1);
                        groupParent1.setLevelName1(centerName1);
                        groupParent1.setId(centerId1);
                        groupParent1.setName(centerName1);
                        groupParent1.setOrderPath(centerId1);
                        vos.add(groupParent1);
                        groupParent2 = new QingCenterGroupVO();
                        groupParent2.setLevelId1(centerId1);
                        groupParent2.setLevelName1(centerName1);
                        groupParent2.setLevelId2(centerId2);
                        groupParent2.setLevelName2(centerName2);
                        groupParent2.setId(centerId2);
                        groupParent2.setName(centerName2);
                        groupParent2.setParentId(centerId1);
                        groupParent2.setOrderPath(centerId1 + "/" + centerId2);
                        vos.add(groupParent2);
                    } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
                        groupVO.setId(centerId2);
                        groupVO.setName(centerName2);
                        groupVO.setChildren(childrens);
                        groupVO.setParentId(centerId1);
                        groupVO.setOrderPath(centerId1 + "/" + centerId2);
                        QingCenterGroupVO groupParent = new QingCenterGroupVO();
                        groupParent.setLevelId1(centerId1);
                        groupParent.setLevelName1(centerName1);
                        groupParent.setId(centerId1);
                        groupParent.setName(centerName1);
                        groupParent.setOrderPath(centerId1);
                        vos.add(groupParent);
                    } else {
                        groupVO.setId(centerId1);
                        groupVO.setName(centerName1);
                        groupVO.setChildren(childrens);
                        groupVO.setOrderPath(centerId1);
                    }
                    vos.add(groupVO);
                }
                return vos;
            }
        });
    }

    public List<AbstractQingCenterVO> loadPublishedInfosForDsb(Set<String> roleIds, String sType) throws SQLException, AbstractQingIntegratedException {
        return this.loadPublishedInfosFor(roleIds, sType, false);
    }

    public List<AbstractQingCenterVO> loadPublishedInfosForExtReport(Set<String> roleIds) throws SQLException, AbstractQingIntegratedException {
        return this.loadPublishedInfosFor(roleIds, EXTREPORT, true);
    }

    private List<AbstractQingCenterVO> loadPublishedInfosFor(Set<String> roleIds, String sType, boolean extReportJoin) throws SQLException, AbstractQingIntegratedException {
        String userId = this.context.getUserId();
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String extReportJoinSql = " INNER JOIN T_QING_EXTRPT_INFO E ON P.FTAGID=E.FID";
        String sql = "SELECT DISTINCT FID, FNAME, FTAGID, FSOURCE, FCREATETIME, FCREATORID, FSCHEMAID, FPATH, FCENTERID1, FCENTERNAME1, FCENTERID2, FCENTERNAME2, FCENTERID3, FCENTERNAME3, FCENTERID4, FCENTERNAME4  FROM ( SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PERMPUBLISH PERM  INNER JOIN T_QING_PUBLISH P ON PERM.FPUBLISHID=P.FID " + (extReportJoin ? extReportJoinSql : "") + " INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3  WHERE P.FTYPE='1' AND ((PERM.FVIEWERID =? AND PERM.FTYPE='0') OR (PERM.FVIEWERID IN (" + sqlInQuestion + ") AND PERM.FTYPE='1'))  AND (P.FSOURCE IN( '" + this.getSourceCondition(sType) + "')) UNION  SELECT P.FID, P.FNAME, P.FTAGID, P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P " + (extReportJoin ? extReportJoinSql : "") + " INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3 \tWHERE P.FTYPE='1' AND P.FCREATORID=?  AND (P.FSOURCE IN( '" + this.getSourceCondition(sType) + "'))";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (CollectionUtils.isNotEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(userId);
        if (IntegratedHelper.isCurrentUserInQingAdminRole(this.context, this.dbExcuter)) {
            sql = sql + " UNION  SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER c2 ON cr.FCENTERID1 = c2.FID  LEFT JOIN T_QING_CENTER c3 ON cr.FCENTERID2 = c3.FID  LEFT JOIN T_QING_CENTER c4 ON cr.FCENTERID3 = c4.FID  WHERE CR.FCREATORID = ? AND (P.FSOURCE != '" + PublishSourceEnum.dashboard.name() + "')";
            queryValue.add(IntegratedHelper.getPresetUserId());
        }
        sql = sql + " ) T WHERE T.FID IS NOT NULL ORDER BY T.FCREATETIME DESC";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<AbstractQingCenterVO>>(){

            public List<AbstractQingCenterVO> handle(ResultSet rs) throws SQLException {
                return AnalysisCenterDAO.this.handleResult(rs);
            }
        });
    }

    private String getSourceCondition(String sType) {
        String sourceCondition = PublishSourceEnum.subject.name() + "','" + PublishSourceEnum.bill.name() + "','" + PublishSourceEnum.control.name() + "','" + PublishSourceEnum.report.name();
        if (EXTREPORT.equals(sType)) {
            sourceCondition = PublishSourceEnum.extreport.name();
        } else if (ALL.equals(sType)) {
            sourceCondition = sourceCondition + "','" + PublishSourceEnum.extreport.name();
        }
        return sourceCondition;
    }

    private List<AbstractQingCenterVO> handleResult(ResultSet rs) throws SQLException {
        QingCenterMenuVO centerMenuvo = null;
        QingCenterGroupVO centerGroupvo = null;
        ArrayList<AbstractQingCenterVO> arrCenterGroup = new ArrayList<AbstractQingCenterVO>(10);
        while (rs.next()) {
            QingCenterGroupVO groupParent2;
            QingCenterGroupVO groupParent1;
            centerMenuvo = new QingCenterMenuVO();
            centerMenuvo.setId(rs.getString("FID"));
            centerMenuvo.setName(rs.getString("FNAME"));
            centerMenuvo.setTagId(rs.getString("FTAGID"));
            centerMenuvo.setSource(rs.getString("FSOURCE"));
            centerMenuvo.setSchemaId(rs.getString("FSCHEMAID"));
            centerMenuvo.setUserId(rs.getString("FCREATORID"));
            centerMenuvo.setParentId(rs.getString("FPATH"));
            centerMenuvo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
            centerMenuvo.setPublishTime(rs.getTimestamp("FCREATETIME").getTime());
            String publishId = rs.getString("FID");
            String centerId1 = rs.getString("FCENTERID1");
            String centerId2 = rs.getString("FCENTERID2");
            String centerId3 = rs.getString("FCENTERID3");
            String centerId4 = rs.getString("FCENTERID4");
            String centerName1 = rs.getString("FCENTERNAME1");
            String centerName2 = rs.getString("FCENTERNAME2");
            String centerName3 = rs.getString("FCENTERNAME3");
            String centerName4 = rs.getString("FCENTERNAME4");
            centerMenuvo.setOrderPath(publishId);
            ArrayList<AbstractQingCenterVO> childrens = new ArrayList<AbstractQingCenterVO>();
            childrens.add(centerMenuvo);
            centerGroupvo = new QingCenterGroupVO();
            centerGroupvo.setLevelId1(centerId1);
            centerGroupvo.setLevelName1(centerName1);
            centerGroupvo.setLevelId2(centerId2);
            centerGroupvo.setLevelName2(centerName2);
            centerGroupvo.setLevelId3(centerId3);
            centerGroupvo.setLevelName3(centerName3);
            centerGroupvo.setLevelId4(centerId4);
            centerGroupvo.setLevelName4(centerName4);
            centerGroupvo.setRelationId(rs.getString("FPATH"));
            if (StringUtils.isNotBlank((CharSequence)centerId4)) {
                centerGroupvo.setId(centerId4);
                centerGroupvo.setName(centerName4);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setParentId(centerId3);
                centerGroupvo.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3 + "/" + centerId4);
                groupParent1 = new QingCenterGroupVO();
                groupParent1.setLevelId1(centerId1);
                groupParent1.setLevelName1(centerName1);
                groupParent1.setId(centerId1);
                groupParent1.setName(centerName1);
                groupParent1.setOrderPath(centerId1);
                arrCenterGroup.add(groupParent1);
                groupParent2 = new QingCenterGroupVO();
                groupParent2.setLevelId1(centerId1);
                groupParent2.setLevelName1(centerName1);
                groupParent2.setLevelId2(centerId2);
                groupParent2.setLevelName2(centerName2);
                groupParent2.setId(centerId2);
                groupParent2.setName(centerName2);
                groupParent2.setParentId(centerId1);
                groupParent2.setOrderPath(centerId1 + "/" + centerId2);
                arrCenterGroup.add(groupParent2);
                QingCenterGroupVO groupParent3 = new QingCenterGroupVO();
                groupParent3.setLevelId1(centerId1);
                groupParent3.setLevelName1(centerName1);
                groupParent3.setLevelId2(centerId2);
                groupParent3.setLevelName2(centerName2);
                groupParent3.setLevelId3(centerId3);
                groupParent3.setLevelName3(centerName3);
                groupParent3.setId(centerId3);
                groupParent3.setName(centerName3);
                groupParent3.setParentId(centerId2);
                groupParent3.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3);
                arrCenterGroup.add(groupParent3);
            } else if (StringUtils.isNotBlank((CharSequence)centerId3)) {
                centerGroupvo.setId(centerId3);
                centerGroupvo.setName(centerName3);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setParentId(centerId2);
                centerGroupvo.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3);
                groupParent1 = new QingCenterGroupVO();
                groupParent1.setLevelId1(centerId1);
                groupParent1.setLevelName1(centerName1);
                groupParent1.setId(centerId1);
                groupParent1.setName(centerName1);
                groupParent1.setOrderPath(centerId1);
                arrCenterGroup.add(groupParent1);
                groupParent2 = new QingCenterGroupVO();
                groupParent2.setLevelId1(centerId1);
                groupParent2.setLevelName1(centerName1);
                groupParent2.setLevelId2(centerId2);
                groupParent2.setLevelName2(centerName2);
                groupParent2.setId(centerId2);
                groupParent2.setName(centerName2);
                groupParent2.setParentId(centerId1);
                groupParent2.setOrderPath(centerId1 + "/" + centerId2);
                arrCenterGroup.add(groupParent2);
            } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
                centerGroupvo.setId(centerId2);
                centerGroupvo.setName(centerName2);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setParentId(centerId1);
                centerGroupvo.setOrderPath(centerId1 + "/" + centerId2);
                QingCenterGroupVO groupParent = new QingCenterGroupVO();
                groupParent.setLevelId1(centerId1);
                groupParent.setLevelName1(centerName1);
                groupParent.setId(centerId1);
                groupParent.setName(centerName1);
                groupParent.setOrderPath(centerId1);
                arrCenterGroup.add(groupParent);
            } else {
                centerGroupvo.setId(centerId1);
                centerGroupvo.setName(centerName1);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setOrderPath(centerId1);
            }
            arrCenterGroup.add(centerGroupvo);
        }
        return arrCenterGroup;
    }

    public List<PublishVO> loadPublishInfos(String pathId) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append(" SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH,").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, EXTRPT.FNAME AS EXTRPTNAME").append(" FROM T_QING_PUBLISH P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FPATH=?").append(" ORDER BY P.FCREATETIME");
        Object[] params = new Object[]{1, this.context.getUserId(), pathId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>(10);
                AbstarctPublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setPublishSourceType(rs.getString("FSOURCE"));
                    String publishSourceType = rs.getString("FSOURCE");
                    if (PublishSourceEnum.dashboard.name().equals(publishSourceType) || PublishSourceEnum.subject.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("THEMENAME"));
                    } else if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, AnalysisCenterDAO.this.context, AnalysisCenterDAO.this.dbExcuter));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else if (PublishSourceEnum.extreport.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("EXTRPTNAME"));
                    } else {
                        vo.setPublishSourceName(rs.getString("FTAGID"));
                    }
                    vo.setTagId(rs.getString("FTAGID"));
                    listVO.add((PublishVO)vo);
                }
                return listVO;
            }
        });
        return listVO;
    }

    public String getCatalogId(String userId, String catalogName) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FID FROM T_QING_CENTER C, T_QING_CENTER_RELATION R  WHERE ((C.FID = R.FCENTERID) OR (C.FID = R.FCENTERID1) OR (C.FID = R.FCENTERID2) OR (C.FID = R.FCENTERID3) )  AND R.FCREATORID = ? AND C.FNAME = ?";
        return (String)this.dbExcuter.query(sql, new Object[]{userId, catalogName}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    public List<String> getGroupNameByCenterGroupFid(String fid) throws AbstractQingIntegratedException, SQLException {
        String userId = this.context.getUserId();
        String selectCenterIdSQL = "SELECT FCENTERID, FCENTERID1, FCENTERID2, FCENTERID3 FROM T_QING_CENTER_RELATION WHERE FID = ? AND FCREATORID = ?";
        List centerIds = (List)this.dbExcuter.query(selectCenterIdSQL, new Object[]{fid, userId}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> results = new ArrayList<String>(4);
                if (rs.next()) {
                    String result = null;
                    result = rs.getString("FCENTERID");
                    if (result != null) {
                        results.add(result);
                    }
                    if ((result = rs.getString("FCENTERID1")) != null) {
                        results.add(result);
                    }
                    if ((result = rs.getString("FCENTERID2")) != null) {
                        results.add(result);
                    }
                    if ((result = rs.getString("FCENTERID3")) != null) {
                        results.add(result);
                    }
                }
                return results;
            }
        });
        String selectNameSQL = "SELECT FNAME FROM T_QING_CENTER WHERE FID in (?)";
        String joinCenterIds = StringUtils.join((char)',', (Collection)centerIds);
        return (List)this.dbExcuter.query(selectNameSQL, new Object[]{joinCenterIds}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> results = new ArrayList<String>(4);
                while (rs.next()) {
                    String result = rs.getString("FNAME");
                    if (result == null) continue;
                    results.add(result);
                }
                return results;
            }
        });
    }

    public QingCenterGroupVO getQingCerterCatalog(String fId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FNAME FROM T_QING_CENTER WHERE FID = ?";
        return (QingCenterGroupVO)this.dbExcuter.query(sql, new Object[]{fId}, (ResultHandler)new ResultHandler<QingCenterGroupVO>(){

            public QingCenterGroupVO handle(ResultSet rs) throws SQLException {
                QingCenterGroupVO qingCenterGroupVO = null;
                if (rs.next()) {
                    qingCenterGroupVO = new QingCenterGroupVO();
                    qingCenterGroupVO.setId(rs.getString("FID"));
                    qingCenterGroupVO.setName(rs.getString("FNAME"));
                }
                return qingCenterGroupVO;
            }
        });
    }

    public String loadPublishId(String centerName1, String centerName2, String centerName3, String centerName4, String publishName, String userId, int type, String publishSource) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isBlank((CharSequence)centerName1)) {
            return null;
        }
        String sql = "SELECT PUB.FID FROM T_QING_PUBLISH PUB WHERE PUB.FNAME = ? AND PUB.FCREATORID=? AND PUB.FTYPE=? AND PUB.FPATH= ? AND PUB.FSOURCE != ?";
        String fpath = this.findPublishPathByNames(centerName1, centerName2, centerName3, centerName4, userId);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(publishName);
        params.add(userId);
        params.add(type);
        params.add(fpath);
        params.add(publishSource);
        return (String)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    public String findPublishPathByNames(String centerName1, String centerName2, String centerName3, String centerName4, String userId) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isBlank((CharSequence)centerName1)) {
            return null;
        }
        String sql = "SELECT FID FROM  T_QING_CENTER_RELATION CR WHERE FCREATORID=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(userId);
        ArrayList<String> groupNames = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)centerName4)) {
            groupNames.add(centerName1);
            groupNames.add(centerName2);
            groupNames.add(centerName3);
            groupNames.add(centerName4);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                String centerId2 = groupMap.get(centerName2);
                String centerId3 = groupMap.get(centerName3);
                String centerId4 = groupMap.get(centerName4);
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                params.add(centerId4);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=?";
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerName3)) {
            groupNames.add(centerName1);
            groupNames.add(centerName2);
            groupNames.add(centerName3);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                String centerId2 = groupMap.get(centerName2);
                String centerId3 = groupMap.get(centerName3);
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=' '";
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerName2)) {
            groupNames.add(centerName1);
            groupNames.add(centerName2);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                String centerId2 = groupMap.get(centerName2);
                params.add(centerId1);
                params.add(centerId2);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=' '";
            }
        } else {
            groupNames.add(centerName1);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                params.add(centerId1);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=' '";
            }
        }
        return (String)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    private Map<String, String> findGroupIdByName(List<String> groupNames) throws AbstractQingIntegratedException, SQLException {
        if (groupNames == null || groupNames.size() == 0) {
            return null;
        }
        String sqlInName = "null";
        if (groupNames != null && groupNames.size() > 0) {
            StringBuilder sqlInNameBuilder = new StringBuilder();
            sqlInNameBuilder.append("?");
            for (int i = 1; i < groupNames.size(); ++i) {
                sqlInNameBuilder.append(",?");
            }
            sqlInName = sqlInNameBuilder.toString();
        }
        String sql = "SELECT FID, FNAME FROM T_QING_CENTER WHERE FNAME IN (" + sqlInName + ")";
        return (Map)this.dbExcuter.query(sql, groupNames.toArray(), (ResultHandler)new ResultHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> groupMap = new HashMap<String, String>(4);
                while (rs.next()) {
                    groupMap.put(rs.getString("FNAME"), rs.getString("FID"));
                }
                return groupMap;
            }
        });
    }

    public List<QingCenterGroupVO> loadCenterPresetGroups() throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT CR.FID AS FRELATIONID, C1.FID as FCENTERID1, C1.FNAME as FCENTERNAME1, C2.FID as FCENTERID2, C2.FNAME as FCENTERNAME2, C3.FID as FCENTERID3, C3.FNAME as FCENTERNAME3, C4.FID as FCENTERID4, C4.FNAME as FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  WHERE CR.FCREATORID = ?  ORDER BY CR.FCREATETIME ASC";
        return (List)this.dbExcuter.query(sql, new Object[]{IntegratedHelper.getPresetUserId()}, (ResultHandler)new ResultHandler<List<QingCenterGroupVO>>(){

            public List<QingCenterGroupVO> handle(ResultSet rs) throws SQLException {
                QingCenterGroupVO vo = null;
                ArrayList<QingCenterGroupVO> vos = new ArrayList<QingCenterGroupVO>(10);
                while (rs.next()) {
                    vo = new QingCenterGroupVO();
                    vo.setLevelId1(rs.getString("FCENTERID1"));
                    vo.setLevelName1(rs.getString("FCENTERNAME1"));
                    vo.setLevelId2(rs.getString("FCENTERID2"));
                    vo.setLevelName2(rs.getString("FCENTERNAME2"));
                    vo.setLevelId3(rs.getString("FCENTERID3"));
                    vo.setLevelName3(rs.getString("FCENTERNAME3"));
                    vo.setLevelId4(rs.getString("FCENTERID4"));
                    vo.setLevelName4(rs.getString("FCENTERNAME4"));
                    vo.setPreset(true);
                    vo.setRelationId(rs.getString("FRELATIONID"));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID4"))) {
                        vo.setId(rs.getString("FCENTERID4"));
                        vo.setName(rs.getString("FCENTERNAME4"));
                    } else if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID3"))) {
                        vo.setId(rs.getString("FCENTERID3"));
                        vo.setName(rs.getString("FCENTERNAME3"));
                    } else if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID2"))) {
                        vo.setId(rs.getString("FCENTERID2"));
                        vo.setName(rs.getString("FCENTERNAME2"));
                    } else {
                        vo.setId(rs.getString("FCENTERID1"));
                        vo.setName(rs.getString("FCENTERNAME1"));
                    }
                    vos.add(vo);
                }
                return vos;
            }
        });
    }

    public List<PublishVO> loadPresetPublishInfos(String pathId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, QC.FNAME AS PATHTEXT, ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, EXTRPT.FNAME AS EXTRPTNAME").append(" FROM T_QING_PUBLISH P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" LEFT JOIN T_QING_CENTER QC ON QC.FID = P.FPATH").append(" WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FPATH=?").append(" ORDER BY P.FCREATETIME");
        Object[] params = new Object[]{1, IntegratedHelper.getPresetUserId(), pathId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>();
                AbstarctPublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("FID");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setPublishSourceType(rs.getString("FSOURCE"));
                    String publishSourceType = rs.getString("FSOURCE");
                    if (PublishSourceEnum.dashboard.name().equals(publishSourceType) || PublishSourceEnum.subject.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("THEMENAME"));
                    } else if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, AnalysisCenterDAO.this.context, AnalysisCenterDAO.this.dbExcuter));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else if (PublishSourceEnum.extreport.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("EXTRPTNAME"));
                    } else {
                        vo.setPublishSourceName(rs.getString("FTAGID"));
                    }
                    vo.setTagId(rs.getString("FTAGID"));
                    vo.setPreset(true);
                    listVO.add((PublishVO)vo);
                }
                return listVO;
            }
        });
        return listVO;
    }

    public String findPublishNameByPath(String publishPath) throws AbstractQingIntegratedException, SQLException {
        String pathFullName = "";
        if (StringUtils.isNotBlank((CharSequence)publishPath)) {
            QingCenterGroupVO centerGroup = this.loadCenterGroupByPublishPath(publishPath);
            if (null == centerGroup) {
                return pathFullName;
            }
            if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName4())) {
                pathFullName = centerGroup.getLevelName1() + "/" + centerGroup.getLevelName2() + "/" + centerGroup.getLevelName3() + "/" + centerGroup.getLevelName4();
            } else if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName3())) {
                pathFullName = centerGroup.getLevelName1() + "/" + centerGroup.getLevelName2() + "/" + centerGroup.getLevelName3();
            } else if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName2())) {
                pathFullName = centerGroup.getLevelName1() + "/" + centerGroup.getLevelName2();
            } else if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName1())) {
                pathFullName = centerGroup.getLevelName1();
            }
        }
        return pathFullName;
    }

    public QingCenterGroupVO loadCenterGroupByPublishPath(String path) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT CR.FID AS FRELATIONID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1 , C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3 , C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID WHERE CR.FID = ? ";
        return (QingCenterGroupVO)this.dbExcuter.query(sql, new Object[]{path}, (ResultHandler)new ResultHandler<QingCenterGroupVO>(){

            public QingCenterGroupVO handle(ResultSet rs) throws SQLException {
                QingCenterGroupVO vo = new QingCenterGroupVO();
                while (rs.next()) {
                    vo.setRelationId(rs.getString("FRELATIONID"));
                    vo.setLevelId1(rs.getString("FCENTERID1"));
                    vo.setLevelName1(rs.getString("FCENTERNAME1"));
                    vo.setLevelId2(rs.getString("FCENTERID2"));
                    vo.setLevelName2(rs.getString("FCENTERNAME2"));
                    vo.setLevelId3(rs.getString("FCENTERID3"));
                    vo.setLevelName3(rs.getString("FCENTERNAME3"));
                    vo.setLevelId4(rs.getString("FCENTERID4"));
                    vo.setLevelName4(rs.getString("FCENTERNAME4"));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID4"))) {
                        vo.setId(rs.getString("FCENTERID4"));
                        vo.setName(rs.getString("FCENTERNAME4"));
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID3"))) {
                        vo.setId(rs.getString("FCENTERID3"));
                        vo.setName(rs.getString("FCENTERNAME3"));
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID2"))) {
                        vo.setId(rs.getString("FCENTERID2"));
                        vo.setName(rs.getString("FCENTERNAME2"));
                        continue;
                    }
                    vo.setId(rs.getString("FCENTERID1"));
                    vo.setName(rs.getString("FCENTERNAME1"));
                }
                return vo;
            }
        });
    }

    public PublishVO loadPublishInfo(final String userId, final String fid) throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT FNAME, FID, FTAGID, FTYPE, FPATH, FSOURCE, FCARRYDATA, FCREATETIME, FUPDATETIME FROM T_QING_PUBLISH  WHERE FCREATORID=? AND FID=?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(fid);
        PublishVO vo = (PublishVO)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<PublishVO>(){

            public PublishVO handle(ResultSet rs) throws SQLException {
                PublishVO vo = null;
                if (rs.next()) {
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setTagId(rs.getString("FTAGID"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userId));
                    vo.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    vo.setUpdateTime(rs.getTimestamp("FUPDATETIME").getTime());
                    String publishSourceType = rs.getString("FSOURCE");
                    vo.setPublishSourceType(publishSourceType);
                    vo.setPath(rs.getString("FPATH"));
                }
                return vo;
            }
        });
        if (vo == null) {
            return null;
        }
        QingCenterGroupVO qingCenterGroupVO = this.loadCenterGroupByPublishPath(vo.getPath());
        if (qingCenterGroupVO == null) {
            return vo;
        }
        String pathText = null;
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName1())) {
            pathText = qingCenterGroupVO.getLevelName1();
        }
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName2())) {
            pathText = pathText + "/" + qingCenterGroupVO.getLevelName2();
        }
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName3())) {
            pathText = pathText + "/" + qingCenterGroupVO.getLevelName3();
        }
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName4())) {
            pathText = pathText + "/" + qingCenterGroupVO.getLevelName4();
        }
        vo.setPathText(pathText);
        return vo;
    }

    public void deleteCenterGroupPublishOrder() throws AbstractQingIntegratedException, SQLException {
        String userid = this.context.getUserId();
        String sql = "DELETE T_QING_CENTER_PUBLISH_ORDER WHERE FCREATORID=?";
        this.dbExcuter.execute(sql, new Object[]{userid});
    }

    public void saveCenterGroupPublishOrder(List<String> arrCenterGroupId) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_CENTER_PUBLISH_ORDER(FID,FCREATORID,FPATH,FPATHINDEX) VALUES(?,?,?,?)";
        String userid = this.context.getUserId();
        int index = arrCenterGroupId.size();
        for (String centerGroup : arrCenterGroupId) {
            String sFID = this.dbExcuter.genStringId("T_QING_CENTER_PUBLISH_ORDER");
            Object[] params = new Object[]{sFID, userid, centerGroup, index};
            --index;
            this.dbExcuter.execute(sql, params);
        }
    }

    public Map<String, Integer> loadCenterGroupPublishOrder() throws AbstractQingIntegratedException, SQLException {
        String userid = this.context.getUserId();
        String sql = "SELECT CO.FPATH, CO.FPATHINDEX FROM T_QING_CENTER_PUBLISH_ORDER CO WHERE CO.FCREATORID = ? ";
        return (Map)this.dbExcuter.query(sql, new Object[]{userid}, (ResultHandler)new ResultHandler<Map<String, Integer>>(){

            public Map<String, Integer> handle(ResultSet rs) throws SQLException {
                HashMap<String, Integer> map = new HashMap<String, Integer>(16);
                while (rs.next()) {
                    map.put(rs.getString("FPATH"), rs.getInt("FPATHINDEX"));
                }
                return map;
            }
        });
    }

    public void deleteEmptyCenterGroupByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        String queryPublishCenterGroupsql = "SELECT DISTINCT CR.FID AS FRELATIONID, CR.FCENTERID AS FCENTERID1, CR.FCENTERID1 AS FCENTERID2, CR.FCENTERID2 AS FCENTERID3, CR.FCENTERID3 AS FCENTERID4 FROM T_QING_PUBLISH T JOIN  T_QING_CENTER_RELATION CR ON T.FPATH = CR.FID AND CR.FCREATORID = T.FCREATORID WHERE T.FCREATORID = ?";
        List publishedCenterGroups = (List)this.dbExcuter.query(queryPublishCenterGroupsql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<QingCenterGroupVO>>(){

            public List<QingCenterGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<QingCenterGroupVO> arrCenterGroup = new ArrayList<QingCenterGroupVO>(10);
                QingCenterGroupVO centerGroupVo = null;
                while (rs.next()) {
                    centerGroupVo = new QingCenterGroupVO();
                    centerGroupVo.setRelationId(rs.getString("FRELATIONID"));
                    centerGroupVo.setLevelId1(rs.getString("FCENTERID1"));
                    centerGroupVo.setLevelId2(rs.getString("FCENTERID2"));
                    centerGroupVo.setLevelId3(rs.getString("FCENTERID3"));
                    centerGroupVo.setLevelId4(rs.getString("FCENTERID4"));
                    arrCenterGroup.add(centerGroupVo);
                }
                return arrCenterGroup;
            }
        });
        String queryAllCenterGroupsql = "SELECT CR.FID AS FRELATIONID, CR.FCENTERID AS FCENTERID1, CR.FCENTERID1 AS FCENTERID2, CR.FCENTERID2 AS FCENTERID3, CR.FCENTERID3 AS FCENTERID4 FROM T_QING_CENTER_RELATION CR WHERE CR.FCREATORID = ?";
        List allCenterGroups = (List)this.dbExcuter.query(queryAllCenterGroupsql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<QingCenterGroupVO>>(){

            public List<QingCenterGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<QingCenterGroupVO> arrCenterGroup = new ArrayList<QingCenterGroupVO>(10);
                QingCenterGroupVO centerGroupVo = null;
                while (rs.next()) {
                    centerGroupVo = new QingCenterGroupVO();
                    centerGroupVo.setRelationId(rs.getString("FRELATIONID"));
                    centerGroupVo.setLevelId1(rs.getString("FCENTERID1"));
                    centerGroupVo.setLevelId2(rs.getString("FCENTERID2"));
                    centerGroupVo.setLevelId3(rs.getString("FCENTERID3"));
                    centerGroupVo.setLevelId4(rs.getString("FCENTERID4"));
                    arrCenterGroup.add(centerGroupVo);
                }
                return arrCenterGroup;
            }
        });
        HashSet<String> needKeepRelationIdSet = new HashSet<String>();
        for (QingCenterGroupVO sourceGroup : publishedCenterGroups) {
            for (QingCenterGroupVO targetGroup : allCenterGroups) {
                boolean bGroupNeedKeep = this.checkGroupNeedKeep(sourceGroup, targetGroup);
                if (!bGroupNeedKeep) continue;
                needKeepRelationIdSet.add(targetGroup.getRelationId());
            }
        }
        String sqlInFid = "null";
        if (needKeepRelationIdSet.size() > 0) {
            StringBuilder sqlInFidBuilder = new StringBuilder();
            sqlInFidBuilder.append("?");
            for (int i = 1; i < needKeepRelationIdSet.size(); ++i) {
                sqlInFidBuilder.append(",?");
            }
            sqlInFid = sqlInFidBuilder.toString();
        }
        String deleteEmptySql = "DELETE FROM T_QING_CENTER_RELATION WHERE FID NOT IN(" + sqlInFid + ") AND FCREATORID=? ";
        ArrayList<String> needKeppFidList = new ArrayList<String>(needKeepRelationIdSet);
        needKeppFidList.add(userId);
        this.dbExcuter.execute(deleteEmptySql, needKeppFidList.toArray());
    }

    private boolean checkGroupNeedKeep(QingCenterGroupVO sourceGroup, QingCenterGroupVO targetGroup) {
        return StringUtils.isNotBlank((CharSequence)targetGroup.getLevelId4()) ? targetGroup.getLevelId4().equals(sourceGroup.getLevelId4()) && targetGroup.getLevelId3().equals(sourceGroup.getLevelId3()) && targetGroup.getLevelId2().equals(sourceGroup.getLevelId2()) && targetGroup.getLevelId1().equals(sourceGroup.getLevelId1()) : (StringUtils.isNotBlank((CharSequence)targetGroup.getLevelId3()) ? targetGroup.getLevelId3().equals(sourceGroup.getLevelId3()) && targetGroup.getLevelId2().equals(sourceGroup.getLevelId2()) && targetGroup.getLevelId1().equals(sourceGroup.getLevelId1()) : (StringUtils.isNotBlank((CharSequence)targetGroup.getLevelId2()) ? targetGroup.getLevelId2().equals(sourceGroup.getLevelId2()) && targetGroup.getLevelId1().equals(sourceGroup.getLevelId1()) : targetGroup.getLevelId1().equals(sourceGroup.getLevelId1())));
    }

    public String saveCenterName1(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, null, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId1();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public String saveCenterName2(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, ADD_SUB, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId2();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public String saveCenterName3(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, ADD_SUB, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId3();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public String saveCenterName4(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, ADD_SUB, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId4();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public List<PublishVO> loadAllPresetPublishInfos(String presetUserId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, QC.FNAME AS PATHTEXT, P.FCREATETIME, P.FUPDATETIME,  ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME, EXTRPT.FNAME AS EXTRPTNAME").append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME, P1.FUPDATETIME,").append(" P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA ").append(" FROM T_QING_PUBLISH P1").append(" WHERE P1.FTYPE=? AND P1.FCREATORID=?) P ").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" LEFT JOIN T_QING_CENTER QC ON QC.FID = P.FPATH").append(" ORDER BY P.FCREATETIME DESC");
        Object[] params = new Object[]{1, presetUserId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>();
                HashMap publishSourceGroupIdMap = new HashMap(16);
                AbstarctPublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("FID");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setPublishSourceType(rs.getString("FSOURCE"));
                    String publishSourceType = rs.getString("FSOURCE");
                    ((PublishVO)vo).setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    ((PublishVO)vo).setUpdateTime(rs.getTimestamp("FUPDATETIME").getTime());
                    if (PublishSourceEnum.dashboard.name().equals(publishSourceType) || PublishSourceEnum.subject.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("THEMENAME"));
                        vo.setPublishSourceGroupName(rs.getString("THEMEGROUPNAME"));
                    } else if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, AnalysisCenterDAO.this.context, AnalysisCenterDAO.this.dbExcuter));
                            HashMap<String, String> tagIdTypeMap = new HashMap<String, String>(4);
                            tagIdTypeMap.put("fTagId", rs.getString("FTAGID"));
                            tagIdTypeMap.put("publishSourceType", publishSourceType);
                            publishSourceGroupIdMap.put(fid, tagIdTypeMap);
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else if (PublishSourceEnum.extreport.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("EXTRPTNAME"));
                    } else {
                        vo.setPublishSourceName(rs.getString("FTAGID"));
                    }
                    vo.setTagId(rs.getString("FTAGID"));
                    vo.setPreset(true);
                    listVO.add((PublishVO)vo);
                }
                Map<String, String> publishSourceGroupNameMap = IntegratedHelper.queryFormFullPath(publishSourceGroupIdMap.values(), AnalysisCenterDAO.this.context);
                for (PublishVO publishVO : listVO) {
                    String fTagId;
                    Map publishSourceGroupId = (Map)publishSourceGroupIdMap.get(publishVO.getId());
                    if (MapUtils.isEmpty((Map)publishSourceGroupId) || (fTagId = (String)publishSourceGroupId.get("fTagId")) == null) continue;
                    publishVO.setPublishSourceGroupName(publishSourceGroupNameMap.get(fTagId));
                }
                return listVO;
            }
        });
        return listVO;
    }

    public List<PublishVO> loadAllPublishInfos(String userId) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, P.FCREATETIME, P.FUPDATETIME, ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME, EXTRPT.FNAME AS EXTRPTNAME, TQEG.FNAME AS EXTRPTGROUPNAME ").append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME, P1.FUPDATETIME, ").append(" P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA FROM T_QING_PUBLISH P1").append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? ) P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" LEFT JOIN T_QING_EXTRPT_GROUP TQEG ON TQEG.FID = EXTRPT.FGROUPID").append(" ORDER BY P.FCREATETIME DESC");
        Object[] params = new Object[]{1, userId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>(10);
                HashMap publishSourceGroupIdMap = new HashMap(16);
                AbstarctPublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setPublishSourceType(rs.getString("FSOURCE"));
                    String publishSourceType = rs.getString("FSOURCE");
                    ((PublishVO)vo).setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    ((PublishVO)vo).setUpdateTime(rs.getTimestamp("FUPDATETIME").getTime());
                    if (PublishSourceEnum.dashboard.name().equals(publishSourceType) || PublishSourceEnum.subject.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("THEMENAME"));
                        vo.setPublishSourceGroupName(rs.getString("THEMEGROUPNAME"));
                    } else if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, AnalysisCenterDAO.this.context, AnalysisCenterDAO.this.dbExcuter));
                            HashMap<String, String> tagIdTypeMap = new HashMap<String, String>(4);
                            tagIdTypeMap.put("fTagId", rs.getString("FTAGID"));
                            tagIdTypeMap.put("publishSourceType", publishSourceType);
                            publishSourceGroupIdMap.put(fid, tagIdTypeMap);
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else if (PublishSourceEnum.extreport.name().equals(publishSourceType)) {
                        vo.setPublishSourceName(rs.getString("EXTRPTNAME"));
                        vo.setPublishSourceGroupName(rs.getString("EXTRPTGROUPNAME"));
                    } else {
                        vo.setPublishSourceName(rs.getString("FTAGID"));
                    }
                    vo.setTagId(rs.getString("FTAGID"));
                    listVO.add((PublishVO)vo);
                }
                Map<String, String> publishSourceGroupNameMap = IntegratedHelper.queryFormFullPath(publishSourceGroupIdMap.values(), AnalysisCenterDAO.this.context);
                for (PublishVO publishVO : listVO) {
                    String fTagId;
                    Map publishSourceGroupId = (Map)publishSourceGroupIdMap.get(publishVO.getId());
                    if (MapUtils.isEmpty((Map)publishSourceGroupId) || (fTagId = (String)publishSourceGroupId.get("fTagId")) == null) continue;
                    publishVO.setPublishSourceGroupName(publishSourceGroupNameMap.get(fTagId));
                }
                return listVO;
            }
        });
        return listVO;
    }

    public Map<String, String> loadCenterGroupsByIds(Set<String> ids) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<String, String>(0);
        }
        StringBuilder sqlInIdsBuilder = new StringBuilder();
        sqlInIdsBuilder.append("?");
        for (int i = 1; i < ids.size(); ++i) {
            sqlInIdsBuilder.append(",?");
        }
        String sqlInParam = sqlInIdsBuilder.toString();
        String sql = " SELECT CR.FID AS FRELATIONID, C1.FID as FCENTERID1, C2.FID as FCENTERID2, C3.FID as FCENTERID3, C4.FID as FCENTERID4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  WHERE CR.FID in (" + sqlInParam + ")";
        return (Map)this.dbExcuter.query(sql, ids.toArray(), (ResultHandler)new ResultHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> relationIdToCenterIdMap = new HashMap<String, String>(16);
                while (rs.next()) {
                    String relationId = rs.getString("FRELATIONID");
                    String centerId = StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID4")) ? rs.getString("FCENTERID4") : (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID3")) ? rs.getString("FCENTERID3") : (StringUtils.isNotBlank((CharSequence)rs.getString("FCENTERID2")) ? rs.getString("FCENTERID2") : rs.getString("FCENTERID1")));
                    relationIdToCenterIdMap.put(relationId, centerId);
                }
                return relationIdToCenterIdMap;
            }
        });
    }
}

