/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.analysiscenter.dao.AnalysisCenterDAO;
import com.kingdee.bos.qing.publish.target.analysiscenter.handler.AnalysisCenterSwitchPathAndIdHandler;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterPathModel;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;

public class AnalysisCenterPublishTargetDomain
extends AbstractPublishTargetDomain {
    public static final String PATH_SUFFIX = "_qingcenter";
    private AnalysisCenterDAO analysisCenterDAO;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;

    private ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new AnalysisCenterSwitchPathAndIdHandler(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    private AnalysisCenterDAO getAnalysisCenterDAO() {
        if (this.analysisCenterDAO == null) {
            this.analysisCenterDAO = new AnalysisCenterDAO(this.qingContext, this.dbExcuter);
        }
        return this.analysisCenterDAO;
    }

    public AnalysisCenterPublishTargetDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    @Override
    public PublishPO savePublish(String tag, PublishSourceEnum source, PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        if (publishInfo.getPublishSourceType() != PublishSourceEnum.dashboard) {
            this.updateRefToId(publishInfo);
        }
        return publishInfo;
    }

    @Override
    public void deletePublish(PublishPO info) throws AbstractQingIntegratedException, PublishException {
        if (info.getPublishSourceType() != PublishSourceEnum.dashboard) {
            this.updateRefFullPath(info);
        }
    }

    @Override
    public void updatePublish(int updateType, PublishPO publishInfoNew) throws AbstractQingIntegratedException, PublishException {
        if (publishInfoNew.getPublishSourceType() != PublishSourceEnum.dashboard) {
            this.updateRefToId(publishInfoNew);
        }
    }

    private void updateRefFullPath(PublishPO info) throws AbstractQingIntegratedException {
        try {
            QingCenterGroupVO qingCenterGroupVO = this.getAnalysisCenterDAO().loadCenterGroupByPublishPath(info.getPath());
            if (qingCenterGroupVO != null) {
                QingCenterPathModel qingCenterPathModel = new QingCenterPathModel();
                qingCenterPathModel.setNameSpace(NameSpace.user.toPersistance());
                qingCenterPathModel.setCenterName1(qingCenterGroupVO.getLevelName1());
                qingCenterPathModel.setCenterName2(qingCenterGroupVO.getLevelName2());
                qingCenterPathModel.setCenterName3(qingCenterGroupVO.getLevelName3());
                qingCenterPathModel.setCenterName4(qingCenterGroupVO.getLevelName4());
                qingCenterPathModel.setName(info.getName());
                String publishId = info.getId();
                if (PublishSourceEnum.subject == info.getPublishSourceType() || PublishSourceEnum.extreport == info.getPublishSourceType()) {
                    ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
                    switchPathAndIdHandler.replacePersistentIdToPath(JsonUtil.encodeToString((Object)qingCenterPathModel), publishId, this.qingContext.getUserId());
                }
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    private void updateRefToId(PublishPO publishInfo) throws AbstractQingIntegratedException {
        try {
            String publishId = publishInfo.getId();
            if (PublishSourceEnum.subject == publishInfo.getPublishSourceType() || PublishSourceEnum.extreport == publishInfo.getPublishSourceType()) {
                ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
                String qingCenterGroupName = this.getAnalysisCenterDAO().findPublishNameByPath(publishInfo.getPath());
                String fullPath = qingCenterGroupName + "/" + publishInfo.getName();
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
                QingCenterGroupVO qingCenterGroupVO = this.getAnalysisCenterDAO().loadCenterGroupByPublishPath(publishInfo.getPath());
                QingCenterPathModel qingCenterPathModel = new QingCenterPathModel();
                qingCenterPathModel.setNameSpace(NameSpace.user.toPersistance());
                qingCenterPathModel.setCenterName1(qingCenterGroupVO.getLevelName1());
                qingCenterPathModel.setCenterName2(qingCenterGroupVO.getLevelName2());
                qingCenterPathModel.setCenterName3(qingCenterGroupVO.getLevelName3());
                qingCenterPathModel.setCenterName4(qingCenterGroupVO.getLevelName4());
                qingCenterPathModel.setName(publishInfo.getName());
                switchPathAndIdHandler.replacePersistentPathToId(fullPath, publishId, this.qingContext.getUserId());
                switchPathAndIdHandler.replacePersistentPathToId(fullPathWithNameSpace, publishId, this.qingContext.getUserId());
                switchPathAndIdHandler.replacePersistentPathToId(JsonUtil.encodeToString((Object)qingCenterPathModel), publishId, this.qingContext.getUserId());
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    @Override
    public void overwritePublish(String tag, int updateType, PublishPO publishInfoNew, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
    }

    @Override
    public String loadOrCreatePath(String userId, String pathId, String pathName) throws AbstractQingIntegratedException, SQLException {
        QingCenterPathModel qingCenterPathModel = (QingCenterPathModel)JsonUtil.decodeFromString((String)pathName, QingCenterPathModel.class);
        String centerName1 = qingCenterPathModel.getCenterName1();
        String centerName2 = qingCenterPathModel.getCenterName2();
        String centerName3 = qingCenterPathModel.getCenterName3();
        String centerName4 = qingCenterPathModel.getCenterName4();
        String relationId = this.getAnalysisCenterDAO().findPublishPathByNames(centerName1, centerName2, centerName3, centerName4, userId);
        if (relationId == null) {
            QingCenterGroupVO centerInfo = new QingCenterGroupVO();
            centerInfo.setName(centerName1);
            String centerId1 = null;
            String centerId2 = null;
            String centerId3 = null;
            String centerId4 = null;
            centerId1 = this.getAnalysisCenterDAO().saveCenterName1(centerInfo, userId);
            if (centerName2 != null) {
                centerInfo.setLevelId1(centerId1);
                centerInfo.setName(centerName2);
                centerId2 = this.getAnalysisCenterDAO().saveCenterName2(centerInfo, userId);
                if (centerName3 != null) {
                    centerInfo.setLevelId2(centerId2);
                    centerInfo.setName(centerName3);
                    centerId3 = this.getAnalysisCenterDAO().saveCenterName3(centerInfo, userId);
                    if (centerName4 != null) {
                        centerInfo.setLevelId3(centerId3);
                        centerInfo.setName(centerName4);
                        centerId4 = this.getAnalysisCenterDAO().saveCenterName4(centerInfo, userId);
                    }
                }
            }
            relationId = this.getAnalysisCenterDAO().findPublishPathByNames(centerName1, centerName2, centerName3, centerName4, userId);
        }
        return relationId;
    }

    @Override
    public String loadPathNameByPath(String path, String publishId) throws AbstractQingIntegratedException, SQLException {
        String pathName = "";
        QingCenterGroupVO qingCenterGroupVO = this.getAnalysisCenterDAO().loadCenterGroupByPublishPath(path);
        if (qingCenterGroupVO != null) {
            QingCenterPathModel qingCenterPathModel = new QingCenterPathModel();
            qingCenterPathModel.setCenterName1(qingCenterGroupVO.getLevelName1());
            qingCenterPathModel.setCenterName2(qingCenterGroupVO.getLevelName2());
            qingCenterPathModel.setCenterName3(qingCenterGroupVO.getLevelName3());
            qingCenterPathModel.setCenterName4(qingCenterGroupVO.getLevelName4());
            if (qingCenterPathModel.getCenterName1() != null) {
                pathName = pathName + qingCenterPathModel.getCenterName1();
            }
            if (qingCenterPathModel.getCenterName2() != null) {
                pathName = pathName + "/" + qingCenterPathModel.getCenterName2();
            }
            if (qingCenterPathModel.getCenterName3() != null) {
                pathName = pathName + "/" + qingCenterPathModel.getCenterName3();
            }
            if (qingCenterPathModel.getCenterName4() != null) {
                pathName = pathName + "/" + qingCenterPathModel.getCenterName4();
            }
            pathName = Messages.getMLS((QingContext)this.qingContext, (String)"qingAnalysisCenter", (String)"\u8f7b\u5206\u6790\u4e2d\u5fc3", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + pathName;
        }
        return pathName;
    }

    @Override
    public String loadPathNamePOByPathId(String pathId) throws AbstractQingIntegratedException, SQLException {
        QingCenterGroupVO qingCenterGroupVO = this.getAnalysisCenterDAO().loadCenterGroupByPublishPath(pathId);
        if (qingCenterGroupVO != null) {
            QingCenterPathModel qingCenterPathModel = new QingCenterPathModel();
            qingCenterPathModel.setCenterName1(qingCenterGroupVO.getLevelName1());
            qingCenterPathModel.setCenterName2(qingCenterGroupVO.getLevelName2());
            qingCenterPathModel.setCenterName3(qingCenterGroupVO.getLevelName3());
            qingCenterPathModel.setCenterName4(qingCenterGroupVO.getLevelName4());
            return JsonUtil.encodeToString((Object)qingCenterPathModel);
        }
        return null;
    }
}

