/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter.handler;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PublishInfoWithPersonName;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.analysiscenter.dao.AnalysisCenterDAO;
import com.kingdee.bos.qing.publish.target.analysiscenter.domain.AnalysisCenterRuntimeDomain;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.AnalysisCenterException;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.AbstractQingCenterVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterMenuVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterPathModel;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnalysisCenterSwitchPathAndIdHandler
extends AbstractSwitchPathAndIdHandler {
    private AnalysisCenterDAO analysisCenterDAO;
    private PublishInfoDao publishInfoDao;
    private AnalysisCenterRuntimeDomain analysisCenterRuntimeDomain;

    public AnalysisCenterSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        super(context, tx, dbExcuter);
    }

    private AnalysisCenterDAO getAnalysisCenterDAO() {
        if (this.analysisCenterDAO == null) {
            this.analysisCenterDAO = new AnalysisCenterDAO(this.context, this.dbExcuter);
        }
        return this.analysisCenterDAO;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private AnalysisCenterRuntimeDomain getAnalysisCenterRuntimeDomain() {
        if (this.analysisCenterRuntimeDomain == null) {
            this.analysisCenterRuntimeDomain = new AnalysisCenterRuntimeDomain(this.context, this.tx, this.dbExcuter, null);
        }
        return this.analysisCenterRuntimeDomain;
    }

    @Override
    public String switchRefPathToId(String refPath, String name, String userId) throws AbstractQingIntegratedException, SQLException {
        return this.getAnalysisCenterDAO().loadPublishId(refPath, null, null, null, name, userId, 1, PublishSourceEnum.dashboard.toString());
    }

    @Override
    public String switchRefIdToPath(String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
        if (publishPO != null) {
            String publishName = publishPO.getName();
            String fId = publishPO.getPath();
            String nameSpace = publishPO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            QingCenterGroupVO qingCenterGroupVO = this.getAnalysisCenterDAO().loadCenterGroupByPublishPath(fId);
            QingCenterPathModel qingCenterPathModel = new QingCenterPathModel();
            qingCenterPathModel.setNameSpace(nameSpace);
            qingCenterPathModel.setCenterName1(qingCenterGroupVO.getLevelName1());
            qingCenterPathModel.setCenterName2(qingCenterGroupVO.getLevelName2());
            qingCenterPathModel.setCenterName3(qingCenterGroupVO.getLevelName3());
            qingCenterPathModel.setCenterName4(qingCenterGroupVO.getLevelName4());
            qingCenterPathModel.setName(publishName);
            return JsonUtil.encodeToString((Object)qingCenterPathModel);
        }
        return null;
    }

    @Override
    public void replacePersistentPathToId(String refPath, String refId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefPathToId(RefTypeEnum.qingcenter, refPath, refId, userId);
    }

    @Override
    public void replacePersistentIdToPath(String refPath, String refToId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefIdToPath(RefTypeEnum.qingcenter, refPath, refToId, userId);
    }

    @Override
    public boolean RefIsPreset(String refToId) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
        if (publishInfo != null) {
            return publishInfo.isPreset();
        }
        return false;
    }

    @Override
    public String switchRefPathToId(String fullPath, String userId) throws AbstractQingIntegratedException, SQLException {
        QingCenterPathModel qingCenterPathModel = (QingCenterPathModel)JsonUtil.decodeFromString((String)fullPath, QingCenterPathModel.class);
        if (NameSpace.system.toPersistance().equals(qingCenterPathModel.getNameSpaceWithSign()) && IntegratedHelper.isCurrentUserInQingAdminRole(this.context, this.dbExcuter)) {
            userId = IntegratedHelper.getPresetUserId();
        }
        String centerName1 = qingCenterPathModel.getCenterName1();
        String centerName2 = qingCenterPathModel.getCenterName2();
        String centerName3 = qingCenterPathModel.getCenterName3();
        String centerName4 = qingCenterPathModel.getCenterName4();
        String publishId = this.getAnalysisCenterDAO().loadPublishId(centerName1, centerName2, centerName3, centerName4, qingCenterPathModel.getName(), userId, 1, PublishSourceEnum.dashboard.toString());
        if (publishId == null) {
            publishId = this.getAuthorizedPublish(centerName1, centerName2, centerName3, centerName4, qingCenterPathModel.getName());
        }
        return publishId;
    }

    @Override
    public String createEmptyPath() {
        QingCenterPathModel qingCenterPathModel = new QingCenterPathModel();
        qingCenterPathModel.setNameSpace(NameSpace.user.toPersistance());
        String groupHasDeleted = this.getGroupHasDeleted();
        String publishHasDeleted = this.getPublishHasDeleted();
        qingCenterPathModel.setCenterName1(groupHasDeleted);
        qingCenterPathModel.setCenterName2(groupHasDeleted);
        qingCenterPathModel.setCenterName3(groupHasDeleted);
        qingCenterPathModel.setCenterName4(groupHasDeleted);
        qingCenterPathModel.setName(publishHasDeleted);
        return JsonUtil.encodeToString((Object)qingCenterPathModel);
    }

    private String getAuthorizedPublish(String centerName1, String centerName2, String centerName3, String centerName4, String publishName) throws AbstractQingIntegratedException {
        if (publishName == null) {
            return null;
        }
        try {
            Map<String, Object> analysisCenterGroup = this.getAnalysisCenterRuntimeDomain().loadAnalysisCenterGroupForDsb("all");
            if (analysisCenterGroup != null) {
                Object qingCenterGroup = analysisCenterGroup.get("qingCenterGroup");
                Object qingPublish = analysisCenterGroup.get("publish");
                if (qingCenterGroup == null || qingPublish == null) {
                    return null;
                }
                List groupVOs = (List)qingCenterGroup;
                List publishInfos = (List)qingPublish;
                for (PublishInfoWithPersonName publishInfo : publishInfos) {
                    QingCenterMenuVO qingCenterMenuVO = publishInfo.getQingCenterMenuVO();
                    if (qingCenterMenuVO == null || !publishName.equals(qingCenterMenuVO.getName())) continue;
                    for (QingCenterGroupVO groupVO : groupVOs) {
                        List<AbstractQingCenterVO> qingCenterVOList = this.findAllGroupVO(groupVO);
                        for (AbstractQingCenterVO qingCenterVO : qingCenterVOList) {
                            if (!this.isSameGroup(centerName1, centerName2, centerName3, centerName4, (QingCenterGroupVO)qingCenterVO)) continue;
                            return qingCenterMenuVO.getId();
                        }
                    }
                }
            }
        }
        catch (AnalysisCenterException e) {
            LogUtil.error((String)"Qing get all user authorized publish info failed when import dashboard", (Throwable)((Object)e));
        }
        return null;
    }

    private List<AbstractQingCenterVO> findAllGroupVO(QingCenterGroupVO groupVO) {
        ArrayList<AbstractQingCenterVO> list = new ArrayList<AbstractQingCenterVO>(10);
        list.add(groupVO);
        if (!groupVO.getChildren().isEmpty()) {
            for (AbstractQingCenterVO qingCenterVO : groupVO.getChildren()) {
                list.addAll(this.findAllGroupVO((QingCenterGroupVO)qingCenterVO));
            }
        }
        return list;
    }

    private boolean isSameGroup(String centerName1, String centerName2, String centerName3, String centerName4, QingCenterGroupVO groupVO) {
        return this.sameString(centerName1, groupVO.getLevelName1()) && this.sameString(centerName2, groupVO.getLevelName2()) && this.sameString(centerName3, groupVO.getLevelName3()) && this.sameString(centerName4, groupVO.getLevelName4());
    }

    private boolean sameString(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null) {
            return str1.equals(str2);
        }
        return false;
    }
}

