/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntegratedHelper {
    private static IIntegratedHelperStrategy newInstance(QingContext qingContext, IDBExcuter dbExcuter) {
        IIntegratedHelperStrategy instance = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
        if (instance instanceof IQingContextable) {
            ((IQingContextable)instance).setQingContext(qingContext);
        }
        if (instance instanceof IDBAccessable) {
            ((IDBAccessable)instance).setDbExcuter(dbExcuter);
        }
        return instance;
    }

    public static String getUserName(QingContext qingContext, IDBExcuter dbExcuter, String userId) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getUserName(userId);
    }

    public static String getRoleName(QingContext qingContext, IDBExcuter dbExcuter, String roleId) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getRoleName(roleId);
    }

    public static Set<String> getUserRoleIds(QingContext qingContext, IDBExcuter dbExcuter, String userId) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getUserRoleIds(userId);
    }

    public static Set<String> getUserRoleIds(QingContext qingContext, IDBExcuter dbExcuter) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getUserRoleIds();
    }

    public static boolean isNormalUser(QingContext qingContext, IDBExcuter dbExcuter, String userId) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.isNormalUser(userId);
    }

    public static List<String> getUserIdsByRoleId(QingContext qingContext, IDBExcuter dbExcuter, String roleId) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getUserIdsByRoleId(roleId);
    }

    public static List<String> getValidUserIds(QingContext qingContext, IDBExcuter dbExcuter, List<String> userIds) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getValidUserIds(userIds);
    }

    public static List<String> getValidRoleIds(QingContext qingContext, IDBExcuter dbExcuter, List<String> roleIds) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getValidRoleIds(roleIds);
    }

    public static List<String> getUserNames(QingContext qingContext, IDBExcuter dbExcuter, List<String> userIds) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.getUserNames(userIds);
    }

    public static boolean checkMapPermission(QingContext qingContext) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, null);
        return instance.checkMapPermission(qingContext);
    }

    public static boolean checkExtreportPermission(QingContext qingContext) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, null);
        return instance.checkExtreportPermission(qingContext);
    }

    public static boolean checkMacroPermission(QingContext qingContext) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, null);
        return instance.checkMacroPermission(qingContext);
    }

    public static boolean checkMacroPermission(QingContext qingContext, String appId) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, null);
        return instance.checkMacroPermission(qingContext, appId);
    }

    public static boolean checkDBManagePermission(QingContext qingContext, String appId) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, null);
        return instance.checkDBManagePermission(qingContext, appId);
    }

    public static boolean isInRole(QingContext qingContext, IDBExcuter dbExcuter, String checkRoleId) throws IntegratedRuntimeException {
        boolean isInRole = false;
        Set<String> roleIds = IntegratedHelper.getUserRoleIds(qingContext, dbExcuter);
        if (roleIds != null) {
            isInRole = roleIds.contains(checkRoleId);
        }
        return isInRole;
    }

    public static boolean isInRole(QingContext qingContext, IDBExcuter dbExcuter, String checkRoleId, String userId) throws IntegratedRuntimeException {
        boolean isInRole = false;
        Set<String> roleIds = IntegratedHelper.getUserRoleIds(qingContext, dbExcuter, userId);
        if (roleIds != null) {
            isInRole = roleIds.contains(checkRoleId);
        }
        return isInRole;
    }

    public static boolean isCurrentUserInQingAdminRole(QingContext qingContext, IDBExcuter dbExcuter) throws IntegratedRuntimeException {
        return IntegratedHelper.isInRole(qingContext, dbExcuter, IntegratedHelper.getQingAdminRoleID());
    }

    public static boolean isUserInQingAdminRole(QingContext qingContext, IDBExcuter dbExcuter, String userId) throws IntegratedRuntimeException {
        return IntegratedHelper.isInRole(qingContext, dbExcuter, IntegratedHelper.getQingAdminRoleID(), userId);
    }

    public static String getPresetUserId() {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(null, null);
        return instance.getPresetUserId();
    }

    public static String getQingAdminRoleID() {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(null, null);
        return instance.getQingAdminRoleID();
    }

    public static String queryFormDisplayName(String formId, String publishSourceType, QingContext qingContext, IDBExcuter dbExcuter) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, dbExcuter);
        return instance.queryFormDisplayName(formId, publishSourceType);
    }

    public static String queryFormFullPath(String formId, String publishSourceType, QingContext qingContext) throws IntegratedRuntimeException {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, null);
        return instance.queryEntityFullPath(formId, publishSourceType);
    }

    public static Map<String, String> queryFormFullPath(Collection<Map<String, String>> formIds, QingContext qingContext) {
        IIntegratedHelperStrategy instance = IntegratedHelper.newInstance(qingContext, null);
        return instance.queryEntityFullPath(formIds);
    }

    public static String getJobId(String userId) {
        return null;
    }

    public static List<String> getJobIds(List<String> userIds) {
        return null;
    }
}

