/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.macro.strategy.IMacroCheckPermission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MacroCheckPermissionUtil {
    public static boolean checkDBConnectionExistOrNot(List<DBConnection> dbConnections, String dbConnectionId) {
        boolean isDBConnectionIdExist = false;
        for (DBConnection db : dbConnections) {
            if (!db.getId().equals(dbConnectionId)) continue;
            isDBConnectionIdExist = true;
            break;
        }
        return isDBConnectionIdExist;
    }

    public static Set<String> getConnectionIds(List<DBConnection> dbConnections) {
        HashSet<String> connIds = new HashSet<String>(16);
        for (DBConnection dbConnection : dbConnections) {
            connIds.add(dbConnection.getId());
        }
        return connIds;
    }

    public static boolean checkDBCenterSourcePermission(IMacroCheckPermission macroCheckPermission, String modifierId) {
        return macroCheckPermission == null || macroCheckPermission.checkDBCenterSourcePermission(modifierId);
    }

    public static boolean macroCheckDBCenterSourceNoPermission(IMacroCheckPermission macroCheckPermission, DBConnection targetDBInfo, String modifierId) {
        return targetDBInfo.isDBCenterSource() && macroCheckPermission != null && !macroCheckPermission.checkDBCenterSourcePermission(modifierId);
    }
}

