/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.format;

import com.kingdee.bos.qing.common.format.DateFormater;
import com.kingdee.bos.qing.common.format.NumberFormater;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import java.math.BigDecimal;
import java.util.Calendar;

public class Formater {
    private String _formatString;
    private II18nContext _i18nCtx;
    private DateFormater _dateFormater;
    private NumberFormater _numberFormater;

    public Formater() {
    }

    public Formater(String formatString) {
        this.setFormatString(formatString);
    }

    public void setFormatString(String formatString) {
        this._formatString = formatString;
        this.reset();
    }

    public void setI18nContext(II18nContext i18nCtx) {
        this._i18nCtx = i18nCtx;
        this.reset();
    }

    private void reset() {
        this._dateFormater = null;
        this._numberFormater = null;
    }

    public String format(Object value) {
        if (value instanceof Calendar) {
            return this.format((Calendar)value, 0);
        }
        if (value instanceof BigDecimal) {
            if (this._numberFormater == null) {
                this._numberFormater = new NumberFormater(this._formatString);
            }
            return this._numberFormater.format((BigDecimal)value);
        }
        if (this._formatString.indexOf(64) >= 0) {
            return this._formatString.replaceAll("@", value.toString());
        }
        return value.toString();
    }

    public String format(Calendar value, int datePart) {
        if (this._dateFormater == null) {
            this._dateFormater = new DateFormater(this._i18nCtx);
            this._dateFormater.setFormatString(this._formatString);
        }
        return this._dateFormater.format(value, datePart);
    }
}

