/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.manage;

import com.kingdee.bos.qing.common.framework.manage.AbstractClientCache;
import com.kingdee.bos.qing.common.framework.model.server.ServerRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClientCallManager
extends AbstractClientCache {
    private static final String CLIENT_CALL_WORKING_KEY_PREFIX = ".Timestamp";
    private static final String CLIENT_CALL_STOP_WORKING_KEY_PREFIX = ".StopWoring";
    private static final String CLIENT_CALL_CANCELED_KEY_PREFIX = ".CallCanceled";
    private static final String CLIENT_RELATIVE_CLIENT_KEY_PREFIX = "RelativeClients";

    private static String getCallWorkingStatusKey(ServerRequestInvokeContext.CheckerName checkerName, String callID) {
        return callID + "." + (Object)((Object)checkerName) + CLIENT_CALL_WORKING_KEY_PREFIX;
    }

    public static boolean isCallWorkingInServer(ServerRequestInvokeContext.CheckerName checkerName, String clientID, String callID, boolean emptyReturnValue) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callWorkingStatusKey = ClientCallManager.getCallWorkingStatusKey(checkerName, callID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        String status = globalQingSession.hGet(cacheKey, callWorkingStatusKey);
        long currentTimeMillis = System.currentTimeMillis();
        if (status != null) {
            long lastVisitTimeStap = Long.parseLong(status);
            return currentTimeMillis - lastVisitTimeStap <= 60000L;
        }
        return emptyReturnValue;
    }

    public static void setCallWorkingInServer(ServerRequestInvokeContext.CheckerName checkerName, String clientID, String callID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callWorkingStatusKey = ClientCallManager.getCallWorkingStatusKey(checkerName, callID);
        long lastVisitTimestap = System.currentTimeMillis();
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        globalQingSession.hSet(cacheKey, callWorkingStatusKey, lastVisitTimestap + "");
    }

    public static void clearCallWorkingStatus(ServerRequestInvokeContext.CheckerName checkerName, String clientID, String callID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callWorkingStatusKey = ClientCallManager.getCallWorkingStatusKey(checkerName, callID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        globalQingSession.hRemove(cacheKey, callWorkingStatusKey);
    }

    private static String getCallCanceledStatusKey(String callID) {
        return callID + CLIENT_CALL_CANCELED_KEY_PREFIX;
    }

    public static void setCallCanceled(String clientID, String callID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callCanceledStatusKey = ClientCallManager.getCallCanceledStatusKey(callID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        globalQingSession.hSet(cacheKey, callCanceledStatusKey, "TRUE");
    }

    public static boolean isCallCanceled(String clientID, String callID, Map<String, Boolean> callsCanceled) {
        Boolean isClientClosed;
        if (callsCanceled != null && (isClientClosed = callsCanceled.get(callID)) != null) {
            return isClientClosed;
        }
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callCanceledStatusKey = ClientCallManager.getCallCanceledStatusKey(callID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        String status = globalQingSession.hGet(cacheKey, callCanceledStatusKey);
        boolean isCanceled = "TRUE".equals(status);
        if (callsCanceled != null) {
            callsCanceled.put(callID, isCanceled);
        }
        return isCanceled;
    }

    public static void clearCallCanceledStatus(String clientID, String callID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callCanceledStatusKey = ClientCallManager.getCallCanceledStatusKey(callID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        globalQingSession.hRemove(cacheKey, callCanceledStatusKey);
    }

    public static void setCallResult(ServerRemoteCallMessage messageForClient) {
        ClientCallManager.setCallStopWoringStatus(messageForClient.getClientID(), messageForClient.getCallID());
        String cacheKey = ClientCallManager.getCacheKey(messageForClient.getClientID());
        LogUtil.info("setCallResult cacheKey:" + cacheKey + " CallID: " + messageForClient.getCallID());
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        globalQingSession.hSetCache(cacheKey, messageForClient);
    }

    public static ServerRemoteCallMessage getCallResult(String clientID, String callID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        return globalQingSession.hGetCache(cacheKey, ServerRemoteCallMessage.getCacheKey(callID), ServerRemoteCallMessage.class);
    }

    public static void clearCallResult(String clientID, String callID) {
        LogUtil.info("clearCallResult cacheKey:" + clientID + " CallID: " + callID);
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        globalQingSession.hRemove(cacheKey, ServerRemoteCallMessage.getCacheKey(callID));
    }

    private static String getCallStopWorkingStatusKey(ServerRequestInvokeContext.CheckerName checkerName, String callID) {
        return callID + "." + (Object)((Object)checkerName) + CLIENT_CALL_STOP_WORKING_KEY_PREFIX;
    }

    public static void setCallStopWoringStatus(String clientID, String callID) {
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callStopWorkingStatusKey = ClientCallManager.getCallStopWorkingStatusKey(ServerRequestInvokeContext.CheckerName.Web, callID);
        globalQingSession.hSet(cacheKey, callStopWorkingStatusKey, "TRUE");
        callStopWorkingStatusKey = ClientCallManager.getCallStopWorkingStatusKey(ServerRequestInvokeContext.CheckerName.RPCServer, callID);
        globalQingSession.hSet(cacheKey, callStopWorkingStatusKey, "TRUE");
    }

    public static boolean isCallStopWorkingStatus(ServerRequestInvokeContext.CheckerName checkerName, String clientID, String callID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callStopWorkingStatusKey = ClientCallManager.getCallStopWorkingStatusKey(checkerName, callID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        String status = globalQingSession.hGet(cacheKey, callStopWorkingStatusKey);
        return "TRUE".equals(status);
    }

    public static void clearCallStopWorkingStatus(ServerRequestInvokeContext.CheckerName checkerName, String clientID, String callID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String callStopWorkingStatusKey = ClientCallManager.getCallStopWorkingStatusKey(checkerName, callID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        globalQingSession.hRemove(cacheKey, callStopWorkingStatusKey);
    }

    public static void setCallFinish(String clientID, String callID) {
        ClientCallManager.clearCallCanceledStatus(clientID, callID);
        ClientCallManager.clearCallResult(clientID, callID);
    }

    private static String getRelativeClientIDKey(String clientID) {
        return clientID + "." + CLIENT_RELATIVE_CLIENT_KEY_PREFIX;
    }

    public static Set<String> getRelativeClientIDs(String clientID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String relativeClientIDKey = ClientCallManager.getRelativeClientIDKey(clientID);
        IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
        String value = globalQingSession.hGet(cacheKey, relativeClientIDKey);
        if (value == null) {
            return null;
        }
        return JsonUtil.decodeFromString(value, HashSet.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRelativeClientIDs(String clientID, String relativeClientID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String relativeClientIDKey = ClientCallManager.getRelativeClientIDKey(clientID);
        ILock lock = null;
        try {
            lock = LockFactory.createGlobalLock(relativeClientIDKey);
            lock.lock();
            IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
            String value = globalQingSession.hGet(cacheKey, relativeClientIDKey);
            HashSet<String> relativeClientIDs = new HashSet<String>();
            if (value != null) {
                Set oldRelativeClientIDs = JsonUtil.decodeFromString(value, HashSet.class);
                relativeClientIDs.addAll(oldRelativeClientIDs);
            }
            relativeClientIDs.add(relativeClientID);
            globalQingSession.hSet(cacheKey, relativeClientIDKey, JsonUtil.encodeToString(relativeClientIDs));
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRelativeClientIDs(String clientID, String relativeClientID) {
        String cacheKey = ClientCallManager.getCacheKey(clientID);
        String relativeClientIDKey = ClientCallManager.getRelativeClientIDKey(clientID);
        ILock lock = null;
        try {
            lock = LockFactory.createGlobalLock(relativeClientIDKey);
            IGlobalQingSession globalQingSession = ClientCallManager.getGlobalQingSession();
            String value = globalQingSession.hGet(cacheKey, relativeClientIDKey);
            HashSet relativeClientIDs = new HashSet();
            if (value != null) {
                Set oldRelativeClientIDs = JsonUtil.decodeFromString(value, HashSet.class);
                relativeClientIDs.addAll(oldRelativeClientIDs);
            }
            relativeClientIDs.remove(relativeClientID);
            if (relativeClientIDs.isEmpty()) {
                globalQingSession.hRemove(cacheKey, relativeClientIDKey);
            } else {
                globalQingSession.hSet(cacheKey, relativeClientIDKey, JsonUtil.encodeToString(relativeClientIDs));
            }
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }
}

