/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.manage;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.IClientClosedListener;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientStateListenerMgr {
    private static final ClientStateListenerMgr instance = new ClientStateListenerMgr();
    private Map<String, IClientClosedListener> clientStateListeners = new ConcurrentHashMap<String, IClientClosedListener>(10);

    private ClientStateListenerMgr() {
    }

    public static ClientStateListenerMgr getInstance() {
        return instance;
    }

    public void registerListener(IClientClosedListener listener) {
        if (null == listener) {
            return;
        }
        this.clientStateListeners.put(listener.getListenerKey(), listener);
    }

    public void removeListener(String listenerKey) {
        if (null == listenerKey) {
            return;
        }
        this.clientStateListeners.remove(listenerKey);
    }

    public void notifyClientClose(QingContext qingContext, String clientID) {
        HashSet<IClientClosedListener> tmpListeners = new HashSet<IClientClosedListener>(this.clientStateListeners.values());
        for (IClientClosedListener listener : tmpListeners) {
            listener.onClientClosed(qingContext, clientID);
        }
    }
}

