/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.model.QingServiceSynDispatcherModel;
import com.kingdee.bos.qing.common.framework.server.IQingServerRequestDispatcher;
import com.kingdee.bos.qing.common.framework.server.dependency.QingServiceFactory;
import com.kingdee.bos.qing.common.framework.server.task.AsynServerRequestInvoker;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MethodInvokeUtil;

public abstract class AbstractQingServerRequestDispatcher
implements IQingServerRequestDispatcher {
    protected abstract QingContext getContext();

    protected boolean needAsyncStartTaskMgr() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] asynDispatcher(QingServiceAsynDispatcherModel model) {
        QingContext context = this.getContext();
        AsynServerRequestInvoker invokeAction = new AsynServerRequestInvoker(context, model);
        try {
            LogUtil.info("mservice node asynDispatcher call " + model.getCallID() + " start");
            if (this.needAsyncStartTaskMgr()) {
                // empty if block
            }
            byte[] byArray = invokeAction.invoke();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output(e);
            return byArray;
        }
        finally {
            LogUtil.info("mservice node asynDispatcher call " + model.getCallID() + " end");
        }
    }

    @Override
    public byte[] synDispatcher(QingServiceSynDispatcherModel model) {
        QingContext context = this.getContext();
        try {
            Object service = QingServiceFactory.getServiceImpl(model.getServiceType());
            return (byte[])MethodInvokeUtil.invoke(context, service, model.getMethodName(), model.getParameters());
        }
        catch (Exception e) {
            return ResponseUtil.output(e);
        }
    }
}

