/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.msgpublish;

import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.manage.ServerChannelManager;
import com.kingdee.bos.qing.common.framework.model.server.ServerChannelMessage;
import com.kingdee.bos.qing.common.framework.server.msgpublish.AppendCallIdAction;
import com.kingdee.bos.qing.common.framework.server.msgpublish.CallIdRemoveAction;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ClientCancelAction;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ServerChannelMessagePublisher {
    public static void clearServerChannelMessages(String clientID) {
        new ClientCancelAction(clientID).run();
    }

    public static List<ServerChannelMessage> getServerChannelMessages(String clientID) {
        ArrayList<ServerChannelMessage> channelMessages = new ArrayList<ServerChannelMessage>();
        if (ClientManager.isClientClosed(clientID, false, null)) {
            ServerChannelMessagePublisher.clearServerChannelMessages(clientID);
            return channelMessages;
        }
        String[] serverChannelCallIDs = ServerChannelManager.getServerChannelCallIDsValue(clientID);
        ArrayList<String> removeServerChannelCallIDs = new ArrayList<String>();
        for (String serverChannelCallID : serverChannelCallIDs) {
            if (!StringUtils.isNotBlank(serverChannelCallID)) continue;
            ServerChannelMessage serverChannelMessage = ServerChannelManager.getChannelMessage(clientID, serverChannelCallID);
            if (serverChannelMessage != null) {
                channelMessages.add(serverChannelMessage);
                continue;
            }
            removeServerChannelCallIDs.add(serverChannelCallID);
        }
        if (!removeServerChannelCallIDs.isEmpty()) {
            new CallIdRemoveAction(clientID, removeServerChannelCallIDs).run();
        }
        return channelMessages;
    }

    public static void publish(String channel, String messageContent) {
        String clientID = ServerRequestInvokeContext.staticGetClientID();
        ServerChannelMessagePublisher.publish(clientID, channel, messageContent);
    }

    public static void publish(String clientID, String channel, String messageContent) {
        if (StringUtils.isNotEmpty(clientID) && !ClientManager.isClientClosed(clientID, false, null)) {
            String callID = UUID.randomUUID().toString();
            ServerChannelMessage channelMessage = new ServerChannelMessage(clientID, callID, channel, System.currentTimeMillis(), messageContent);
            ServerChannelManager.saveChannelMessage(channelMessage);
            new AppendCallIdAction(clientID, callID).run();
        }
    }
}

